/*
 * Decompiled with CFR 0.152.
 */
package com.evento.parser.java;

import com.evento.parser.model.component.Component;
import com.evento.parser.model.handler.Handler;
import com.evento.parser.model.handler.HasCommandInvocations;
import com.evento.parser.model.handler.HasQueryInvocations;
import com.evento.parser.model.payload.Command;
import com.evento.parser.model.payload.Payload;
import com.evento.parser.model.payload.Query;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import org.jaxen.JaxenException;

public abstract class JavaComponentParser<T extends Component> {
    protected final Node node;

    public JavaComponentParser(Node node) {
        this.node = node;
    }

    public static boolean isObserver(ASTTypeDeclaration classDef) throws JaxenException {
        return !classDef.findChildNodesWithXPath("//Annotation//Name[@Image = \"Observer\"]").isEmpty();
    }

    public static boolean isSaga(ASTTypeDeclaration classDef) throws JaxenException {
        return !classDef.findChildNodesWithXPath("//Annotation//Name[@Image = \"Saga\"]").isEmpty();
    }

    public static boolean isAggregate(ASTTypeDeclaration classDef) throws JaxenException {
        return !classDef.findChildNodesWithXPath("//Name[@Image = \"Aggregate\"]").isEmpty();
    }

    public static boolean isProjection(ASTTypeDeclaration classDef) throws JaxenException {
        return !classDef.findChildNodesWithXPath("//Annotation//Name[@Image = \"Projection\"]").isEmpty();
    }

    public static boolean isProjector(ASTTypeDeclaration classDef) throws JaxenException {
        return !classDef.findChildNodesWithXPath("//Annotation//Name[@Image = \"Projector\"]").isEmpty();
    }

    public static boolean isService(ASTTypeDeclaration classDef) throws JaxenException {
        return !classDef.findChildNodesWithXPath("//Annotation//Name[@Image = \"Service\"]").isEmpty();
    }

    public static boolean isInvoker(ASTTypeDeclaration classDef) throws JaxenException {
        return !classDef.findChildNodesWithXPath("//Annotation//Name[@Image = \"Invoker\"]").isEmpty();
    }

    public abstract T parse() throws Exception;

    protected String getQueryForAnnotatedMethod(String annotation) {
        return "//ClassOrInterfaceBodyDeclaration[Annotation//Name[@Image=\"" + annotation + "\"] and MethodDeclaration]//MethodDeclaration";
    }

    protected String getDeclaredClassName() {
        return ((ASTClassOrInterfaceDeclaration)((ASTTypeDeclaration)this.node.getFirstDescendantOfType(ASTTypeDeclaration.class)).getFirstDescendantOfType(ASTClassOrInterfaceDeclaration.class)).getSimpleName();
    }

    protected void findCommandInvocations(List<? extends Handler<?>> ehs) throws JaxenException {
        String query = "//PrimaryExpression[PrimaryPrefix/Name[ends-with(@Image,\"send\") or ends-with(@Image,\"sendAndWait\")]] | //PrimaryExpression[PrimarySuffix[ends-with(@Image,\"send\") or ends-with(@Image,\"sendAndWait\")]]";
        for (Node n : ((ASTTypeDeclaration)this.node.getFirstChildOfType(ASTTypeDeclaration.class)).findChildNodesWithXPath(query)) {
            ASTPrimaryExpression expr = (ASTPrimaryExpression)n;
            ASTClassOrInterfaceType msgArg = (ASTClassOrInterfaceType)expr.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
            if (msgArg == null) {
                return;
            }
            String cmdName = msgArg.getImage();
            Command cmd = new Command(cmdName);
            Node methodOrConstructor = (Node)expr.getFirstParentOfType(ASTMethodDeclaration.class);
            if (methodOrConstructor == null) {
                methodOrConstructor = (Node)expr.getFirstParentOfType(ASTConstructorDeclaration.class);
            }
            this.manageMessageInvocation(methodOrConstructor, cmd, ehs, this.stack(expr));
        }
    }

    protected void findQueryInvocations(List<? extends Handler<?>> ehs) throws JaxenException {
        String query = "//PrimaryExpression[PrimaryPrefix/Name[ends-with(@Image,\"query\")]] | //PrimaryExpression[PrimarySuffix[ends-with(@Image,\"query\")]]";
        for (Node n : ((ASTTypeDeclaration)this.node.getFirstChildOfType(ASTTypeDeclaration.class)).findChildNodesWithXPath(query)) {
            ASTPrimaryExpression expr = (ASTPrimaryExpression)n;
            ASTClassOrInterfaceType type = (ASTClassOrInterfaceType)expr.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
            if (type == null) continue;
            String qName = type.getImage();
            Query q = new Query(qName, null);
            Node methodOrConstructor = (Node)expr.getFirstParentOfType(ASTMethodDeclaration.class);
            if (methodOrConstructor == null) {
                methodOrConstructor = (Node)expr.getFirstParentOfType(ASTConstructorDeclaration.class);
            }
            this.manageMessageInvocation(methodOrConstructor, q, ehs, this.stack(expr));
        }
    }

    private Stack<ASTPrimaryExpression> stack(ASTPrimaryExpression expression) {
        Stack<ASTPrimaryExpression> s = new Stack<ASTPrimaryExpression>();
        s.add(expression);
        return s;
    }

    private void manageMessageInvocation(Node methodOrConstructor, Payload m, List<? extends Handler<?>> hs, Stack<ASTPrimaryExpression> expr) throws JaxenException {
        Optional<String> annot = ((ASTClassOrInterfaceBodyDeclaration)methodOrConstructor.getFirstParentOfType(ASTClassOrInterfaceBodyDeclaration.class)).findChildNodesWithXPath("Annotation//Name[ends-with(@Image,\"Handler\") and not(starts-with(@Image,'Deadline'))]").stream().map(Node::getImage).filter(Objects::nonNull).filter(n -> n.equals("AggregateCommandHandler") || n.equals("CommandHandler") || n.equals("EventHandler") || n.equals("EventSourcingHandler") || n.equals("InvocationHandler") || n.equals("QueryHandler") || n.equals("SagaEventHandler")).findFirst();
        if (annot.isPresent()) {
            Object name = annot.get().equals("InvocationHandler") ? ((ASTClassOrInterfaceDeclaration)methodOrConstructor.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class)).getSimpleName() + "::" + ((ASTMethodDeclaration)methodOrConstructor).getName() : ((ASTClassOrInterfaceType)((ASTFormalParameters)methodOrConstructor.getFirstDescendantOfType(ASTFormalParameters.class)).getFirstDescendantOfType(ASTClassOrInterfaceType.class)).getImage();
            hs.stream().filter(arg_0 -> JavaComponentParser.lambda$manageMessageInvocation$1((String)name, arg_0)).forEach(h -> {
                if (m instanceof Query) {
                    Query q = (Query)m;
                    if (h instanceof HasQueryInvocations) {
                        HasQueryInvocations qi = (HasQueryInvocations)((Object)h);
                        qi.addQueryInvocation(q, ((ASTPrimaryExpression)expr.peek()).getBeginLine());
                    }
                }
                if (m instanceof Command) {
                    Command c = (Command)m;
                    if (h instanceof HasCommandInvocations) {
                        HasCommandInvocations ci = (HasCommandInvocations)((Object)h);
                        ci.addCommandInvocation(c, ((ASTPrimaryExpression)expr.peek()).getBeginLine());
                    }
                }
            });
            return;
        }
        String mName = methodOrConstructor instanceof ASTMethodDeclaration ? ((ASTMethodDeclaration)methodOrConstructor).getName() : methodOrConstructor.getImage();
        List invocations = ((ASTTypeDeclaration)this.node.getFirstChildOfType(ASTTypeDeclaration.class)).findChildNodesWithXPath("//PrimaryPrefix/Name[@Image = \"%s\"]".formatted(mName));
        for (Node i : invocations) {
            ASTMethodDeclaration mt = (ASTMethodDeclaration)i.getFirstParentOfType(ASTMethodDeclaration.class);
            if (mt == null) {
                return;
            }
            Stack<ASTPrimaryExpression> nExpr = new Stack<ASTPrimaryExpression>();
            nExpr.addAll(expr);
            nExpr.add((ASTPrimaryExpression)i.getFirstParentOfType(ASTPrimaryExpression.class));
            this.manageMessageInvocation((Node)mt, m, hs, nExpr);
        }
    }

    private static /* synthetic */ boolean lambda$manageMessageInvocation$1(String name, Handler eh) {
        return ((Payload)eh.getPayload()).getName().equals(name);
    }
}

