/*
 * Decompiled with CFR 0.152.
 */
package com.evento.parser.java;

import com.evento.parser.java.JavaComponentParser;
import com.evento.parser.model.component.Aggregate;
import com.evento.parser.model.handler.AggregateCommandHandler;
import com.evento.parser.model.handler.EventSourcingHandler;
import com.evento.parser.model.payload.DomainCommand;
import com.evento.parser.model.payload.DomainEvent;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import org.jaxen.JaxenException;

public class JavaAggregateParser
extends JavaComponentParser<Aggregate> {
    public JavaAggregateParser(Node node) {
        super(node);
    }

    private List<AggregateCommandHandler> findAggregateCommandHandler() throws JaxenException {
        String query = this.getQueryForAnnotatedMethod("AggregateCommandHandler");
        return ((ASTTypeDeclaration)this.node.getFirstChildOfType(ASTTypeDeclaration.class)).findChildNodesWithXPath(query).stream().map(n -> {
            ASTMethodDeclaration md = (ASTMethodDeclaration)n;
            String commandName = ((ASTClassOrInterfaceType)md.getFormalParameters().getFirstDescendantOfType(ASTClassOrInterfaceType.class)).getImage();
            String eventName = ((ASTClassOrInterfaceType)md.getResultType().getFirstDescendantOfType(ASTClassOrInterfaceType.class)).getImage();
            return new AggregateCommandHandler(new DomainCommand(commandName), new DomainEvent(eventName), n.getBeginLine());
        }).collect(Collectors.toList());
    }

    private List<EventSourcingHandler> findEventSourcingHandlers() throws JaxenException {
        String query = this.getQueryForAnnotatedMethod("EventSourcingHandler");
        return ((ASTTypeDeclaration)this.node.getFirstChildOfType(ASTTypeDeclaration.class)).findChildNodesWithXPath(query).stream().map(n -> {
            ASTMethodDeclaration md = (ASTMethodDeclaration)n;
            String name = ((ASTClassOrInterfaceType)md.getFormalParameters().getFirstDescendantOfType(ASTClassOrInterfaceType.class)).getImage();
            return new EventSourcingHandler(new DomainEvent(name), n.getBeginLine());
        }).collect(Collectors.toList());
    }

    @Override
    public Aggregate parse() throws Exception {
        Aggregate aggregate = new Aggregate();
        aggregate.setComponentName(this.getDeclaredClassName());
        aggregate.setAggregateCommandHandlers(this.findAggregateCommandHandler());
        aggregate.setEventSourcingHandlers(this.findEventSourcingHandlers());
        this.findCommandInvocations(aggregate.getAggregateCommandHandlers());
        this.findQueryInvocations(aggregate.getAggregateCommandHandlers());
        return aggregate;
    }
}

