/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.telemetry.internal;

import androidx.annotation.AnyThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.EventType;
import com.datadog.android.core.InternalSdkCore;
import com.datadog.android.core.sampling.RateBasedSampler;
import com.datadog.android.core.sampling.Sampler;
import com.datadog.android.internal.telemetry.InternalTelemetryEvent;
import com.datadog.android.rum.RumSessionListener;
import com.datadog.android.rum.configuration.VitalsUpdateFrequency;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.metric.SessionMetricDispatcher;
import com.datadog.android.rum.internal.utils.NumberExtKt;
import com.datadog.android.rum.tracking.ActivityViewTrackingStrategy;
import com.datadog.android.rum.tracking.FragmentViewTrackingStrategy;
import com.datadog.android.rum.tracking.MixedViewTrackingStrategy;
import com.datadog.android.rum.tracking.NavigationViewTrackingStrategy;
import com.datadog.android.rum.tracking.ViewTrackingStrategy;
import com.datadog.android.telemetry.internal.TelemetryEventExtKt;
import com.datadog.android.telemetry.internal.TelemetryEventHandler;
import com.datadog.android.telemetry.internal.TelemetryEventId;
import com.datadog.android.telemetry.internal.TelemetryEventIdKt;
import com.datadog.android.telemetry.model.TelemetryConfigurationEvent;
import com.datadog.android.telemetry.model.TelemetryDebugEvent;
import com.datadog.android.telemetry.model.TelemetryErrorEvent;
import com.datadog.android.telemetry.model.TelemetryUsageEvent;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 Q2\u00020\u0001:\u0002QRB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J3\u0010\u001e\u001a\u00020\u001f2\u0018\b\u0002\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010#\u0018\u00010!2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010%J(\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001fH\u0002J(\u0010.\u001a\u00020/2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001d\u001a\u0002002\u0006\u0010-\u001a\u00020\u001fH\u0002J@\u00101\u001a\u0002022\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u00103\u001a\u00020\"2\u0016\u00104\u001a\u0012\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010#\u0018\u00010!2\u0006\u0010-\u001a\u00020\u001fH\u0002JT\u00105\u001a\u0002062\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u00103\u001a\u00020\"2\b\u00107\u001a\u0004\u0018\u00010\"2\b\u00108\u001a\u0004\u0018\u00010\"2\u0006\u0010-\u001a\u00020\u001f2\u0016\u00104\u001a\u0012\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010#\u0018\u00010!H\u0002J\u001e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020#0>H\u0007J\b\u0010?\u001a\u00020\u001bH\u0002J\u0010\u0010@\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u001e\u0010A\u001a\u00020\u001b2\u0014\u0010B\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010#0!H\u0002J\u0018\u0010C\u001a\u00020:2\u0006\u0010D\u001a\u00020\"2\u0006\u0010E\u001a\u00020\u001bH\u0016J*\u0010F\u001a\u0004\u0018\u00010\"2\b\u0010G\u001a\u0004\u0018\u00010H2\u0014\u0010B\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010#0!H\u0002J \u0010I\u001a\u0004\u0018\u00010H2\u0014\u0010B\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010#0!H\u0002J(\u0010J\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010#0K*\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010#0!H\u0002J)\u0010L\u001a\u0004\u0018\u00010\u001f*\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010#0!2\u0006\u0010M\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010NJ\f\u0010O\u001a\u00020P*\u00020)H\u0002R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/datadog/android/telemetry/internal/TelemetryEventHandler;", "Lcom/datadog/android/rum/RumSessionListener;", "sdkCore", "Lcom/datadog/android/core/InternalSdkCore;", "eventSampler", "Lcom/datadog/android/core/sampling/Sampler;", "Lcom/datadog/android/internal/telemetry/InternalTelemetryEvent;", "configurationExtraSampler", "sessionEndedMetricDispatcher", "Lcom/datadog/android/rum/internal/metric/SessionMetricDispatcher;", "maxEventCountPerSession", "", "(Lcom/datadog/android/core/InternalSdkCore;Lcom/datadog/android/core/sampling/Sampler;Lcom/datadog/android/core/sampling/Sampler;Lcom/datadog/android/rum/internal/metric/SessionMetricDispatcher;I)V", "getConfigurationExtraSampler$dd_sdk_android_rum_release", "()Lcom/datadog/android/core/sampling/Sampler;", "eventIDsSeenInCurrentSession", "", "Lcom/datadog/android/telemetry/internal/TelemetryEventId;", "getEventSampler$dd_sdk_android_rum_release", "rumConfig", "Lcom/datadog/android/rum/internal/RumFeature$Configuration;", "getRumConfig", "()Lcom/datadog/android/rum/internal/RumFeature$Configuration;", "getSdkCore$dd_sdk_android_rum_release", "()Lcom/datadog/android/core/InternalSdkCore;", "totalEventsSeenInCurrentSession", "trackNetworkRequests", "", "canWrite", "event", "computeEffectiveSampleRate", "", "properties", "", "", "", "eventSpecificSamplingRate", "(Ljava/util/Map;Ljava/lang/Float;)F", "createApiUsageEvent", "Lcom/datadog/android/telemetry/model/TelemetryUsageEvent;", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "timestamp", "", "Lcom/datadog/android/internal/telemetry/InternalTelemetryEvent$ApiUsage;", "effectiveSampleRate", "createConfigurationEvent", "Lcom/datadog/android/telemetry/model/TelemetryConfigurationEvent;", "Lcom/datadog/android/internal/telemetry/InternalTelemetryEvent$Configuration;", "createDebugEvent", "Lcom/datadog/android/telemetry/model/TelemetryDebugEvent;", "message", "additionalProperties", "createErrorEvent", "Lcom/datadog/android/telemetry/model/TelemetryErrorEvent;", "stack", "kind", "handleEvent", "", "wrappedEvent", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$TelemetryEventWrapper;", "writer", "Lcom/datadog/android/api/storage/DataWriter;", "isGlobalTracerRegistered", "isLog", "isOpenTelemetryRegistered", "traceContext", "onSessionStarted", "sessionId", "isDiscarded", "resolveOpenTelemetryApiVersion", "tracerApi", "Lcom/datadog/android/telemetry/internal/TelemetryEventHandler$TracerApi;", "resolveTracerApi", "cleanUpInternalAttributes", "", "getFloat", "key", "(Ljava/util/Map;Ljava/lang/String;)Ljava/lang/Float;", "rumContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "Companion", "TracerApi", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nTelemetryEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelemetryEventHandler.kt\ncom/datadog/android/telemetry/internal/TelemetryEventHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,522:1\n1#2:523\n*E\n"})
public final class TelemetryEventHandler
implements RumSessionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalSdkCore sdkCore;
    @NotNull
    private final Sampler<InternalTelemetryEvent> eventSampler;
    @NotNull
    private final Sampler<InternalTelemetryEvent> configurationExtraSampler;
    @NotNull
    private final SessionMetricDispatcher sessionEndedMetricDispatcher;
    private final int maxEventCountPerSession;
    private boolean trackNetworkRequests;
    @NotNull
    private final Set<TelemetryEventId> eventIDsSeenInCurrentSession;
    private int totalEventsSeenInCurrentSession;
    public static final int MAX_EVENTS_PER_SESSION = 100;
    public static final float DEFAULT_CONFIGURATION_SAMPLE_RATE = 20.0f;
    @NotNull
    public static final String ALREADY_SEEN_EVENT_MESSAGE = "Already seen telemetry event with identity=%s, rejecting.";
    @NotNull
    public static final String MAX_EVENT_NUMBER_REACHED_MESSAGE = "Max number of telemetry events per session reached, rejecting.";
    @NotNull
    public static final String TELEMETRY_SERVICE_NAME = "dd-sdk-android";
    @NotNull
    public static final String IS_OPENTELEMETRY_ENABLED_CONTEXT_KEY = "is_opentelemetry_enabled";
    @NotNull
    public static final String OPENTELEMETRY_API_VERSION_CONTEXT_KEY = "opentelemetry_api_version";
    @NotNull
    public static final String SESSION_REPLAY_SAMPLE_RATE_KEY = "session_replay_sample_rate";
    @NotNull
    public static final String SESSION_REPLAY_TEXT_AND_INPUT_PRIVACY_KEY = "session_replay_text_and_input_privacy";
    @NotNull
    public static final String SESSION_REPLAY_IMAGE_PRIVACY_KEY = "session_replay_image_privacy";
    @NotNull
    public static final String SESSION_REPLAY_TOUCH_PRIVACY_KEY = "session_replay_touch_privacy";
    @NotNull
    public static final String SESSION_REPLAY_START_IMMEDIATE_RECORDING_KEY = "session_replay_start_immediate_recording";

    public TelemetryEventHandler(@NotNull InternalSdkCore sdkCore, @NotNull Sampler<InternalTelemetryEvent> eventSampler, @NotNull Sampler<InternalTelemetryEvent> configurationExtraSampler, @NotNull SessionMetricDispatcher sessionEndedMetricDispatcher, int maxEventCountPerSession) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(eventSampler, (String)"eventSampler");
        Intrinsics.checkNotNullParameter(configurationExtraSampler, (String)"configurationExtraSampler");
        Intrinsics.checkNotNullParameter((Object)sessionEndedMetricDispatcher, (String)"sessionEndedMetricDispatcher");
        this.sdkCore = sdkCore;
        this.eventSampler = eventSampler;
        this.configurationExtraSampler = configurationExtraSampler;
        this.sessionEndedMetricDispatcher = sessionEndedMetricDispatcher;
        this.maxEventCountPerSession = maxEventCountPerSession;
        this.eventIDsSeenInCurrentSession = new LinkedHashSet();
    }

    public /* synthetic */ TelemetryEventHandler(InternalSdkCore internalSdkCore, Sampler sampler, Sampler sampler2, SessionMetricDispatcher sessionMetricDispatcher, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            sampler2 = (Sampler)new RateBasedSampler(20.0f);
        }
        if ((n2 & 0x10) != 0) {
            n = 100;
        }
        this(internalSdkCore, (Sampler<InternalTelemetryEvent>)sampler, (Sampler<InternalTelemetryEvent>)sampler2, sessionMetricDispatcher, n);
    }

    @NotNull
    public final InternalSdkCore getSdkCore$dd_sdk_android_rum_release() {
        return this.sdkCore;
    }

    @NotNull
    public final Sampler<InternalTelemetryEvent> getEventSampler$dd_sdk_android_rum_release() {
        return this.eventSampler;
    }

    @NotNull
    public final Sampler<InternalTelemetryEvent> getConfigurationExtraSampler$dd_sdk_android_rum_release() {
        return this.configurationExtraSampler;
    }

    private final RumFeature.Configuration getRumConfig() {
        RumFeature rumFeature2;
        FeatureScope featureScope = this.sdkCore.getFeature("rum");
        return featureScope != null && (rumFeature2 = (RumFeature)featureScope.unwrap()) != null ? rumFeature2.getConfiguration$dd_sdk_android_rum_release() : null;
    }

    @AnyThread
    public final void handleEvent(@NotNull RumRawEvent.TelemetryEventWrapper wrappedEvent, @NotNull DataWriter<Object> writer) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)wrappedEvent, (String)"wrappedEvent");
            Intrinsics.checkNotNullParameter(writer, (String)"writer");
            InternalTelemetryEvent event = wrappedEvent.getEvent();
            if (!this.canWrite(event)) {
                return;
            }
            this.eventIDsSeenInCurrentSession.add(TelemetryEventIdKt.getIdentity(event));
            int n = this.totalEventsSeenInCurrentSession;
            this.totalEventsSeenInCurrentSession = n + 1;
            FeatureScope featureScope = this.sdkCore.getFeature("rum");
            if (featureScope == null) break block1;
            FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)featureScope, (boolean)false, (Function2)((Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(wrappedEvent, event, this, writer){
                final /* synthetic */ RumRawEvent.TelemetryEventWrapper $wrappedEvent;
                final /* synthetic */ InternalTelemetryEvent $event;
                final /* synthetic */ TelemetryEventHandler this$0;
                final /* synthetic */ DataWriter<Object> $writer;
                {
                    this.$wrappedEvent = $wrappedEvent;
                    this.$event = $event;
                    this.this$0 = $receiver;
                    this.$writer = $writer;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    long timestamp = this.$wrappedEvent.getEventTime().getTimestamp() + datadogContext.getTime().getServerTimeOffsetMs();
                    InternalTelemetryEvent internalTelemetryEvent = this.$event;
                    if (internalTelemetryEvent instanceof InternalTelemetryEvent.Log.Debug) {
                        object = TelemetryEventHandler.access$createDebugEvent(this.this$0, datadogContext, timestamp, ((InternalTelemetryEvent.Log.Debug)this.$event).getMessage(), ((InternalTelemetryEvent.Log.Debug)this.$event).getAdditionalProperties(), TelemetryEventHandler.computeEffectiveSampleRate$default(this.this$0, ((InternalTelemetryEvent.Log.Debug)this.$event).getAdditionalProperties(), null, 2, null));
                    } else if (internalTelemetryEvent instanceof InternalTelemetryEvent.Metric) {
                        object = TelemetryEventHandler.access$createDebugEvent(this.this$0, datadogContext, timestamp, ((InternalTelemetryEvent.Metric)this.$event).getMessage(), ((InternalTelemetryEvent.Metric)this.$event).getAdditionalProperties(), TelemetryEventHandler.computeEffectiveSampleRate$default(this.this$0, ((InternalTelemetryEvent.Metric)this.$event).getAdditionalProperties(), null, 2, null));
                    } else if (internalTelemetryEvent instanceof InternalTelemetryEvent.Log.Error) {
                        TelemetryEventHandler.access$getSessionEndedMetricDispatcher$p(this.this$0).onSdkErrorTracked(TelemetryEventHandler.access$rumContext(this.this$0, datadogContext).getSessionId(), ((InternalTelemetryEvent.Log.Error)this.$event).getKind());
                        String string = ((InternalTelemetryEvent.Log.Error)this.$event).getMessage();
                        String string2 = ((InternalTelemetryEvent.Log.Error)this.$event).resolveStacktrace();
                        String string3 = ((InternalTelemetryEvent.Log.Error)this.$event).resolveKind();
                        Map map = ((InternalTelemetryEvent.Log.Error)this.$event).getAdditionalProperties();
                        float f = TelemetryEventHandler.computeEffectiveSampleRate$default(this.this$0, ((InternalTelemetryEvent.Log.Error)this.$event).getAdditionalProperties(), null, 2, null);
                        object = TelemetryEventHandler.access$createErrorEvent(this.this$0, datadogContext, timestamp, string, string2, string3, f, map);
                    } else if (internalTelemetryEvent instanceof InternalTelemetryEvent.Configuration) {
                        RumFeature.Configuration configuration = TelemetryEventHandler.access$getRumConfig(this.this$0);
                        object = TelemetryEventHandler.access$createConfigurationEvent(this.this$0, datadogContext, timestamp, (InternalTelemetryEvent.Configuration)this.$event, TelemetryEventHandler.computeEffectiveSampleRate$default(this.this$0, null, configuration != null ? Float.valueOf(configuration.getTelemetryConfigurationSampleRate()) : null, 1, null));
                    } else if (internalTelemetryEvent instanceof InternalTelemetryEvent.ApiUsage) {
                        object = TelemetryEventHandler.access$createApiUsageEvent(this.this$0, datadogContext, timestamp, (InternalTelemetryEvent.ApiUsage)this.$event, TelemetryEventHandler.computeEffectiveSampleRate$default(this.this$0, ((InternalTelemetryEvent.ApiUsage)this.$event).getAdditionalProperties(), null, 2, null));
                    } else if (internalTelemetryEvent instanceof InternalTelemetryEvent.InterceptorInstantiated) {
                        TelemetryEventHandler.access$setTrackNetworkRequests$p(this.this$0, true);
                        object = null;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    TelemetryDebugEvent telemetryEvent = object;
                    if (telemetryEvent != null) {
                        this.$writer.write(eventBatchWriter, (Object)telemetryEvent, EventType.TELEMETRY);
                    }
                }
            }), (int)1, null);
        }
    }

    @Override
    public void onSessionStarted(@NotNull String sessionId, boolean isDiscarded) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        this.eventIDsSeenInCurrentSession.clear();
        this.totalEventsSeenInCurrentSession = 0;
    }

    private final boolean canWrite(InternalTelemetryEvent event) {
        if (!this.eventSampler.sample((Object)event)) {
            return false;
        }
        if (event instanceof InternalTelemetryEvent.Configuration && !this.configurationExtraSampler.sample((Object)event)) {
            return false;
        }
        TelemetryEventId eventIdentity = TelemetryEventIdKt.getIdentity(event);
        if (this.isLog(event) && this.eventIDsSeenInCurrentSession.contains(eventIdentity)) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)((Function0)new Function0<String>(eventIdentity){
                final /* synthetic */ TelemetryEventId $eventIdentity;
                {
                    this.$eventIdentity = $eventIdentity;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Already seen telemetry event with identity=%s, rejecting.";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$eventIdentity};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
            return false;
        }
        if (this.totalEventsSeenInCurrentSession >= this.maxEventCountPerSession) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)canWrite.2.INSTANCE, null, (boolean)false, null, (int)56, null);
            return false;
        }
        return true;
    }

    private final boolean isLog(InternalTelemetryEvent event) {
        return event instanceof InternalTelemetryEvent.Log;
    }

    private final TelemetryDebugEvent createDebugEvent(DatadogContext datadogContext, long timestamp, String message2, Map<String, ? extends Object> additionalProperties, float effectiveSampleRate) {
        TelemetryDebugEvent.Action action;
        TelemetryDebugEvent.View view;
        RumContext rumContext = this.rumContext(datadogContext);
        Map map = additionalProperties;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map<String, Object> resolvedAdditionalProperties = this.cleanUpInternalAttributes(MapsKt.toMutableMap(map));
        TelemetryDebugEvent.Dd dd = new TelemetryDebugEvent.Dd();
        TelemetryDebugEvent.Source source = TelemetryEventExtKt.tryFromSource(TelemetryDebugEvent.Source.Companion, datadogContext.getSource(), this.sdkCore.getInternalLogger());
        if (source == null) {
            source = TelemetryDebugEvent.Source.ANDROID;
        }
        TelemetryDebugEvent.Source source2 = source;
        String string = datadogContext.getSdkVersion();
        TelemetryDebugEvent.Application application = new TelemetryDebugEvent.Application(rumContext.getApplicationId());
        TelemetryDebugEvent.Session session = new TelemetryDebugEvent.Session(rumContext.getSessionId());
        String string2 = rumContext.getViewId();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            view = new TelemetryDebugEvent.View(it);
        } else {
            view = null;
        }
        TelemetryDebugEvent.View view2 = view;
        String string3 = rumContext.getActionId();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            action = new TelemetryDebugEvent.Action(it);
        } else {
            action = null;
        }
        TelemetryDebugEvent.Action action2 = action;
        TelemetryDebugEvent.Device device = new TelemetryDebugEvent.Device(datadogContext.getDeviceInfo().getArchitecture(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getDeviceModel());
        String string4 = datadogContext.getDeviceInfo().getDeviceBuildId();
        String string5 = datadogContext.getDeviceInfo().getOsVersion();
        String string6 = datadogContext.getDeviceInfo().getOsName();
        TelemetryDebugEvent.Os os = new TelemetryDebugEvent.Os(string4, string6, string5);
        TelemetryDebugEvent.Telemetry telemetry = new TelemetryDebugEvent.Telemetry(device, os, message2, resolvedAdditionalProperties);
        return new TelemetryDebugEvent(dd, timestamp, TELEMETRY_SERVICE_NAME, source2, string, application, session, view2, action2, Float.valueOf(effectiveSampleRate), null, telemetry, 1024, null);
    }

    private final TelemetryErrorEvent createErrorEvent(DatadogContext datadogContext, long timestamp, String message2, String stack, String kind, float effectiveSampleRate, Map<String, ? extends Object> additionalProperties) {
        TelemetryErrorEvent.Action action;
        TelemetryErrorEvent.View view;
        RumContext rumContext = this.rumContext(datadogContext);
        Map map = additionalProperties;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map<String, Object> resolvedAdditionalProperties = this.cleanUpInternalAttributes(MapsKt.toMutableMap(map));
        TelemetryErrorEvent.Dd dd = new TelemetryErrorEvent.Dd();
        TelemetryErrorEvent.Source source = TelemetryEventExtKt.tryFromSource(TelemetryErrorEvent.Source.Companion, datadogContext.getSource(), this.sdkCore.getInternalLogger());
        if (source == null) {
            source = TelemetryErrorEvent.Source.ANDROID;
        }
        TelemetryErrorEvent.Source source2 = source;
        String string = datadogContext.getSdkVersion();
        TelemetryErrorEvent.Application application = new TelemetryErrorEvent.Application(rumContext.getApplicationId());
        TelemetryErrorEvent.Session session = new TelemetryErrorEvent.Session(rumContext.getSessionId());
        String string2 = rumContext.getViewId();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            view = new TelemetryErrorEvent.View(it);
        } else {
            view = null;
        }
        TelemetryErrorEvent.View view2 = view;
        String string3 = rumContext.getActionId();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            action = new TelemetryErrorEvent.Action(it);
        } else {
            action = null;
        }
        TelemetryErrorEvent.Action action2 = action;
        TelemetryErrorEvent.Error error = stack != null || kind != null ? new TelemetryErrorEvent.Error(stack, kind) : null;
        TelemetryErrorEvent.Device device = new TelemetryErrorEvent.Device(datadogContext.getDeviceInfo().getArchitecture(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getDeviceModel());
        String string4 = datadogContext.getDeviceInfo().getDeviceBuildId();
        String string5 = datadogContext.getDeviceInfo().getOsVersion();
        String string6 = datadogContext.getDeviceInfo().getOsName();
        TelemetryErrorEvent.Os os = new TelemetryErrorEvent.Os(string4, string6, string5);
        TelemetryErrorEvent.Telemetry telemetry = new TelemetryErrorEvent.Telemetry(device, os, message2, error, resolvedAdditionalProperties);
        return new TelemetryErrorEvent(dd, timestamp, TELEMETRY_SERVICE_NAME, source2, string, application, session, view2, action2, Float.valueOf(effectiveSampleRate), null, telemetry, 1024, null);
    }

    private final TelemetryConfigurationEvent createConfigurationEvent(DatadogContext datadogContext, long timestamp, InternalTelemetryEvent.Configuration event, float effectiveSampleRate) {
        TelemetryConfigurationEvent.Action action;
        TelemetryConfigurationEvent.View view;
        ViewTrackingStrategy viewTrackingStrategy;
        FeatureScope traceFeature = this.sdkCore.getFeature("tracing");
        Map sessionReplayFeatureContext = this.sdkCore.getFeatureContext("session-replay");
        Object v = sessionReplayFeatureContext.get(SESSION_REPLAY_SAMPLE_RATE_KEY);
        Long sessionReplaySampleRate = v instanceof Long ? (Long)v : null;
        Object v2 = sessionReplayFeatureContext.get(SESSION_REPLAY_START_IMMEDIATE_RECORDING_KEY);
        Boolean startRecordingImmediately = v2 instanceof Boolean ? (Boolean)v2 : null;
        Object v3 = sessionReplayFeatureContext.get(SESSION_REPLAY_IMAGE_PRIVACY_KEY);
        String sessionReplayImagePrivacy = v3 instanceof String ? (String)v3 : null;
        Object v4 = sessionReplayFeatureContext.get(SESSION_REPLAY_TOUCH_PRIVACY_KEY);
        String sessionReplayTouchPrivacy = v4 instanceof String ? (String)v4 : null;
        Object v5 = sessionReplayFeatureContext.get(SESSION_REPLAY_TEXT_AND_INPUT_PRIVACY_KEY);
        String sessionReplayTextAndInputPrivacy = v5 instanceof String ? (String)v5 : null;
        RumFeature.Configuration configuration = this.getRumConfig();
        ViewTrackingStrategy viewTrackingStrategy2 = viewTrackingStrategy = configuration != null ? configuration.getViewTrackingStrategy() : null;
        TelemetryConfigurationEvent.ViewTrackingStrategy viewTrackingStrategy3 = viewTrackingStrategy instanceof ActivityViewTrackingStrategy ? TelemetryConfigurationEvent.ViewTrackingStrategy.ACTIVITYVIEWTRACKINGSTRATEGY : (viewTrackingStrategy instanceof FragmentViewTrackingStrategy ? TelemetryConfigurationEvent.ViewTrackingStrategy.FRAGMENTVIEWTRACKINGSTRATEGY : (viewTrackingStrategy instanceof MixedViewTrackingStrategy ? TelemetryConfigurationEvent.ViewTrackingStrategy.MIXEDVIEWTRACKINGSTRATEGY : (viewTrackingStrategy instanceof NavigationViewTrackingStrategy ? TelemetryConfigurationEvent.ViewTrackingStrategy.NAVIGATIONVIEWTRACKINGSTRATEGY : null)));
        RumContext rumContext = this.rumContext(datadogContext);
        Map traceContext = this.sdkCore.getFeatureContext("tracing");
        TracerApi tracerApi = this.resolveTracerApi(traceContext);
        String openTelemetryApiVersion = this.resolveOpenTelemetryApiVersion(tracerApi, traceContext);
        boolean useTracing = traceFeature != null && tracerApi != null;
        TelemetryConfigurationEvent.Dd dd = new TelemetryConfigurationEvent.Dd();
        TelemetryConfigurationEvent.Source source = TelemetryEventExtKt.tryFromSource(TelemetryConfigurationEvent.Source.Companion, datadogContext.getSource(), this.sdkCore.getInternalLogger());
        if (source == null) {
            source = TelemetryConfigurationEvent.Source.ANDROID;
        }
        TelemetryConfigurationEvent.Source source2 = source;
        String string = datadogContext.getSdkVersion();
        TelemetryConfigurationEvent.Application application = new TelemetryConfigurationEvent.Application(rumContext.getApplicationId());
        TelemetryConfigurationEvent.Session session = new TelemetryConfigurationEvent.Session(rumContext.getSessionId());
        String string2 = rumContext.getViewId();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            view = new TelemetryConfigurationEvent.View(it);
        } else {
            view = null;
        }
        TelemetryConfigurationEvent.View view2 = view;
        String string3 = rumContext.getActionId();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            action = new TelemetryConfigurationEvent.Action(it);
        } else {
            action = null;
        }
        TelemetryConfigurationEvent.Action action2 = action;
        Object object = datadogContext.getDeviceInfo().getDeviceBuildId();
        Object object2 = datadogContext.getDeviceInfo().getOsVersion();
        String string4 = datadogContext.getDeviceInfo().getOsName();
        TelemetryConfigurationEvent.Os os = new TelemetryConfigurationEvent.Os((String)object, string4, (String)object2);
        RumFeature.Configuration configuration2 = this.getRumConfig();
        object = configuration2 != null ? Long.valueOf((long)configuration2.getSampleRate()) : null;
        RumFeature.Configuration configuration3 = this.getRumConfig();
        object2 = configuration3 != null ? Long.valueOf((long)configuration3.getTelemetrySampleRate()) : null;
        boolean bl = event.getUseProxy();
        RumFeature.Configuration configuration4 = this.getRumConfig();
        Boolean bl2 = configuration4 != null ? Boolean.valueOf(configuration4.getTrackFrustrations()) : null;
        boolean bl3 = event.getUseLocalEncryption();
        RumFeature.Configuration configuration5 = this.getRumConfig();
        Boolean bl4 = configuration5 != null ? Boolean.valueOf(configuration5.getBackgroundEventTracking()) : null;
        RumFeature.Configuration configuration6 = this.getRumConfig();
        boolean bl5 = (configuration6 != null ? Boolean.valueOf(configuration6.getUserActionTracking()) : null) != null;
        boolean bl6 = event.getTrackErrors();
        RumFeature.Configuration configuration7 = this.getRumConfig();
        boolean bl7 = (configuration7 != null ? configuration7.getLongTaskTrackingStrategy() : null) != null;
        long l = event.getBatchSize();
        long l2 = event.getBatchUploadFrequency();
        Object object3 = this.getRumConfig();
        Long l3 = object3 != null && (object3 = ((RumFeature.Configuration)object3).getVitalsMonitorUpdateFrequency()) != null ? Long.valueOf(((VitalsUpdateFrequency)((Object)object3)).getPeriodInMs$dd_sdk_android_rum_release()) : null;
        TracerApi tracerApi2 = tracerApi;
        String string5 = tracerApi2 != null ? tracerApi2.name() : null;
        boolean bl8 = this.trackNetworkRequests;
        long l4 = event.getBatchProcessingLevel();
        boolean bl9 = datadogContext.getProcessInfo().isMainProcess();
        TelemetryConfigurationEvent.Telemetry telemetry = new TelemetryConfigurationEvent.Telemetry(new TelemetryConfigurationEvent.Device(datadogContext.getDeviceInfo().getArchitecture(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getDeviceModel()), os, new TelemetryConfigurationEvent.Configuration((Long)object, (Long)object2, null, null, null, null, null, null, sessionReplaySampleRate, null, null, startRecordingImmediately, bl, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, sessionReplayTextAndInputPrivacy, sessionReplayImagePrivacy, sessionReplayTouchPrivacy, null, null, null, null, bl2, null, bl5, null, null, null, null, bl3, viewTrackingStrategy3, bl4, l3, bl6, bl8, useTracing, null, null, bl7, null, null, null, null, l, l2, l4, null, null, null, null, null, null, null, string5, openTelemetryApiVersion, null, null, bl9, null, 536864508, -236189777, 359, null), null, 8, null);
        return new TelemetryConfigurationEvent(dd, timestamp, TELEMETRY_SERVICE_NAME, source2, string, application, session, view2, action2, Float.valueOf(effectiveSampleRate), null, telemetry);
    }

    private final TelemetryUsageEvent createApiUsageEvent(DatadogContext datadogContext, long timestamp, InternalTelemetryEvent.ApiUsage event, float effectiveSampleRate) {
        TelemetryUsageEvent.Action action;
        TelemetryUsageEvent.View view;
        TelemetryUsageEvent.Session session;
        TelemetryUsageEvent.Application application;
        String string;
        TelemetryUsageEvent.Source source;
        TelemetryUsageEvent.Dd dd;
        Map<String, Object> resolvedAdditionalProperties;
        RumContext rumContext = this.rumContext(datadogContext);
        if (event instanceof InternalTelemetryEvent.ApiUsage.AddViewLoadingTime) {
            TelemetryUsageEvent.View view2;
            resolvedAdditionalProperties = this.cleanUpInternalAttributes(event.getAdditionalProperties());
            dd = new TelemetryUsageEvent.Dd();
            TelemetryUsageEvent.Source source2 = TelemetryEventExtKt.tryFromSource(TelemetryUsageEvent.Source.Companion, datadogContext.getSource(), this.sdkCore.getInternalLogger());
            if (source2 == null) {
                source2 = TelemetryUsageEvent.Source.ANDROID;
            }
            source = source2;
            string = datadogContext.getSdkVersion();
            application = new TelemetryUsageEvent.Application(rumContext.getApplicationId());
            session = new TelemetryUsageEvent.Session(rumContext.getSessionId());
            String string2 = rumContext.getViewId();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                view2 = new TelemetryUsageEvent.View(it);
            } else {
                view2 = null;
            }
            view = view2;
            String string3 = rumContext.getActionId();
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                action = new TelemetryUsageEvent.Action(it);
            } else {
                action = null;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        TelemetryUsageEvent.Action action2 = action;
        TelemetryUsageEvent.Device device = new TelemetryUsageEvent.Device(datadogContext.getDeviceInfo().getArchitecture(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getDeviceModel());
        Object object = datadogContext.getDeviceInfo().getDeviceBuildId();
        String string4 = datadogContext.getDeviceInfo().getOsVersion();
        String string5 = datadogContext.getDeviceInfo().getOsName();
        TelemetryUsageEvent.Os os = new TelemetryUsageEvent.Os((String)object, string5, string4);
        boolean bl = ((InternalTelemetryEvent.ApiUsage.AddViewLoadingTime)event).getOverwrite();
        boolean bl2 = ((InternalTelemetryEvent.ApiUsage.AddViewLoadingTime)event).getNoView();
        boolean bl3 = ((InternalTelemetryEvent.ApiUsage.AddViewLoadingTime)event).getNoActiveView();
        object = new TelemetryUsageEvent.Usage.AddViewLoadingTime(bl2, bl3, bl);
        TelemetryUsageEvent.Telemetry telemetry = new TelemetryUsageEvent.Telemetry(device, os, (TelemetryUsageEvent.Usage)object, resolvedAdditionalProperties);
        return new TelemetryUsageEvent(dd, timestamp, TELEMETRY_SERVICE_NAME, source, string, application, session, view, action2, Float.valueOf(effectiveSampleRate), null, telemetry, 1024, null);
    }

    private final boolean isGlobalTracerRegistered() {
        try {
            boolean bl;
            Class<?> globalTracerClass = Class.forName("io.opentracing.util.GlobalTracer");
            try {
                Object object = globalTracerClass.getMethod("isRegistered", new Class[0]).invoke(null, new Object[0]);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                bl = (Boolean)object;
            }
            catch (Throwable t) {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.TELEMETRY, (Function0)isGlobalTracerRegistered.1.INSTANCE, (Throwable)t, (boolean)false, null, (int)48, null);
                bl = false;
            }
            return bl;
        }
        catch (Throwable t) {
            boolean bl = false;
            return bl;
        }
    }

    private final boolean isOpenTelemetryRegistered(Map<String, ? extends Object> traceContext) {
        Object object = traceContext.get(IS_OPENTELEMETRY_ENABLED_CONTEXT_KEY);
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        return bl != null ? bl : false;
    }

    private final TracerApi resolveTracerApi(Map<String, ? extends Object> traceContext) {
        return this.isOpenTelemetryRegistered(traceContext) ? TracerApi.OpenTelemetry : (this.isGlobalTracerRegistered() ? TracerApi.OpenTracing : null);
    }

    private final String resolveOpenTelemetryApiVersion(TracerApi tracerApi, Map<String, ? extends Object> traceContext) {
        Object object;
        return tracerApi == TracerApi.OpenTelemetry ? ((object = traceContext.get(OPENTELEMETRY_API_VERSION_CONTEXT_KEY)) instanceof String ? (String)object : null) : null;
    }

    private final RumContext rumContext(DatadogContext $this$rumContext) {
        Map map = (Map)$this$rumContext.getFeaturesContext().get("rum");
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map rumContext = map;
        return RumContext.Companion.fromFeatureContext(rumContext);
    }

    private final float computeEffectiveSampleRate(Map<String, ? extends Object> properties, Float eventSpecificSamplingRate) {
        Float f;
        Float f2;
        RumFeature.Configuration configuration = this.getRumConfig();
        if (configuration == null) {
            return 0.0f;
        }
        double telemetrySampleRate = NumberExtKt.percent(configuration.getTelemetrySampleRate());
        double creatingSamplingRate = properties != null && (f2 = this.getFloat(properties, "HEAD_SAMPLING_RATE_KEY")) != null ? NumberExtKt.percent(f2.floatValue()) : 1.0;
        double reportingSamplingRate = properties != null && (f = this.getFloat(properties, "TAIL_SAMPLING_RATE_KEY")) != null ? NumberExtKt.percent(f.floatValue()) : 1.0;
        Float f3 = eventSpecificSamplingRate;
        double eventSamplingRate = f3 != null ? NumberExtKt.percent(f3.floatValue()) : 1.0;
        double effectiveSampleRate = telemetrySampleRate * creatingSamplingRate * reportingSamplingRate * eventSamplingRate;
        return (float)(effectiveSampleRate * 100.0);
    }

    static /* synthetic */ float computeEffectiveSampleRate$default(TelemetryEventHandler telemetryEventHandler, Map map, Float f, int n, Object object) {
        if ((n & 1) != 0) {
            map = null;
        }
        if ((n & 2) != 0) {
            f = null;
        }
        return telemetryEventHandler.computeEffectiveSampleRate(map, f);
    }

    private final Float getFloat(Map<String, ? extends Object> $this$getFloat, String key) {
        Object object = $this$getFloat.get(key);
        return object instanceof Float ? (Float)object : null;
    }

    private final Map<String, Object> cleanUpInternalAttributes(Map<String, ? extends Object> $this$cleanUpInternalAttributes) {
        Map map;
        Map $this$cleanUpInternalAttributes_u24lambda_u248 = map = MapsKt.toMutableMap($this$cleanUpInternalAttributes);
        boolean bl = false;
        $this$cleanUpInternalAttributes_u24lambda_u248.remove("TAIL_SAMPLING_RATE_KEY");
        $this$cleanUpInternalAttributes_u24lambda_u248.remove("HEAD_SAMPLING_RATE_KEY");
        return map;
    }

    public static final /* synthetic */ TelemetryDebugEvent access$createDebugEvent(TelemetryEventHandler $this, DatadogContext datadogContext, long timestamp, String message2, Map additionalProperties, float effectiveSampleRate) {
        return $this.createDebugEvent(datadogContext, timestamp, message2, additionalProperties, effectiveSampleRate);
    }

    public static final /* synthetic */ SessionMetricDispatcher access$getSessionEndedMetricDispatcher$p(TelemetryEventHandler $this) {
        return $this.sessionEndedMetricDispatcher;
    }

    public static final /* synthetic */ RumContext access$rumContext(TelemetryEventHandler $this, DatadogContext $receiver) {
        return $this.rumContext($receiver);
    }

    public static final /* synthetic */ TelemetryErrorEvent access$createErrorEvent(TelemetryEventHandler $this, DatadogContext datadogContext, long timestamp, String message2, String stack, String kind, float effectiveSampleRate, Map additionalProperties) {
        return $this.createErrorEvent(datadogContext, timestamp, message2, stack, kind, effectiveSampleRate, additionalProperties);
    }

    public static final /* synthetic */ TelemetryConfigurationEvent access$createConfigurationEvent(TelemetryEventHandler $this, DatadogContext datadogContext, long timestamp, InternalTelemetryEvent.Configuration event, float effectiveSampleRate) {
        return $this.createConfigurationEvent(datadogContext, timestamp, event, effectiveSampleRate);
    }

    public static final /* synthetic */ RumFeature.Configuration access$getRumConfig(TelemetryEventHandler $this) {
        return $this.getRumConfig();
    }

    public static final /* synthetic */ TelemetryUsageEvent access$createApiUsageEvent(TelemetryEventHandler $this, DatadogContext datadogContext, long timestamp, InternalTelemetryEvent.ApiUsage event, float effectiveSampleRate) {
        return $this.createApiUsageEvent(datadogContext, timestamp, event, effectiveSampleRate);
    }

    public static final /* synthetic */ void access$setTrackNetworkRequests$p(TelemetryEventHandler $this, boolean bl) {
        $this.trackNetworkRequests = bl;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/datadog/android/telemetry/internal/TelemetryEventHandler$Companion;", "", "()V", "ALREADY_SEEN_EVENT_MESSAGE", "", "DEFAULT_CONFIGURATION_SAMPLE_RATE", "", "IS_OPENTELEMETRY_ENABLED_CONTEXT_KEY", "MAX_EVENTS_PER_SESSION", "", "MAX_EVENT_NUMBER_REACHED_MESSAGE", "OPENTELEMETRY_API_VERSION_CONTEXT_KEY", "SESSION_REPLAY_IMAGE_PRIVACY_KEY", "SESSION_REPLAY_SAMPLE_RATE_KEY", "SESSION_REPLAY_START_IMMEDIATE_RECORDING_KEY", "SESSION_REPLAY_TEXT_AND_INPUT_PRIVACY_KEY", "SESSION_REPLAY_TOUCH_PRIVACY_KEY", "TELEMETRY_SERVICE_NAME", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/telemetry/internal/TelemetryEventHandler$TracerApi;", "", "(Ljava/lang/String;I)V", "OpenTelemetry", "OpenTracing", "dd-sdk-android-rum_release"})
    public static final class TracerApi
    extends Enum<TracerApi> {
        public static final /* enum */ TracerApi OpenTelemetry = new TracerApi();
        public static final /* enum */ TracerApi OpenTracing = new TracerApi();
        private static final /* synthetic */ TracerApi[] $VALUES;

        public static TracerApi[] values() {
            return (TracerApi[])$VALUES.clone();
        }

        public static TracerApi valueOf(String value) {
            return Enum.valueOf(TracerApi.class, value);
        }

        static {
            $VALUES = tracerApiArray = new TracerApi[]{TracerApi.OpenTelemetry, TracerApi.OpenTracing};
        }
    }
}

