/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sqlite;

import android.database.DatabaseErrorHandler;
import android.database.DefaultDatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.core.SdkReference;
import com.datadog.android.rum.GlobalRumMonitor;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumMonitor;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/sqlite/DatadogDatabaseErrorHandler;", "Landroid/database/DatabaseErrorHandler;", "sdkInstanceName", "", "defaultErrorHandler", "(Ljava/lang/String;Landroid/database/DatabaseErrorHandler;)V", "getDefaultErrorHandler$dd_sdk_android_rum_release", "()Landroid/database/DatabaseErrorHandler;", "sdkReference", "Lcom/datadog/android/core/SdkReference;", "onCorruption", "", "dbObj", "Landroid/database/sqlite/SQLiteDatabase;", "Companion", "dd-sdk-android-rum_release"})
public final class DatadogDatabaseErrorHandler
implements DatabaseErrorHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String sdkInstanceName;
    @NotNull
    private final DatabaseErrorHandler defaultErrorHandler;
    @NotNull
    private final SdkReference sdkReference;
    @NotNull
    public static final String DATABASE_CORRUPTION_ERROR_MESSAGE = "Corruption reported by sqlite database: %s";

    public DatadogDatabaseErrorHandler(@Nullable String sdkInstanceName, @NotNull DatabaseErrorHandler defaultErrorHandler) {
        Intrinsics.checkNotNullParameter((Object)defaultErrorHandler, (String)"defaultErrorHandler");
        this.sdkInstanceName = sdkInstanceName;
        this.defaultErrorHandler = defaultErrorHandler;
        this.sdkReference = new SdkReference(this.sdkInstanceName, null, 2, null);
    }

    public /* synthetic */ DatadogDatabaseErrorHandler(String string, DatabaseErrorHandler databaseErrorHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            databaseErrorHandler = (DatabaseErrorHandler)new DefaultDatabaseErrorHandler();
        }
        this(string, databaseErrorHandler);
    }

    @NotNull
    public final DatabaseErrorHandler getDefaultErrorHandler$dd_sdk_android_rum_release() {
        return this.defaultErrorHandler;
    }

    public void onCorruption(@NotNull SQLiteDatabase dbObj) {
        Intrinsics.checkNotNullParameter((Object)dbObj, (String)"dbObj");
        this.defaultErrorHandler.onCorruption(dbObj);
        SdkCore sdkCore = this.sdkReference.get();
        if (sdkCore != null) {
            RumMonitor rumMonitor2 = GlobalRumMonitor.get(sdkCore);
            Locale locale = Locale.US;
            String string = DATABASE_CORRUPTION_ERROR_MESSAGE;
            Object[] objectArray = new Object[]{dbObj.getPath()};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"error.database.path", (Object)dbObj.getPath()), TuplesKt.to((Object)"error.database.version", (Object)dbObj.getVersion())};
            rumMonitor2.addError(string2, RumErrorSource.SOURCE, null, MapsKt.mapOf((Pair[])pairArray));
        } else {
            String prefix = this.sdkInstanceName == null ? "Default SDK instance" : "SDK instance with name=" + this.sdkInstanceName;
            InternalLogger.DefaultImpls.log$default((InternalLogger)InternalLogger.Companion.getUNBOUND(), (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(prefix){
                final /* synthetic */ String $prefix;
                {
                    this.$prefix = $prefix;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$prefix + " is not found, skipping reporting the corruption of sqlite database: %s";
                }
            }), null, (boolean)false, null, (int)56, null);
        }
    }

    public DatadogDatabaseErrorHandler() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/sqlite/DatadogDatabaseErrorHandler$Companion;", "", "()V", "DATABASE_CORRUPTION_ERROR_MESSAGE", "", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

