/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.metric.networksettled;

import com.datadog.android.rum.metric.networksettled.InitialResourceIdentifier;
import com.datadog.android.rum.metric.networksettled.NetworkSettledResourceContext;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/datadog/android/rum/metric/networksettled/TimeBasedInitialResourceIdentifier;", "Lcom/datadog/android/rum/metric/networksettled/InitialResourceIdentifier;", "timeThresholdInMilliseconds", "", "(J)V", "timeThresholdInNanoSeconds", "equals", "", "other", "", "hashCode", "", "validate", "context", "Lcom/datadog/android/rum/metric/networksettled/NetworkSettledResourceContext;", "Companion", "dd-sdk-android-rum_release"})
public final class TimeBasedInitialResourceIdentifier
implements InitialResourceIdentifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long timeThresholdInNanoSeconds;
    public static final long DEFAULT_TIME_THRESHOLD_MS = 100L;

    public TimeBasedInitialResourceIdentifier(long timeThresholdInMilliseconds) {
        this.timeThresholdInNanoSeconds = TimeUnit.MILLISECONDS.toNanos(timeThresholdInMilliseconds);
    }

    public /* synthetic */ TimeBasedInitialResourceIdentifier(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 100L;
        }
        this(l);
    }

    @Override
    public boolean validate(@NotNull NetworkSettledResourceContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Long l = context.getViewCreatedTimestamp();
        if (l != null) {
            long viewCreatedTimestamp = ((Number)l).longValue();
            boolean bl2 = false;
            bl = context.getEventCreatedAtNanos() - viewCreatedTimestamp < this.timeThresholdInNanoSeconds;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.datadog.android.rum.metric.networksettled.TimeBasedInitialResourceIdentifier");
        TimeBasedInitialResourceIdentifier cfr_ignored_0 = (TimeBasedInitialResourceIdentifier)other;
        return this.timeThresholdInNanoSeconds == ((TimeBasedInitialResourceIdentifier)other).timeThresholdInNanoSeconds;
    }

    public int hashCode() {
        return Long.hashCode(this.timeThresholdInNanoSeconds);
    }

    public TimeBasedInitialResourceIdentifier() {
        this(0L, 1, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/rum/metric/networksettled/TimeBasedInitialResourceIdentifier$Companion;", "", "()V", "DEFAULT_TIME_THRESHOLD_MS", "", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

