/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.vitals;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.rum.internal.vitals.VitalReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/rum/internal/vitals/MemoryVitalReader;", "Lcom/datadog/android/rum/internal/vitals/VitalReader;", "statusFile", "Ljava/io/File;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Ljava/io/File;Lcom/datadog/android/api/InternalLogger;)V", "getInternalLogger$dd_sdk_android_rum_release", "()Lcom/datadog/android/api/InternalLogger;", "getStatusFile$dd_sdk_android_rum_release", "()Ljava/io/File;", "readVitalData", "", "()Ljava/lang/Double;", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nMemoryVitalReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryVitalReader.kt\ncom/datadog/android/rum/internal/vitals/MemoryVitalReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1603#2,9:54\n1855#2:63\n1856#2:65\n1612#2:66\n1#3:64\n*S KotlinDebug\n*F\n+ 1 MemoryVitalReader.kt\ncom/datadog/android/rum/internal/vitals/MemoryVitalReader\n*L\n30#1:54,9\n30#1:63\n30#1:65\n30#1:66\n30#1:64\n*E\n"})
public final class MemoryVitalReader
implements VitalReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File statusFile;
    @NotNull
    private final InternalLogger internalLogger;
    private static final int BYTES_IN_KB = 1000;
    @NotNull
    private static final String STATUS_PATH = "/proc/self/status";
    @NotNull
    private static final File STATUS_FILE = new File("/proc/self/status");
    @NotNull
    private static final String VM_RSS_PATTERN = "VmRSS:\\s+(\\d+) kB";
    @NotNull
    private static final Regex VM_RSS_REGEX = new Regex("VmRSS:\\s+(\\d+) kB");

    public MemoryVitalReader(@NotNull File statusFile, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)statusFile, (String)"statusFile");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.statusFile = statusFile;
        this.internalLogger = internalLogger;
    }

    public /* synthetic */ MemoryVitalReader(File file, InternalLogger internalLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            file = STATUS_FILE;
        }
        this(file, internalLogger);
    }

    @NotNull
    public final File getStatusFile$dd_sdk_android_rum_release() {
        return this.statusFile;
    }

    @NotNull
    public final InternalLogger getInternalLogger$dd_sdk_android_rum_release() {
        return this.internalLogger;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Double readVitalData() {
        void $this$mapNotNullTo$iv$iv;
        if (!FileExtKt.existsSafe((File)this.statusFile, (InternalLogger)this.internalLogger)) return null;
        if (!FileExtKt.canReadSafe((File)this.statusFile, (InternalLogger)this.internalLogger)) {
            return null;
        }
        List list = FileExtKt.readLinesSafe$default((File)this.statusFile, null, (InternalLogger)this.internalLogger, (int)1, null);
        if (list == null) return null;
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String line = (String)element$iv$iv;
            boolean bl2 = false;
            Object object = VM_RSS_REGEX.matchEntire((CharSequence)line);
            if ((object != null && (object = object.getGroupValues()) != null ? (String)CollectionsKt.getOrNull((List)object, (int)1) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        String string = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (string == null) return null;
        Double d = StringsKt.toDoubleOrNull((String)string);
        Double memorySizeKb = d;
        if (memorySizeKb == null) {
            return null;
        }
        Double d2 = memorySizeKb * (double)1000;
        return d2;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/datadog/android/rum/internal/vitals/MemoryVitalReader$Companion;", "", "()V", "BYTES_IN_KB", "", "STATUS_FILE", "Ljava/io/File;", "getSTATUS_FILE$dd_sdk_android_rum_release", "()Ljava/io/File;", "STATUS_PATH", "", "VM_RSS_PATTERN", "VM_RSS_REGEX", "Lkotlin/text/Regex;", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getSTATUS_FILE$dd_sdk_android_rum_release() {
            return STATUS_FILE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

