/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.vitals;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.hardware.display.DisplayManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.Display;
import android.view.FrameMetrics;
import android.view.View;
import android.view.Window;
import androidx.annotation.MainThread;
import androidx.annotation.RequiresApi;
import androidx.metrics.performance.FrameData;
import androidx.metrics.performance.JankStats;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.system.BuildSdkVersionProvider;
import com.datadog.android.rum.internal.vitals.JankStatsActivityLifecycleListener;
import com.datadog.android.rum.internal.vitals.JankStatsProvider;
import com.datadog.android.rum.internal.vitals.VitalObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0002>?B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001a\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00132\b\u0010*\u001a\u0004\u0018\u00010+H\u0017J\u0010\u0010,\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0013H\u0017J\u0010\u0010-\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0013H\u0017J\u0010\u0010.\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0013H\u0017J\u0018\u0010/\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00132\u0006\u00100\u001a\u00020+H\u0017J\u0010\u00101\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0013H\u0017J\u0010\u00102\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0013H\u0017J\u0010\u00103\u001a\u00020(2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\u0010H\u0003J\u0018\u00108\u001a\u00020(2\u0006\u00107\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0013H\u0002J\u0010\u00109\u001a\u00020(2\u0006\u00107\u001a\u00020\u0010H\u0003J \u0010:\u001a\u00020(2\u0006\u0010;\u001a\u00020<2\u0006\u00107\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0013H\u0003J\u0010\u0010=\u001a\u00020(2\u0006\u00107\u001a\u00020\u0010H\u0003R,\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00110\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00170\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010%\u001a\b\u0018\u00010&R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/datadog/android/rum/internal/vitals/JankStatsActivityLifecycleListener;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "Landroidx/metrics/performance/JankStats$OnFrameListener;", "vitalObserver", "Lcom/datadog/android/rum/internal/vitals/VitalObserver;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "jankStatsProvider", "Lcom/datadog/android/rum/internal/vitals/JankStatsProvider;", "screenRefreshRate", "", "buildSdkVersionProvider", "Lcom/datadog/android/core/internal/system/BuildSdkVersionProvider;", "(Lcom/datadog/android/rum/internal/vitals/VitalObserver;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/rum/internal/vitals/JankStatsProvider;DLcom/datadog/android/core/internal/system/BuildSdkVersionProvider;)V", "activeActivities", "Ljava/util/WeakHashMap;", "Landroid/view/Window;", "", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "getActiveActivities$dd_sdk_android_rum_release", "()Ljava/util/WeakHashMap;", "activeWindowsListener", "Landroidx/metrics/performance/JankStats;", "getActiveWindowsListener$dd_sdk_android_rum_release", "display", "Landroid/view/Display;", "getDisplay$dd_sdk_android_rum_release", "()Landroid/view/Display;", "setDisplay$dd_sdk_android_rum_release", "(Landroid/view/Display;)V", "frameDeadline", "", "getFrameDeadline$dd_sdk_android_rum_release", "()J", "setFrameDeadline$dd_sdk_android_rum_release", "(J)V", "frameMetricsListener", "Lcom/datadog/android/rum/internal/vitals/JankStatsActivityLifecycleListener$DDFrameMetricsListener;", "onActivityCreated", "", "activity", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "onFrame", "volatileFrameData", "Landroidx/metrics/performance/FrameData;", "registerMetricListener", "window", "trackActivity", "trackWindowJankStats", "trackWindowMetrics", "isKnownWindow", "", "unregisterMetricListener", "Companion", "DDFrameMetricsListener", "dd-sdk-android-rum_release"})
public final class JankStatsActivityLifecycleListener
implements Application.ActivityLifecycleCallbacks,
JankStats.OnFrameListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VitalObserver vitalObserver;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final JankStatsProvider jankStatsProvider;
    private double screenRefreshRate;
    @NotNull
    private BuildSdkVersionProvider buildSdkVersionProvider;
    @NotNull
    private final WeakHashMap<Window, JankStats> activeWindowsListener;
    @NotNull
    private final WeakHashMap<Window, List<WeakReference<Activity>>> activeActivities;
    @Nullable
    private Display display;
    @Nullable
    private DDFrameMetricsListener frameMetricsListener;
    private long frameDeadline;
    @NotNull
    public static final String JANK_STATS_TRACKING_ALREADY_DISABLED_ERROR = "Trying to disable JankStats instance which was already disabled before, this shouldn't happen.";
    @NotNull
    public static final String JANK_STATS_TRACKING_DISABLE_ERROR = "Failed to disable JankStats tracking";
    private static final double ONE_SECOND_NS = TimeUnit.SECONDS.toNanos(1L);
    private static final double MIN_FPS = 1.0;
    private static final double MAX_FPS = 60.0;
    private static final double SIXTY_FPS = 60.0;
    private static final long SIXTEEN_MS_NS = 16666666L;

    public JankStatsActivityLifecycleListener(@NotNull VitalObserver vitalObserver, @NotNull InternalLogger internalLogger, @NotNull JankStatsProvider jankStatsProvider, double screenRefreshRate, @NotNull BuildSdkVersionProvider buildSdkVersionProvider) {
        Intrinsics.checkNotNullParameter((Object)vitalObserver, (String)"vitalObserver");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)jankStatsProvider, (String)"jankStatsProvider");
        Intrinsics.checkNotNullParameter((Object)buildSdkVersionProvider, (String)"buildSdkVersionProvider");
        this.vitalObserver = vitalObserver;
        this.internalLogger = internalLogger;
        this.jankStatsProvider = jankStatsProvider;
        this.screenRefreshRate = screenRefreshRate;
        this.buildSdkVersionProvider = buildSdkVersionProvider;
        this.activeWindowsListener = new WeakHashMap();
        this.activeActivities = new WeakHashMap();
        this.frameDeadline = 16666666L;
    }

    public /* synthetic */ JankStatsActivityLifecycleListener(VitalObserver vitalObserver, InternalLogger internalLogger, JankStatsProvider jankStatsProvider, double d, BuildSdkVersionProvider buildSdkVersionProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            jankStatsProvider = JankStatsProvider.Companion.getDEFAULT();
        }
        if ((n & 8) != 0) {
            d = 60.0;
        }
        if ((n & 0x10) != 0) {
            buildSdkVersionProvider = BuildSdkVersionProvider.Companion.getDEFAULT();
        }
        this(vitalObserver, internalLogger, jankStatsProvider, d, buildSdkVersionProvider);
    }

    @NotNull
    public final WeakHashMap<Window, JankStats> getActiveWindowsListener$dd_sdk_android_rum_release() {
        return this.activeWindowsListener;
    }

    @NotNull
    public final WeakHashMap<Window, List<WeakReference<Activity>>> getActiveActivities$dd_sdk_android_rum_release() {
        return this.activeActivities;
    }

    @Nullable
    public final Display getDisplay$dd_sdk_android_rum_release() {
        return this.display;
    }

    public final void setDisplay$dd_sdk_android_rum_release(@Nullable Display display) {
        this.display = display;
    }

    public final long getFrameDeadline$dd_sdk_android_rum_release() {
        return this.frameDeadline;
    }

    public final void setFrameDeadline$dd_sdk_android_rum_release(long l) {
        this.frameDeadline = l;
    }

    @MainThread
    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @MainThread
    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"window");
        this.trackActivity(window, activity);
        boolean isKnownWindow = this.activeWindowsListener.containsKey(window);
        this.trackWindowJankStats(window);
        this.trackWindowMetrics(isKnownWindow, window, activity);
    }

    @MainThread
    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @MainThread
    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @MainThread
    public void onActivityStopped(@NotNull Activity activity) {
        List list;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        if (!this.activeActivities.containsKey(window)) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)onActivityStopped.1.INSTANCE, null, (boolean)false, null, (int)56, null);
        }
        List list2 = (list = this.activeActivities.get(window)) == null ? (List)new ArrayList() : list;
        CollectionsKt.removeAll((List)list2, (Function1)((Function1)new Function1<WeakReference<Activity>, Boolean>(activity){
            final /* synthetic */ Activity $activity;
            {
                this.$activity = $activity;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull WeakReference<Activity> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.get() == null || Intrinsics.areEqual(it.get(), (Object)this.$activity);
            }
        }));
        ((Map)this.activeActivities).put(window, list2);
        if (list2.isEmpty()) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.DEBUG, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)((Function0)new Function0<String>(window){
                final /* synthetic */ Window $window;
                {
                    this.$window = $window;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Disabling jankStats for window " + this.$window;
                }
            }), null, (boolean)false, null, (int)56, null);
            try {
                JankStats jankStats = this.activeWindowsListener.get(window);
                if (jankStats != null) {
                    JankStats it = jankStats;
                    boolean bl = false;
                    if (it.isTrackingEnabled()) {
                        it.setTrackingEnabled(false);
                    } else {
                        InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.TELEMETRY, (Function0)onActivityStopped.4.1.INSTANCE, null, (boolean)false, null, (int)56, null);
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.TELEMETRY, (Function0)onActivityStopped.5.INSTANCE, (Throwable)iae, (boolean)false, null, (int)48, null);
            }
            catch (NullPointerException npe) {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.TELEMETRY, (Function0)onActivityStopped.6.INSTANCE, (Throwable)npe, (boolean)false, null, (int)48, null);
            }
        }
    }

    @MainThread
    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    @SuppressLint(value={"NewApi"})
    @MainThread
    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Collection collection = this.activeActivities.get(activity.getWindow());
        if (collection == null || collection.isEmpty()) {
            this.activeWindowsListener.remove(activity.getWindow());
            this.activeActivities.remove(activity.getWindow());
            if (this.buildSdkVersionProvider.getVersion() >= 31) {
                Window window = activity.getWindow();
                Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
                this.unregisterMetricListener(window);
            }
        }
    }

    public void onFrame(@NotNull FrameData volatileFrameData) {
        Intrinsics.checkNotNullParameter((Object)volatileFrameData, (String)"volatileFrameData");
        long durationNs = volatileFrameData.getFrameDurationUiNanos();
        if ((double)durationNs > 0.0) {
            double frameRate = ONE_SECOND_NS / (double)durationNs;
            if (this.buildSdkVersionProvider.getVersion() >= 31) {
                this.screenRefreshRate = ONE_SECOND_NS / (double)this.frameDeadline;
            } else if (this.buildSdkVersionProvider.getVersion() == 30) {
                Display display = this.display;
                this.screenRefreshRate = display != null ? (double)display.getRefreshRate() : 60.0;
            }
            frameRate = RangesKt.coerceAtMost((double)(frameRate * (60.0 / this.screenRefreshRate)), (double)60.0);
            if (frameRate > 1.0) {
                this.vitalObserver.onNewSample(frameRate);
            }
        }
    }

    private final void trackActivity(Window window, Activity activity) {
        List list = this.activeActivities.get(window);
        List list2 = list == null ? (List)new ArrayList() : list;
        list2.add(new WeakReference<Activity>(activity));
        ((Map)this.activeActivities).put(window, list2);
    }

    @MainThread
    private final void trackWindowJankStats(Window window) {
        JankStats knownJankStats = this.activeWindowsListener.get(window);
        if (knownJankStats != null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.DEBUG, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)((Function0)new Function0<String>(window){
                final /* synthetic */ Window $window;
                {
                    this.$window = $window;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Resuming jankStats for window " + this.$window;
                }
            }), null, (boolean)false, null, (int)56, null);
            knownJankStats.setTrackingEnabled(true);
        } else {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.DEBUG, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)((Function0)new Function0<String>(window){
                final /* synthetic */ Window $window;
                {
                    this.$window = $window;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Starting jankStats for window " + this.$window;
                }
            }), null, (boolean)false, null, (int)56, null);
            JankStats jankStats = this.jankStatsProvider.createJankStatsAndTrack(window, this, this.internalLogger);
            if (jankStats == null) {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)trackWindowJankStats.3.INSTANCE, null, (boolean)false, null, (int)56, null);
            } else {
                ((Map)this.activeWindowsListener).put(window, jankStats);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    @MainThread
    private final void trackWindowMetrics(boolean isKnownWindow, Window window, Activity activity) {
        if (this.buildSdkVersionProvider.getVersion() >= 31 && !isKnownWindow) {
            this.registerMetricListener(window);
        } else if (this.display == null && this.buildSdkVersionProvider.getVersion() == 30) {
            Object object = activity.getSystemService("display");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.display.DisplayManager");
            DisplayManager displayManager = (DisplayManager)object;
            this.display = displayManager.getDisplay(0);
        }
    }

    @RequiresApi(value=31)
    private final void registerMetricListener(Window window) {
        if (this.frameMetricsListener == null) {
            this.frameMetricsListener = new DDFrameMetricsListener();
        }
        Handler handler = new Handler(Looper.getMainLooper());
        View view = window.peekDecorView();
        boolean bl = view != null ? view.isHardwareAccelerated() : false;
        if (bl) {
            DDFrameMetricsListener dDFrameMetricsListener = this.frameMetricsListener;
            if (dDFrameMetricsListener != null) {
                DDFrameMetricsListener listener = dDFrameMetricsListener;
                boolean bl2 = false;
                try {
                    window.addOnFrameMetricsAvailableListener((Window.OnFrameMetricsAvailableListener)listener, handler);
                }
                catch (IllegalStateException e) {
                    InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)registerMetricListener.1.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
                }
            }
        } else {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)registerMetricListener.2.INSTANCE, null, (boolean)false, null, (int)56, null);
        }
    }

    @RequiresApi(value=24)
    private final void unregisterMetricListener(Window window) {
        try {
            window.removeOnFrameMetricsAvailableListener((Window.OnFrameMetricsAvailableListener)this.frameMetricsListener);
        }
        catch (IllegalArgumentException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)unregisterMetricListener.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/datadog/android/rum/internal/vitals/JankStatsActivityLifecycleListener$Companion;", "", "()V", "JANK_STATS_TRACKING_ALREADY_DISABLED_ERROR", "", "JANK_STATS_TRACKING_DISABLE_ERROR", "MAX_FPS", "", "MIN_FPS", "ONE_SECOND_NS", "SIXTEEN_MS_NS", "", "SIXTY_FPS", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0087\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/rum/internal/vitals/JankStatsActivityLifecycleListener$DDFrameMetricsListener;", "Landroid/view/Window$OnFrameMetricsAvailableListener;", "(Lcom/datadog/android/rum/internal/vitals/JankStatsActivityLifecycleListener;)V", "onFrameMetricsAvailable", "", "window", "Landroid/view/Window;", "frameMetrics", "Landroid/view/FrameMetrics;", "dropCountSinceLastInvocation", "", "dd-sdk-android-rum_release"})
    @RequiresApi(value=24)
    public final class DDFrameMetricsListener
    implements Window.OnFrameMetricsAvailableListener {
        @RequiresApi(value=31)
        public void onFrameMetricsAvailable(@NotNull Window window, @NotNull FrameMetrics frameMetrics, int dropCountSinceLastInvocation) {
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            Intrinsics.checkNotNullParameter((Object)frameMetrics, (String)"frameMetrics");
            JankStatsActivityLifecycleListener.this.setFrameDeadline$dd_sdk_android_rum_release(frameMetrics.getMetric(13));
        }
    }
}

