/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.vitals;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.rum.internal.vitals.VitalReader;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/rum/internal/vitals/CPUVitalReader;", "Lcom/datadog/android/rum/internal/vitals/VitalReader;", "statFile", "Ljava/io/File;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Ljava/io/File;Lcom/datadog/android/api/InternalLogger;)V", "getInternalLogger$dd_sdk_android_rum_release", "()Lcom/datadog/android/api/InternalLogger;", "getStatFile$dd_sdk_android_rum_release", "()Ljava/io/File;", "readVitalData", "", "()Ljava/lang/Double;", "Companion", "dd-sdk-android-rum_release"})
public final class CPUVitalReader
implements VitalReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File statFile;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private static final String STAT_PATH = "/proc/self/stat";
    @NotNull
    private static final File STAT_FILE = new File("/proc/self/stat");
    private static final int UTIME_IDX = 13;

    public CPUVitalReader(@NotNull File statFile, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)statFile, (String)"statFile");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.statFile = statFile;
        this.internalLogger = internalLogger;
    }

    public /* synthetic */ CPUVitalReader(File file, InternalLogger internalLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            file = STAT_FILE;
        }
        this(file, internalLogger);
    }

    @NotNull
    public final File getStatFile$dd_sdk_android_rum_release() {
        return this.statFile;
    }

    @NotNull
    public final InternalLogger getInternalLogger$dd_sdk_android_rum_release() {
        return this.internalLogger;
    }

    @Override
    @Nullable
    public Double readVitalData() {
        if (!FileExtKt.existsSafe((File)this.statFile, (InternalLogger)this.internalLogger) || !FileExtKt.canReadSafe((File)this.statFile, (InternalLogger)this.internalLogger)) {
            return null;
        }
        String string = FileExtKt.readTextSafe$default((File)this.statFile, null, (InternalLogger)this.internalLogger, (int)1, null);
        if (string == null) {
            return null;
        }
        String stat = string;
        char[] cArray = new char[]{' '};
        List tokens = StringsKt.split$default((CharSequence)stat, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        return tokens.size() > 13 ? StringsKt.toDoubleOrNull((String)((String)tokens.get(13))) : null;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/rum/internal/vitals/CPUVitalReader$Companion;", "", "()V", "STAT_FILE", "Ljava/io/File;", "getSTAT_FILE$dd_sdk_android_rum_release", "()Ljava/io/File;", "STAT_PATH", "", "UTIME_IDX", "", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getSTAT_FILE$dd_sdk_android_rum_release() {
            return STAT_FILE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

