/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.monitor;

import android.os.Handler;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.core.InternalSdkCore;
import com.datadog.android.core.feature.event.ThreadDump;
import com.datadog.android.core.internal.net.FirstPartyHostHeaderTypeResolver;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.internal.telemetry.InternalTelemetryEvent;
import com.datadog.android.rum.DdRumContentProvider;
import com.datadog.android.rum.ExperimentalRumApi;
import com.datadog.android.rum.RumActionType;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.RumPerformanceMetric;
import com.datadog.android.rum.RumResourceKind;
import com.datadog.android.rum.RumResourceMethod;
import com.datadog.android.rum.RumSessionListener;
import com.datadog.android.rum._RumInternalProxy;
import com.datadog.android.rum.internal.CombinedRumSessionListener;
import com.datadog.android.rum.internal.RumErrorSourceType;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.debug.RumDebugListener;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.Time;
import com.datadog.android.rum.internal.domain.TimeKt;
import com.datadog.android.rum.internal.domain.event.ResourceTiming;
import com.datadog.android.rum.internal.domain.scope.RumApplicationScope;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.internal.domain.scope.RumScopeKey;
import com.datadog.android.rum.internal.domain.scope.RumSessionScope;
import com.datadog.android.rum.internal.domain.scope.RumViewManagerScope;
import com.datadog.android.rum.internal.domain.scope.RumViewScope;
import com.datadog.android.rum.internal.metric.SessionMetricDispatcher;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.monitor.DatadogRumMonitor;
import com.datadog.android.rum.internal.monitor.StorageEvent;
import com.datadog.android.rum.internal.vitals.VitalMonitor;
import com.datadog.android.rum.metric.interactiontonextview.LastInteractionIdentifier;
import com.datadog.android.rum.metric.networksettled.InitialResourceIdentifier;
import com.datadog.android.rum.resource.ResourceId;
import com.datadog.android.telemetry.internal.TelemetryEventHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00b2\u00012\u00020\u00012\u00020\u0002:\u0002\u00b2\u0001B\u0093\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u0010\u001a\u001a\u00020\u0018\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020 \u0012\u0006\u0010!\u001a\u00020\"\u00a2\u0006\u0002\u0010#J\b\u0010J\u001a\u000208H\u0016J.\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u00042\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016J\u001a\u0010R\u001a\u00020L2\u0006\u0010S\u001a\u00020\u00042\b\u0010&\u001a\u0004\u0018\u00010\u000eH\u0016J.\u0010T\u001a\u00020L2\u0006\u0010U\u001a\u00020\u00042\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020Y2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\\0[H\u0016J8\u0010]\u001a\u00020L2\u0006\u0010U\u001a\u00020\u00042\u0006\u0010V\u001a\u00020W2\b\u0010X\u001a\u0004\u0018\u00010Y2\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016J8\u0010^\u001a\u00020L2\u0006\u0010U\u001a\u00020\u00042\u0006\u0010V\u001a\u00020W2\b\u0010_\u001a\u0004\u0018\u00010\u00042\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016J\u0018\u0010`\u001a\u00020L2\u0006\u0010O\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u000eH\u0016J\u001c\u0010a\u001a\u00020L2\u0012\u0010b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0QH\u0016J\u0018\u0010c\u001a\u00020L2\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020\u0004H\u0016J\u0018\u0010g\u001a\u00020L2\u0006\u0010S\u001a\u00020\u000e2\u0006\u0010h\u001a\u00020iH\u0016J\b\u0010j\u001a\u00020LH\u0016J\u0010\u0010k\u001a\u00020L2\u0006\u0010O\u001a\u00020\u0004H\u0016J\u0010\u0010l\u001a\u00020L2\u0006\u0010m\u001a\u00020\nH\u0017J\b\u0010n\u001a\u00020LH\u0016J\r\u0010o\u001a\u00020LH\u0000\u00a2\u0006\u0002\bpJ\u0018\u0010q\u001a\u00020L2\u0006\u0010r\u001a\u00020\u00042\u0006\u0010s\u001a\u00020tH\u0016J\u0018\u0010u\u001a\u00020L2\u0006\u0010r\u001a\u00020\u00042\u0006\u0010s\u001a\u00020tH\u0016J\u0016\u0010v\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016J\u001e\u0010w\u001a\u00020L2\u0014\u0010x\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020L0yH\u0016J\u001e\u0010z\u001a\u00020{2\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0002J \u0010|\u001a\u0004\u0018\u00010\u00042\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0002J\u001e\u0010}\u001a\u00020~2\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0002J\u0017\u0010\u007f\u001a\u00020L2\u0007\u0010s\u001a\u00030\u0080\u0001H\u0000\u00a2\u0006\u0003\b\u0081\u0001J\u000f\u0010\u0082\u0001\u001a\u00020LH\u0000\u00a2\u0006\u0003\b\u0083\u0001J\t\u0010\u0084\u0001\u001a\u00020LH\u0016J\u0011\u0010\u0085\u0001\u001a\u00020L2\u0006\u0010S\u001a\u00020\u0004H\u0016J\t\u0010\u0086\u0001\u001a\u00020LH\u0016J\u0013\u0010\u0087\u0001\u001a\u00020L2\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001H\u0016J\t\u0010\u008a\u0001\u001a\u00020LH\u0016J\u0014\u0010\u008b\u0001\u001a\u00020L2\t\u0010\u008c\u0001\u001a\u0004\u0018\u00010,H\u0016J\u001b\u0010\u008d\u0001\u001a\u00020L2\u0007\u0010\u008e\u0001\u001a\u00020\u00042\u0007\u0010\u008f\u0001\u001a\u00020\u0004H\u0016J\t\u0010\u0090\u0001\u001a\u00020LH\u0016J/\u0010\u0091\u0001\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u00042\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016J;\u0010\u0092\u0001\u001a\u00020L2\u0007\u0010S\u001a\u00030\u0093\u00012\b\u0010\u0094\u0001\u001a\u00030\u0095\u00012\u0007\u0010\u0096\u0001\u001a\u00020\u00042\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016J:\u0010\u0092\u0001\u001a\u00020L2\u0006\u0010S\u001a\u00020\u00042\b\u0010\u0094\u0001\u001a\u00030\u0095\u00012\u0007\u0010\u0096\u0001\u001a\u00020\u00042\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016J9\u0010\u0092\u0001\u001a\u00020L2\u0006\u0010S\u001a\u00020\u00042\u0007\u0010\u0094\u0001\u001a\u00020\u00042\u0007\u0010\u0096\u0001\u001a\u00020\u00042\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0017J/\u0010\u0097\u0001\u001a\u00020L2\u0006\u0010S\u001a\u00020\u000e2\u0006\u0010O\u001a\u00020\u00042\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016J/\u0010\u0098\u0001\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u00042\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016J\u000f\u0010\u0099\u0001\u001a\u00020LH\u0000\u00a2\u0006\u0003\b\u009a\u0001JO\u0010\u009b\u0001\u001a\u00020L2\u0007\u0010S\u001a\u00030\u0093\u00012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009d\u00012\t\u0010\u009e\u0001\u001a\u0004\u0018\u00010e2\b\u0010\u009f\u0001\u001a\u00030\u00a0\u00012\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016\u00a2\u0006\u0003\u0010\u00a1\u0001JN\u0010\u009b\u0001\u001a\u00020L2\u0006\u0010S\u001a\u00020\u00042\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009d\u00012\t\u0010\u009e\u0001\u001a\u0004\u0018\u00010e2\b\u0010\u009f\u0001\u001a\u00030\u00a0\u00012\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016\u00a2\u0006\u0003\u0010\u00a2\u0001J^\u0010\u00a3\u0001\u001a\u00020L2\u0007\u0010S\u001a\u00030\u0093\u00012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009d\u00012\u0006\u0010U\u001a\u00020\u00042\u0006\u0010V\u001a\u00020W2\u0007\u0010\u00a4\u0001\u001a\u00020\u00042\t\u0010\u00a5\u0001\u001a\u0004\u0018\u00010\u00042\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016\u00a2\u0006\u0003\u0010\u00a6\u0001JR\u0010\u00a3\u0001\u001a\u00020L2\u0007\u0010S\u001a\u00030\u0093\u00012\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009d\u00012\u0006\u0010U\u001a\u00020\u00042\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020Y2\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016\u00a2\u0006\u0003\u0010\u00a7\u0001J]\u0010\u00a3\u0001\u001a\u00020L2\u0006\u0010S\u001a\u00020\u00042\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009d\u00012\u0006\u0010U\u001a\u00020\u00042\u0006\u0010V\u001a\u00020W2\u0007\u0010\u00a4\u0001\u001a\u00020\u00042\t\u0010\u00a5\u0001\u001a\u0004\u0018\u00010\u00042\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016\u00a2\u0006\u0003\u0010\u00a8\u0001JQ\u0010\u00a3\u0001\u001a\u00020L2\u0006\u0010S\u001a\u00020\u00042\n\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009d\u00012\u0006\u0010U\u001a\u00020\u00042\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020Y2\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016\u00a2\u0006\u0003\u0010\u00a9\u0001J\t\u0010\u00aa\u0001\u001a\u00020LH\u0016J'\u0010\u00ab\u0001\u001a\u00020L2\u0006\u0010S\u001a\u00020\u000e2\u0014\u0010P\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e0QH\u0016J\u001c\u0010\u00ac\u0001\u001a\u00020L2\b\u0010\u00ad\u0001\u001a\u00030\u00ae\u00012\u0007\u0010&\u001a\u00030\u00af\u0001H\u0016J\t\u0010\u00b0\u0001\u001a\u00020LH\u0002J\u0011\u0010\u00b1\u0001\u001a\u00020L2\u0006\u0010S\u001a\u00020\u000eH\u0016R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R$\u0010'\u001a\u00020\n2\u0006\u0010&\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010%\"\u0004\b)\u0010*R\u001c\u0010+\u001a\u0004\u0018\u00010,X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0014\u0010\u001d\u001a\u00020\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u001c\u00103\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000e04X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010;\u001a\u00020<X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u0014\u0010\u000b\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010%R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00b3\u0001"}, d2={"Lcom/datadog/android/rum/internal/monitor/DatadogRumMonitor;", "Lcom/datadog/android/rum/RumMonitor;", "Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;", "applicationId", "", "sdkCore", "Lcom/datadog/android/core/InternalSdkCore;", "sampleRate", "", "backgroundTrackingEnabled", "", "trackFrustrations", "writer", "Lcom/datadog/android/api/storage/DataWriter;", "", "handler", "Landroid/os/Handler;", "telemetryEventHandler", "Lcom/datadog/android/telemetry/internal/TelemetryEventHandler;", "sessionEndedMetricDispatcher", "Lcom/datadog/android/rum/internal/metric/SessionMetricDispatcher;", "firstPartyHostHeaderTypeResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "cpuVitalMonitor", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "memoryVitalMonitor", "frameRateVitalMonitor", "sessionListener", "Lcom/datadog/android/rum/RumSessionListener;", "executorService", "Ljava/util/concurrent/ExecutorService;", "initialResourceIdentifier", "Lcom/datadog/android/rum/metric/networksettled/InitialResourceIdentifier;", "lastInteractionIdentifier", "Lcom/datadog/android/rum/metric/interactiontonextview/LastInteractionIdentifier;", "(Ljava/lang/String;Lcom/datadog/android/core/InternalSdkCore;FZZLcom/datadog/android/api/storage/DataWriter;Landroid/os/Handler;Lcom/datadog/android/telemetry/internal/TelemetryEventHandler;Lcom/datadog/android/rum/internal/metric/SessionMetricDispatcher;Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/RumSessionListener;Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/rum/metric/networksettled/InitialResourceIdentifier;Lcom/datadog/android/rum/metric/interactiontonextview/LastInteractionIdentifier;)V", "getBackgroundTrackingEnabled$dd_sdk_android_rum_release", "()Z", "value", "debug", "getDebug", "setDebug", "(Z)V", "debugListener", "Lcom/datadog/android/rum/internal/debug/RumDebugListener;", "getDebugListener$dd_sdk_android_rum_release", "()Lcom/datadog/android/rum/internal/debug/RumDebugListener;", "setDebugListener$dd_sdk_android_rum_release", "(Lcom/datadog/android/rum/internal/debug/RumDebugListener;)V", "getExecutorService$dd_sdk_android_rum_release", "()Ljava/util/concurrent/ExecutorService;", "globalAttributes", "", "getHandler$dd_sdk_android_rum_release", "()Landroid/os/Handler;", "internalProxy", "Lcom/datadog/android/rum/_RumInternalProxy;", "isDebugEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "keepAliveRunnable", "Ljava/lang/Runnable;", "getKeepAliveRunnable$dd_sdk_android_rum_release", "()Ljava/lang/Runnable;", "rootScope", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "getRootScope$dd_sdk_android_rum_release", "()Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "setRootScope$dd_sdk_android_rum_release", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;)V", "getSampleRate$dd_sdk_android_rum_release", "()F", "getTelemetryEventHandler$dd_sdk_android_rum_release", "()Lcom/datadog/android/telemetry/internal/TelemetryEventHandler;", "getTrackFrustrations$dd_sdk_android_rum_release", "_getInternal", "addAction", "", "type", "Lcom/datadog/android/rum/RumActionType;", "name", "attributes", "", "addAttribute", "key", "addCrash", "message", "source", "Lcom/datadog/android/rum/RumErrorSource;", "throwable", "", "threads", "", "Lcom/datadog/android/core/feature/event/ThreadDump;", "addError", "addErrorWithStacktrace", "stacktrace", "addFeatureFlagEvaluation", "addFeatureFlagEvaluations", "featureFlags", "addLongTask", "durationNs", "", "target", "addResourceTiming", "timing", "Lcom/datadog/android/rum/internal/domain/event/ResourceTiming;", "addSessionReplaySkippedFrame", "addTiming", "addViewLoadingTime", "overwrite", "clearAttributes", "drainExecutorService", "drainExecutorService$dd_sdk_android_rum_release", "eventDropped", "viewId", "event", "Lcom/datadog/android/rum/internal/monitor/StorageEvent;", "eventSent", "getAttributes", "getCurrentSessionId", "callback", "Lkotlin/Function1;", "getErrorSourceType", "Lcom/datadog/android/rum/internal/RumErrorSourceType;", "getErrorType", "getEventTime", "Lcom/datadog/android/rum/internal/domain/Time;", "handleEvent", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "handleEvent$dd_sdk_android_rum_release", "notifyDebugListenerWithState", "notifyDebugListenerWithState$dd_sdk_android_rum_release", "notifyInterceptorInstantiated", "removeAttribute", "resetSession", "sendTelemetryEvent", "telemetryEvent", "Lcom/datadog/android/internal/telemetry/InternalTelemetryEvent;", "sendWebViewEvent", "setDebugListener", "listener", "setSyntheticsAttribute", "testId", "resultId", "start", "startAction", "startResource", "Lcom/datadog/android/rum/resource/ResourceId;", "method", "Lcom/datadog/android/rum/RumResourceMethod;", "url", "startView", "stopAction", "stopKeepAliveCallback", "stopKeepAliveCallback$dd_sdk_android_rum_release", "stopResource", "statusCode", "", "size", "kind", "Lcom/datadog/android/rum/RumResourceKind;", "(Lcom/datadog/android/rum/resource/ResourceId;Ljava/lang/Integer;Ljava/lang/Long;Lcom/datadog/android/rum/RumResourceKind;Ljava/util/Map;)V", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Long;Lcom/datadog/android/rum/RumResourceKind;Ljava/util/Map;)V", "stopResourceWithError", "stackTrace", "errorType", "(Lcom/datadog/android/rum/resource/ResourceId;Ljava/lang/Integer;Ljava/lang/String;Lcom/datadog/android/rum/RumErrorSource;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "(Lcom/datadog/android/rum/resource/ResourceId;Ljava/lang/Integer;Ljava/lang/String;Lcom/datadog/android/rum/RumErrorSource;Ljava/lang/Throwable;Ljava/util/Map;)V", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lcom/datadog/android/rum/RumErrorSource;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lcom/datadog/android/rum/RumErrorSource;Ljava/lang/Throwable;Ljava/util/Map;)V", "stopSession", "stopView", "updatePerformanceMetric", "metric", "Lcom/datadog/android/rum/RumPerformanceMetric;", "", "waitForPendingEvents", "waitForResourceTiming", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nDatadogRumMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatadogRumMonitor.kt\ncom/datadog/android/rum/internal/monitor/DatadogRumMonitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,762:1\n1855#2,2:763\n800#2,11:765\n766#2:776\n857#2,2:777\n1603#2,9:779\n1855#2:788\n1856#2:790\n1612#2:791\n1#3:789\n*S KotlinDebug\n*F\n+ 1 DatadogRumMonitor.kt\ncom/datadog/android/rum/internal/monitor/DatadogRumMonitor\n*L\n656#1:763,2\n720#1:765,11\n721#1:776\n721#1:777,2\n722#1:779,9\n722#1:788\n722#1:790\n722#1:791\n722#1:789\n*E\n"})
public final class DatadogRumMonitor
implements RumMonitor,
AdvancedRumMonitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalSdkCore sdkCore;
    private final float sampleRate;
    private final boolean backgroundTrackingEnabled;
    private final boolean trackFrustrations;
    @NotNull
    private final DataWriter<Object> writer;
    @NotNull
    private final Handler handler;
    @NotNull
    private final TelemetryEventHandler telemetryEventHandler;
    @NotNull
    private final SessionMetricDispatcher sessionEndedMetricDispatcher;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private RumScope rootScope;
    @NotNull
    private final Runnable keepAliveRunnable;
    @Nullable
    private RumDebugListener debugListener;
    @NotNull
    private final _RumInternalProxy internalProxy;
    @NotNull
    private final Map<String, Object> globalAttributes;
    @NotNull
    private final AtomicBoolean isDebugEnabled;
    private static final long KEEP_ALIVE_MS = TimeUnit.MINUTES.toMillis(5L);
    public static final long DRAIN_WAIT_SECONDS = 10L;
    @NotNull
    public static final String RUM_DEBUG_RUM_NOT_ENABLED_WARNING = "Cannot switch RUM debugging, because RUM feature is not enabled.";

    public DatadogRumMonitor(@NotNull String applicationId, @NotNull InternalSdkCore sdkCore, float sampleRate, boolean backgroundTrackingEnabled, boolean trackFrustrations, @NotNull DataWriter<Object> writer, @NotNull Handler handler, @NotNull TelemetryEventHandler telemetryEventHandler, @NotNull SessionMetricDispatcher sessionEndedMetricDispatcher, @NotNull FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, @NotNull VitalMonitor cpuVitalMonitor, @NotNull VitalMonitor memoryVitalMonitor, @NotNull VitalMonitor frameRateVitalMonitor, @NotNull RumSessionListener sessionListener, @NotNull ExecutorService executorService, @NotNull InitialResourceIdentifier initialResourceIdentifier, @NotNull LastInteractionIdentifier lastInteractionIdentifier) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)telemetryEventHandler, (String)"telemetryEventHandler");
        Intrinsics.checkNotNullParameter((Object)sessionEndedMetricDispatcher, (String)"sessionEndedMetricDispatcher");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostHeaderTypeResolver, (String)"firstPartyHostHeaderTypeResolver");
        Intrinsics.checkNotNullParameter((Object)cpuVitalMonitor, (String)"cpuVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)memoryVitalMonitor, (String)"memoryVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)frameRateVitalMonitor, (String)"frameRateVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)sessionListener, (String)"sessionListener");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)initialResourceIdentifier, (String)"initialResourceIdentifier");
        Intrinsics.checkNotNullParameter((Object)lastInteractionIdentifier, (String)"lastInteractionIdentifier");
        this.sdkCore = sdkCore;
        this.sampleRate = sampleRate;
        this.backgroundTrackingEnabled = backgroundTrackingEnabled;
        this.trackFrustrations = trackFrustrations;
        this.writer = writer;
        this.handler = handler;
        this.telemetryEventHandler = telemetryEventHandler;
        this.sessionEndedMetricDispatcher = sessionEndedMetricDispatcher;
        this.executorService = executorService;
        RumSessionListener[] rumSessionListenerArray = new RumSessionListener[]{sessionListener, this.telemetryEventHandler};
        this.rootScope = new RumApplicationScope(applicationId, this.sdkCore, this.sampleRate, this.backgroundTrackingEnabled, this.trackFrustrations, firstPartyHostHeaderTypeResolver, cpuVitalMonitor, memoryVitalMonitor, frameRateVitalMonitor, this.sessionEndedMetricDispatcher, new CombinedRumSessionListener(rumSessionListenerArray), initialResourceIdentifier, lastInteractionIdentifier);
        this.keepAliveRunnable = () -> DatadogRumMonitor.keepAliveRunnable$lambda$0(this);
        this.internalProxy = new _RumInternalProxy(this);
        this.handler.postDelayed(this.keepAliveRunnable, KEEP_ALIVE_MS);
        this.globalAttributes = new ConcurrentHashMap();
        this.isDebugEnabled = new AtomicBoolean(false);
    }

    public final float getSampleRate$dd_sdk_android_rum_release() {
        return this.sampleRate;
    }

    public final boolean getBackgroundTrackingEnabled$dd_sdk_android_rum_release() {
        return this.backgroundTrackingEnabled;
    }

    public final boolean getTrackFrustrations$dd_sdk_android_rum_release() {
        return this.trackFrustrations;
    }

    @NotNull
    public final Handler getHandler$dd_sdk_android_rum_release() {
        return this.handler;
    }

    @NotNull
    public final TelemetryEventHandler getTelemetryEventHandler$dd_sdk_android_rum_release() {
        return this.telemetryEventHandler;
    }

    @NotNull
    public final ExecutorService getExecutorService$dd_sdk_android_rum_release() {
        return this.executorService;
    }

    @NotNull
    public final RumScope getRootScope$dd_sdk_android_rum_release() {
        return this.rootScope;
    }

    public final void setRootScope$dd_sdk_android_rum_release(@NotNull RumScope rumScope) {
        Intrinsics.checkNotNullParameter((Object)rumScope, (String)"<set-?>");
        this.rootScope = rumScope;
    }

    @NotNull
    public final Runnable getKeepAliveRunnable$dd_sdk_android_rum_release() {
        return this.keepAliveRunnable;
    }

    @Nullable
    public final RumDebugListener getDebugListener$dd_sdk_android_rum_release() {
        return this.debugListener;
    }

    public final void setDebugListener$dd_sdk_android_rum_release(@Nullable RumDebugListener rumDebugListener) {
        this.debugListener = rumDebugListener;
    }

    @Override
    public void getCurrentSessionId(@NotNull Function1<? super String, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ConcurrencyExtKt.submitSafe((ExecutorService)this.executorService, (String)"Get current session ID", (InternalLogger)this.sdkCore.getInternalLogger(), () -> DatadogRumMonitor.getCurrentSessionId$lambda$2(this, callback));
    }

    @Override
    public boolean getDebug() {
        return this.isDebugEnabled.get();
    }

    @Override
    public void setDebug(boolean value) {
        RumFeature rumFeatureScope;
        boolean isEnabled = this.isDebugEnabled.get();
        if (value == isEnabled) {
            return;
        }
        FeatureScope featureScope = this.sdkCore.getFeature("rum");
        RumFeature rumFeature2 = rumFeatureScope = featureScope != null ? (RumFeature)featureScope.unwrap() : null;
        if (rumFeatureScope == null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)debug.1.INSTANCE, null, (boolean)false, null, (int)56, null);
            return;
        }
        if (value) {
            rumFeatureScope.enableDebugging$dd_sdk_android_rum_release(this);
        } else {
            rumFeatureScope.disableDebugging$dd_sdk_android_rum_release();
        }
        this.isDebugEnabled.set(value);
    }

    @Override
    public void startView(@NotNull Object key, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.StartView(RumScopeKey.Companion.from(key, name), MapsKt.toMap(attributes), eventTime));
    }

    @Override
    public void stopView(@NotNull Object key, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.StopView(RumScopeKey.Companion.from$default(RumScopeKey.Companion, key, null, 2, null), MapsKt.toMap(attributes), eventTime));
    }

    @Override
    public void addAction(@NotNull RumActionType type, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.StartAction(type, name, false, MapsKt.toMap(attributes), eventTime));
    }

    @Override
    public void startAction(@NotNull RumActionType type, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.StartAction(type, name, true, MapsKt.toMap(attributes), eventTime));
    }

    @Override
    public void stopAction(@NotNull RumActionType type, @NotNull String name, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.StopAction(type, name, MapsKt.toMap(attributes), eventTime));
    }

    @Override
    @Deprecated(message="This method is deprecated and will be removed in the future versions. Use `startResource` method which takes `RumHttpMethod` as `method` parameter instead.")
    public void startResource(@NotNull String key, @NotNull String method, @NotNull String url, @NotNull Map<String, ? extends Object> attributes) {
        RumResourceMethod rumResourceMethod2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        String string = method;
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        switch (string2) {
            case "POST": {
                rumResourceMethod2 = RumResourceMethod.POST;
                break;
            }
            case "GET": {
                rumResourceMethod2 = RumResourceMethod.GET;
                break;
            }
            case "HEAD": {
                rumResourceMethod2 = RumResourceMethod.HEAD;
                break;
            }
            case "PUT": {
                rumResourceMethod2 = RumResourceMethod.PUT;
                break;
            }
            case "DELETE": {
                rumResourceMethod2 = RumResourceMethod.DELETE;
                break;
            }
            case "PATCH": {
                rumResourceMethod2 = RumResourceMethod.PATCH;
                break;
            }
            case "CONNECT": {
                rumResourceMethod2 = RumResourceMethod.CONNECT;
                break;
            }
            case "TRACE": {
                rumResourceMethod2 = RumResourceMethod.TRACE;
                break;
            }
            case "OPTIONS": {
                rumResourceMethod2 = RumResourceMethod.OPTIONS;
                break;
            }
            default: {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(method){
                    final /* synthetic */ String $method;
                    {
                        this.$method = $method;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        String string = "Unsupported HTTP method %s reported, using GET instead";
                        Locale locale = Locale.US;
                        Object[] objectArray = new Object[]{this.$method};
                        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        return string2;
                    }
                }), null, (boolean)false, null, (int)56, null);
                rumResourceMethod2 = RumResourceMethod.GET;
            }
        }
        RumResourceMethod rumResourceMethod3 = rumResourceMethod2;
        this.startResource(key, rumResourceMethod3, url, attributes);
    }

    @Override
    public void startResource(@NotNull String key, @NotNull RumResourceMethod method, @NotNull String url, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.StartResource(key, url, method, MapsKt.toMap(attributes), eventTime));
    }

    @Override
    public void stopResource(@NotNull String key, @Nullable Integer statusCode, @Nullable Long size, @NotNull RumResourceKind kind, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        Integer n = statusCode;
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.StopResource(key, n != null ? Long.valueOf(n.intValue()) : null, size, kind, MapsKt.toMap(attributes), eventTime));
    }

    @Override
    public void stopResourceWithError(@NotNull String key, @Nullable Integer statusCode, @NotNull String message2, @NotNull RumErrorSource source, @NotNull Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Integer n = statusCode;
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.StopResourceWithError(key, n != null ? Long.valueOf(n.intValue()) : null, message2, source, throwable, MapsKt.toMap(attributes), null, 64, null));
    }

    @Override
    public void stopResourceWithError(@NotNull String key, @Nullable Integer statusCode, @NotNull String message2, @NotNull RumErrorSource source, @NotNull String stackTrace, @Nullable String errorType, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Integer n = statusCode;
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.StopResourceWithStackTrace(key, n != null ? Long.valueOf(n.intValue()) : null, message2, source, stackTrace, errorType, MapsKt.toMap(attributes), null, 128, null));
    }

    @Override
    public void startResource(@NotNull ResourceId key, @NotNull RumResourceMethod method, @NotNull String url, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.StartResource(key, url, method, MapsKt.toMap(attributes), eventTime));
    }

    @Override
    public void stopResource(@NotNull ResourceId key, @Nullable Integer statusCode, @Nullable Long size, @NotNull RumResourceKind kind, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        Integer n = statusCode;
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.StopResource(key, n != null ? Long.valueOf(n.intValue()) : null, size, kind, MapsKt.toMap(attributes), eventTime));
    }

    @Override
    public void stopResourceWithError(@NotNull ResourceId key, @Nullable Integer statusCode, @NotNull String message2, @NotNull RumErrorSource source, @NotNull Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Integer n = statusCode;
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.StopResourceWithError(key, n != null ? Long.valueOf(n.intValue()) : null, message2, source, throwable, MapsKt.toMap(attributes), null, 64, null));
    }

    @Override
    public void stopResourceWithError(@NotNull ResourceId key, @Nullable Integer statusCode, @NotNull String message2, @NotNull RumErrorSource source, @NotNull String stackTrace, @Nullable String errorType, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Integer n = statusCode;
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.StopResourceWithStackTrace(key, n != null ? Long.valueOf(n.intValue()) : null, message2, source, stackTrace, errorType, MapsKt.toMap(attributes), null, 128, null));
    }

    @Override
    public void addError(@NotNull String message2, @NotNull RumErrorSource source, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        String errorType = this.getErrorType(attributes);
        Map mutableAttributes = MapsKt.toMutableMap(attributes);
        Object v = mutableAttributes.remove("_dd.error.threads");
        List threads = v instanceof List ? (List)v : null;
        List list = threads;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.AddError(message2, source, throwable, null, false, mutableAttributes, eventTime, errorType, null, list, null, 1280, null));
    }

    @Override
    public void addErrorWithStacktrace(@NotNull String message2, @NotNull RumErrorSource source, @Nullable String stacktrace, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Time eventTime = this.getEventTime(attributes);
        String errorType = this.getErrorType(attributes);
        RumErrorSourceType errorSourceType = this.getErrorSourceType(attributes);
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.AddError(message2, source, null, stacktrace, false, MapsKt.toMap(attributes), eventTime, errorType, errorSourceType, CollectionsKt.emptyList(), null, 1024, null));
    }

    @Override
    public void addFeatureFlagEvaluation(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.AddFeatureFlagEvaluation(name, value, null, 4, null));
    }

    @Override
    public void addFeatureFlagEvaluations(@NotNull Map<String, ? extends Object> featureFlags) {
        Intrinsics.checkNotNullParameter(featureFlags, (String)"featureFlags");
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.AddFeatureFlagEvaluations(featureFlags, null, 2, null));
    }

    @Override
    public void stopSession() {
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.StopSession(null, 1, null));
    }

    @Override
    public void addAttribute(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value == null) {
            this.globalAttributes.remove(key);
        } else {
            this.globalAttributes.put(key, value);
        }
    }

    @Override
    public void removeAttribute(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.globalAttributes.remove(key);
    }

    @Override
    @NotNull
    public Map<String, Object> getAttributes() {
        return this.globalAttributes;
    }

    @Override
    public void clearAttributes() {
        this.globalAttributes.clear();
    }

    @Override
    public void sendWebViewEvent() {
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.WebViewEvent(null, 1, null));
    }

    @Override
    public void resetSession() {
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.ResetSession(null, 1, null));
    }

    @Override
    public void start() {
        int processImportance = DdRumContentProvider.Companion.getProcessImportance$dd_sdk_android_rum_release();
        boolean isAppInForeground = processImportance == 100;
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.SdkInit(isAppInForeground, null, 2, null));
    }

    @Override
    public void waitForResourceTiming(@NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.WaitForResourceTiming(key, null, 2, null));
    }

    @Override
    public void addResourceTiming(@NotNull Object key, @NotNull ResourceTiming timing) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)timing, (String)"timing");
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.AddResourceTiming(key, timing, null, 4, null));
    }

    @Override
    public void addCrash(@NotNull String message2, @NotNull RumErrorSource source, @NotNull Throwable throwable, @NotNull List<ThreadDump> threads) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Intrinsics.checkNotNullParameter(threads, (String)"threads");
        Time now = new Time(0L, 0L, 3, null);
        long timeSinceAppStartNs = now.getNanoTime() - this.sdkCore.getAppStartTimeNs();
        Map map = MapsKt.emptyMap();
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.AddError(message2, source, throwable, null, true, map, now, null, null, threads, timeSinceAppStartNs, 384, null));
    }

    @Override
    public void addTiming(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.AddCustomTiming(name, null, 2, null));
    }

    @Override
    @ExperimentalRumApi
    public void addViewLoadingTime(boolean overwrite) {
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.AddViewLoadingTime(overwrite, null, 2, null));
    }

    @Override
    public void addLongTask(long durationNs, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.AddLongTask(durationNs, target, null, 4, null));
    }

    @Override
    public void eventSent(@NotNull String viewId, @NotNull StorageEvent event) {
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        StorageEvent storageEvent = event;
        if (storageEvent instanceof StorageEvent.Action) {
            this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.ActionSent(viewId, ((StorageEvent.Action)event).getFrustrationCount(), ((StorageEvent.Action)event).getType(), ((StorageEvent.Action)event).getEventEndTimestampInNanos(), null, 16, null));
        } else if (storageEvent instanceof StorageEvent.Resource) {
            this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.ResourceSent(viewId, ((StorageEvent.Resource)event).getResourceId(), ((StorageEvent.Resource)event).getResourceStopTimestampInNanos(), null, 8, null));
        } else if (storageEvent instanceof StorageEvent.Error) {
            this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.ErrorSent(viewId, ((StorageEvent.Error)event).getResourceId(), ((StorageEvent.Error)event).getResourceStopTimestampInNanos(), null, 8, null));
        } else if (storageEvent instanceof StorageEvent.LongTask) {
            this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.LongTaskSent(viewId, false, null, 4, null));
        } else if (storageEvent instanceof StorageEvent.FrozenFrame) {
            this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.LongTaskSent(viewId, true, null, 4, null));
        } else if (storageEvent instanceof StorageEvent.View) {
            // empty if block
        }
    }

    @Override
    public void eventDropped(@NotNull String viewId, @NotNull StorageEvent event) {
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        StorageEvent storageEvent = event;
        if (storageEvent instanceof StorageEvent.Action) {
            this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.ActionDropped(viewId, null, 2, null));
        } else if (storageEvent instanceof StorageEvent.Resource) {
            this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.ResourceDropped(viewId, ((StorageEvent.Resource)event).getResourceId(), null, 4, null));
        } else if (storageEvent instanceof StorageEvent.Error) {
            this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.ErrorDropped(viewId, ((StorageEvent.Error)event).getResourceId(), null, 4, null));
        } else if (storageEvent instanceof StorageEvent.LongTask) {
            this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.LongTaskDropped(viewId, false, null, 4, null));
        } else if (storageEvent instanceof StorageEvent.FrozenFrame) {
            this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.LongTaskDropped(viewId, true, null, 4, null));
        } else if (storageEvent instanceof StorageEvent.View) {
            // empty if block
        }
    }

    @Override
    public void setDebugListener(@Nullable RumDebugListener listener) {
        this.debugListener = listener;
    }

    @Override
    public void addSessionReplaySkippedFrame() {
        this.getCurrentSessionId((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ DatadogRumMonitor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable String sessionId) {
                block0: {
                    String string = sessionId;
                    if (string == null) break block0;
                    String string2 = string;
                    DatadogRumMonitor datadogRumMonitor = this.this$0;
                    String it = string2;
                    boolean bl = false;
                    DatadogRumMonitor.access$getSessionEndedMetricDispatcher$p(datadogRumMonitor).onSessionReplaySkippedFrameTracked(it);
                }
            }
        }));
    }

    @Override
    public void notifyInterceptorInstantiated() {
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.TelemetryEventWrapper((InternalTelemetryEvent)InternalTelemetryEvent.InterceptorInstantiated.INSTANCE, null, 2, null));
    }

    @Override
    public void updatePerformanceMetric(@NotNull RumPerformanceMetric metric, double value) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.UpdatePerformanceMetric(metric, value, null, 4, null));
    }

    @Override
    public void setSyntheticsAttribute(@NotNull String testId, @NotNull String resultId) {
        Intrinsics.checkNotNullParameter((Object)testId, (String)"testId");
        Intrinsics.checkNotNullParameter((Object)resultId, (String)"resultId");
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.SetSyntheticsTestAttribute(testId, resultId, null, 4, null));
    }

    @Override
    @NotNull
    public _RumInternalProxy _getInternal() {
        return this.internalProxy;
    }

    @Override
    public void sendTelemetryEvent(@NotNull InternalTelemetryEvent telemetryEvent) {
        Intrinsics.checkNotNullParameter((Object)telemetryEvent, (String)"telemetryEvent");
        this.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.TelemetryEventWrapper(telemetryEvent, null, 2, null));
    }

    public final void drainExecutorService$dd_sdk_android_rum_release() throws UnsupportedOperationException, InterruptedException {
        ThreadPoolExecutor threadPoolExecutor;
        ArrayList tasks = new ArrayList();
        Object object = this.executorService;
        ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor = object instanceof ThreadPoolExecutor ? (ThreadPoolExecutor)object : null;
        if (threadPoolExecutor != null && (object = threadPoolExecutor.getQueue()) != null) {
            object.drainTo(tasks);
        }
        this.executorService.shutdown();
        this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Runnable it = (Runnable)element$iv;
            boolean bl = false;
            it.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleEvent$dd_sdk_android_rum_release(@NotNull RumRawEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof RumRawEvent.AddError && ((RumRawEvent.AddError)event).isFatal()) {
            RumScope rumScope = this.rootScope;
            synchronized (rumScope) {
                boolean bl = false;
                RumScope rumScope2 = this.rootScope.handleEvent(event, this.writer);
            }
        } else if (event instanceof RumRawEvent.TelemetryEventWrapper) {
            this.telemetryEventHandler.handleEvent((RumRawEvent.TelemetryEventWrapper)event, this.writer);
        } else {
            this.handler.removeCallbacks(this.keepAliveRunnable);
            if (!this.executorService.isShutdown()) {
                ConcurrencyExtKt.submitSafe((ExecutorService)this.executorService, (String)"Rum event handling", (InternalLogger)this.sdkCore.getInternalLogger(), () -> DatadogRumMonitor.handleEvent$lambda$6(this, event));
            }
        }
    }

    private final void waitForPendingEvents() {
        if (!this.executorService.isShutdown()) {
            CountDownLatch latch = new CountDownLatch(1);
            ConcurrencyExtKt.submitSafe((ExecutorService)this.executorService, (String)"pending event waiting", (InternalLogger)this.sdkCore.getInternalLogger(), () -> DatadogRumMonitor.waitForPendingEvents$lambda$7(latch));
            try {
                latch.await(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)waitForPendingEvents.2.INSTANCE, null, (boolean)false, null, (int)56, null);
            }
        }
    }

    public final void stopKeepAliveCallback$dd_sdk_android_rum_release() {
        this.handler.removeCallbacks(this.keepAliveRunnable);
    }

    /*
     * WARNING - void declaration
     */
    public final void notifyDebugListenerWithState$dd_sdk_android_rum_release() {
        block4: {
            RumViewManagerScope viewManagerScope;
            RumSessionScope sessionScope;
            RumApplicationScope applicationScope;
            RumDebugListener rumDebugListener = this.debugListener;
            if (rumDebugListener == null) break block4;
            RumDebugListener it = rumDebugListener;
            boolean bl = false;
            RumScope rumScope = this.rootScope;
            RumApplicationScope rumApplicationScope = applicationScope = rumScope instanceof RumApplicationScope ? (RumApplicationScope)rumScope : null;
            RumScope rumScope2 = rumApplicationScope != null ? rumApplicationScope.getActiveSession() : null;
            RumSessionScope rumSessionScope = sessionScope = rumScope2 instanceof RumSessionScope ? (RumSessionScope)rumScope2 : null;
            Object object = rumSessionScope != null ? rumSessionScope.getChildScope$dd_sdk_android_rum_release() : null;
            RumViewManagerScope rumViewManagerScope = viewManagerScope = object instanceof RumViewManagerScope ? (RumViewManagerScope)object : null;
            if (viewManagerScope != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                object = viewManagerScope.getChildrenScopes$dd_sdk_android_rum_release();
                RumDebugListener rumDebugListener2 = it;
                boolean $i$f$filterIsInstance = false;
                void var9_9 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof RumViewScope)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    RumViewScope viewScope = (RumViewScope)element$iv$iv;
                    boolean bl2 = false;
                    if (!viewScope.isActive()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    RumViewScope viewScope = (RumViewScope)element$iv$iv;
                    boolean bl4 = false;
                    if (viewScope.getRumContext().getViewName() == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                rumDebugListener2.onReceiveRumActiveViews((List)destination$iv$iv);
            }
        }
    }

    private final Time getEventTime(Map<String, ? extends Object> attributes) {
        Object object = attributes.get("_dd.timestamp");
        Object object2 = object instanceof Long ? (Long)object : null;
        if (object2 == null || (object2 = TimeKt.asTime((Long)object2)) == null) {
            object2 = new Time(0L, 0L, 3, null);
        }
        return object2;
    }

    private final String getErrorType(Map<String, ? extends Object> attributes) {
        Object object = attributes.get("_dd.error_type");
        return object instanceof String ? (String)object : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final RumErrorSourceType getErrorSourceType(Map<String, ? extends Object> attributes) {
        RumErrorSourceType rumErrorSourceType;
        Object object;
        String sourceType;
        Object object2 = attributes.get("_dd.error.source_type");
        String string = sourceType = object2 instanceof String ? (String)object2 : null;
        if (string != null) {
            String string2 = string;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = string2.toLowerCase(locale);
            object = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            object = object2 = null;
        }
        if (object2 != null) {
            int n = -1;
            switch (((String)object2).hashCode()) {
                case -380982102: {
                    if (!((String)object2).equals("ndk+il2cpp")) break;
                    n = 1;
                    break;
                }
                case 828638245: {
                    if (!((String)object2).equals("react-native")) break;
                    n = 2;
                    break;
                }
                case -760334308: {
                    if (!((String)object2).equals("flutter")) break;
                    n = 3;
                    break;
                }
                case 108917: {
                    if (!((String)object2).equals("ndk")) break;
                    n = 4;
                    break;
                }
                case -861391249: {
                    if (!((String)object2).equals("android")) break;
                    n = 5;
                    break;
                }
                case 150940456: {
                    if (!((String)object2).equals("browser")) break;
                    n = 6;
                    break;
                }
            }
            switch (n) {
                case 5: {
                    rumErrorSourceType = RumErrorSourceType.ANDROID;
                    return rumErrorSourceType;
                }
                case 2: {
                    rumErrorSourceType = RumErrorSourceType.REACT_NATIVE;
                    return rumErrorSourceType;
                }
                case 6: {
                    rumErrorSourceType = RumErrorSourceType.BROWSER;
                    return rumErrorSourceType;
                }
                case 3: {
                    rumErrorSourceType = RumErrorSourceType.FLUTTER;
                    return rumErrorSourceType;
                }
                case 4: {
                    rumErrorSourceType = RumErrorSourceType.NDK;
                    return rumErrorSourceType;
                }
                case 1: {
                    rumErrorSourceType = RumErrorSourceType.NDK_IL2CPP;
                    return rumErrorSourceType;
                }
            }
        }
        rumErrorSourceType = RumErrorSourceType.ANDROID;
        return rumErrorSourceType;
    }

    private static final void keepAliveRunnable$lambda$0(DatadogRumMonitor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.handleEvent$dd_sdk_android_rum_release(new RumRawEvent.KeepAlive(null, 1, null));
    }

    private static final void getCurrentSessionId$lambda$2(DatadogRumMonitor this$0, Function1 $callback) {
        String string;
        RumContext rumContext;
        RumApplicationScope rumApplicationScope;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        RumScope rumScope = this$0.rootScope;
        RumApplicationScope rumApplicationScope2 = rumApplicationScope = rumScope instanceof RumApplicationScope ? (RumApplicationScope)rumScope : null;
        if (rumApplicationScope != null && (rumScope = rumApplicationScope.getActiveSession()) != null && (rumContext = rumScope.getRumContext()) != null) {
            RumContext it = rumContext;
            boolean bl = false;
            String sessionId = it.getSessionId();
            string = it.getSessionState() == RumSessionScope.State.NOT_TRACKED || Intrinsics.areEqual((Object)sessionId, (Object)RumContext.Companion.getNULL_UUID()) ? null : sessionId;
        } else {
            string = null;
        }
        String activeSessionId = string;
        $callback.invoke(activeSessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void handleEvent$lambda$6(DatadogRumMonitor this$0, RumRawEvent $event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        RumScope rumScope = this$0.rootScope;
        synchronized (rumScope) {
            boolean bl = false;
            this$0.rootScope.handleEvent($event, this$0.writer);
            this$0.notifyDebugListenerWithState$dd_sdk_android_rum_release();
            Unit unit = Unit.INSTANCE;
        }
        this$0.handler.postDelayed(this$0.keepAliveRunnable, KEEP_ALIVE_MS);
    }

    private static final void waitForPendingEvents$lambda$7(CountDownLatch $latch) {
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        $latch.countDown();
    }

    public static final /* synthetic */ SessionMetricDispatcher access$getSessionEndedMetricDispatcher$p(DatadogRumMonitor $this) {
        return $this.sessionEndedMetricDispatcher;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/rum/internal/monitor/DatadogRumMonitor$Companion;", "", "()V", "DRAIN_WAIT_SECONDS", "", "KEEP_ALIVE_MS", "getKEEP_ALIVE_MS$dd_sdk_android_rum_release", "()J", "RUM_DEBUG_RUM_NOT_ENABLED_WARNING", "", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getKEEP_ALIVE_MS$dd_sdk_android_rum_release() {
            return KEEP_ALIVE_MS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

