/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.core.InternalSdkCore;
import com.datadog.android.core.internal.net.FirstPartyHostHeaderTypeResolver;
import com.datadog.android.core.metrics.MethodCallSamplingRate;
import com.datadog.android.internal.telemetry.InternalTelemetryEvent;
import com.datadog.android.rum.DdRumContentProvider;
import com.datadog.android.rum.internal.anr.ANRException;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.Time;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.internal.domain.scope.RumScopeKey;
import com.datadog.android.rum.internal.domain.scope.RumViewChangedListener;
import com.datadog.android.rum.internal.domain.scope.RumViewInfo;
import com.datadog.android.rum.internal.domain.scope.RumViewManagerScope;
import com.datadog.android.rum.internal.domain.scope.RumViewScope;
import com.datadog.android.rum.internal.metric.SessionEndedMetric;
import com.datadog.android.rum.internal.metric.SessionMetricDispatcher;
import com.datadog.android.rum.internal.metric.interactiontonextview.InteractionToNextViewMetricResolver;
import com.datadog.android.rum.internal.metric.networksettled.NetworkSettledMetricResolver;
import com.datadog.android.rum.internal.vitals.NoOpVitalMonitor;
import com.datadog.android.rum.internal.vitals.VitalMonitor;
import com.datadog.android.rum.metric.interactiontonextview.LastInteractionIdentifier;
import com.datadog.android.rum.metric.networksettled.InitialResourceIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 E2\u00020\u0001:\u0001EBw\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\b\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020)H\u0002J\u0010\u00102\u001a\u0002002\u0006\u00103\u001a\u000204H\u0002J\u001e\u00105\u001a\u0002062\u0006\u00103\u001a\u0002042\f\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0003J\b\u0010:\u001a\u00020;H\u0016J\u001e\u0010<\u001a\u0002062\u0006\u00103\u001a\u0002042\f\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0003J \u0010=\u001a\u0004\u0018\u00010\u00012\u0006\u00103\u001a\u0002042\f\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0017J\u001e\u0010>\u001a\u0002062\u0006\u00103\u001a\u0002042\f\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0003J\b\u0010?\u001a\u00020\bH\u0016J\b\u0010@\u001a\u00020\bH\u0002J\u001e\u0010A\u001a\u0002062\u0006\u00103\u001a\u00020B2\f\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0003J\u001e\u0010C\u001a\u0002062\u0006\u00103\u001a\u00020D2\f\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0003R\u001a\u0010\u0012\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001b\"\u0004\b.\u0010\u001dR\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumViewManagerScope;", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "sdkCore", "Lcom/datadog/android/core/InternalSdkCore;", "sessionEndedMetricDispatcher", "Lcom/datadog/android/rum/internal/metric/SessionMetricDispatcher;", "backgroundTrackingEnabled", "", "trackFrustrations", "viewChangedListener", "Lcom/datadog/android/rum/internal/domain/scope/RumViewChangedListener;", "firstPartyHostHeaderTypeResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "cpuVitalMonitor", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "memoryVitalMonitor", "frameRateVitalMonitor", "applicationDisplayed", "sampleRate", "", "initialResourceIdentifier", "Lcom/datadog/android/rum/metric/networksettled/InitialResourceIdentifier;", "lastInteractionIdentifier", "Lcom/datadog/android/rum/metric/interactiontonextview/LastInteractionIdentifier;", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;Lcom/datadog/android/core/InternalSdkCore;Lcom/datadog/android/rum/internal/metric/SessionMetricDispatcher;ZZLcom/datadog/android/rum/internal/domain/scope/RumViewChangedListener;Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;ZFLcom/datadog/android/rum/metric/networksettled/InitialResourceIdentifier;Lcom/datadog/android/rum/metric/interactiontonextview/LastInteractionIdentifier;)V", "getApplicationDisplayed$dd_sdk_android_rum_release", "()Z", "setApplicationDisplayed$dd_sdk_android_rum_release", "(Z)V", "childrenScopes", "", "getChildrenScopes$dd_sdk_android_rum_release", "()Ljava/util/List;", "getFirstPartyHostHeaderTypeResolver$dd_sdk_android_rum_release", "()Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "getInitialResourceIdentifier$dd_sdk_android_rum_release", "()Lcom/datadog/android/rum/metric/networksettled/InitialResourceIdentifier;", "interactionToNextViewMetricResolver", "Lcom/datadog/android/rum/internal/metric/interactiontonextview/InteractionToNextViewMetricResolver;", "lastStoppedViewTime", "Lcom/datadog/android/rum/internal/domain/Time;", "getSampleRate$dd_sdk_android_rum_release", "()F", "stopped", "getStopped$dd_sdk_android_rum_release", "setStopped$dd_sdk_android_rum_release", "createAppLaunchViewScope", "Lcom/datadog/android/rum/internal/domain/scope/RumViewScope;", "time", "createBackgroundViewScope", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "delegateToChildren", "", "writer", "Lcom/datadog/android/api/storage/DataWriter;", "", "getRumContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "handleBackgroundEvent", "handleEvent", "handleOrphanEvent", "isActive", "isViewManagerComplete", "startApplicationLaunchView", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$ApplicationStarted;", "startForegroundView", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartView;", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nRumViewManagerScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RumViewManagerScope.kt\ncom/datadog/android/rum/internal/domain/scope/RumViewManagerScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,365:1\n1774#2,4:366\n*S KotlinDebug\n*F\n+ 1 RumViewManagerScope.kt\ncom/datadog/android/rum/internal/domain/scope/RumViewManagerScope\n*L\n95#1:366,4\n*E\n"})
public final class RumViewManagerScope
implements RumScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RumScope parentScope;
    @NotNull
    private final InternalSdkCore sdkCore;
    @NotNull
    private final SessionMetricDispatcher sessionEndedMetricDispatcher;
    private final boolean backgroundTrackingEnabled;
    private final boolean trackFrustrations;
    @Nullable
    private final RumViewChangedListener viewChangedListener;
    @NotNull
    private final FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver;
    @NotNull
    private final VitalMonitor cpuVitalMonitor;
    @NotNull
    private final VitalMonitor memoryVitalMonitor;
    @NotNull
    private final VitalMonitor frameRateVitalMonitor;
    private boolean applicationDisplayed;
    private final float sampleRate;
    @NotNull
    private final InitialResourceIdentifier initialResourceIdentifier;
    @NotNull
    private final InteractionToNextViewMetricResolver interactionToNextViewMetricResolver;
    @NotNull
    private final List<RumScope> childrenScopes;
    private boolean stopped;
    @Nullable
    private Time lastStoppedViewTime;
    @NotNull
    private static final Class<?>[] validBackgroundEventTypes;
    @NotNull
    private static final Class<?>[] silentOrphanEventTypes;
    @NotNull
    public static final String RUM_BACKGROUND_VIEW_ID = "com.datadog.background.view";
    @NotNull
    public static final String RUM_BACKGROUND_VIEW_URL = "com/datadog/background/view";
    @NotNull
    public static final String RUM_BACKGROUND_VIEW_NAME = "Background";
    @NotNull
    public static final String RUM_APP_LAUNCH_VIEW_ID = "com.datadog.application-launch.view";
    @NotNull
    public static final String RUM_APP_LAUNCH_VIEW_URL = "com/datadog/application-launch/view";
    @NotNull
    public static final String RUM_APP_LAUNCH_VIEW_NAME = "ApplicationLaunch";
    @NotNull
    private static final String MESSAGE_GAP_BETWEEN_VIEWS = "[Mobile Metric] Gap between views";
    @NotNull
    private static final String MESSAGE_NEG_GAP_BETWEEN_VIEWS = "[Mobile Metric] Negative gap between views";
    @NotNull
    public static final String ATTR_GAP_BETWEEN_VIEWS = "view_gap";
    @NotNull
    public static final String MESSAGE_MISSING_VIEW = "A RUM event was detected, but no view is active. To track views automatically, try calling the RumConfiguration.Builder.useViewTrackingStrategy() method.\nYou can also track views manually using the RumMonitor.startView() and RumMonitor.stopView() methods.";
    @NotNull
    public static final String MESSAGE_UNKNOWN_MISSED_TYPE = "An RUM event was detected, but no view is active, its missed type is unknown";
    private static final long THREE_SECONDS_GAP_NS;

    public RumViewManagerScope(@NotNull RumScope parentScope, @NotNull InternalSdkCore sdkCore, @NotNull SessionMetricDispatcher sessionEndedMetricDispatcher, boolean backgroundTrackingEnabled, boolean trackFrustrations, @Nullable RumViewChangedListener viewChangedListener, @NotNull FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, @NotNull VitalMonitor cpuVitalMonitor, @NotNull VitalMonitor memoryVitalMonitor, @NotNull VitalMonitor frameRateVitalMonitor, boolean applicationDisplayed, float sampleRate, @NotNull InitialResourceIdentifier initialResourceIdentifier, @NotNull LastInteractionIdentifier lastInteractionIdentifier) {
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)sessionEndedMetricDispatcher, (String)"sessionEndedMetricDispatcher");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostHeaderTypeResolver, (String)"firstPartyHostHeaderTypeResolver");
        Intrinsics.checkNotNullParameter((Object)cpuVitalMonitor, (String)"cpuVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)memoryVitalMonitor, (String)"memoryVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)frameRateVitalMonitor, (String)"frameRateVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)initialResourceIdentifier, (String)"initialResourceIdentifier");
        Intrinsics.checkNotNullParameter((Object)lastInteractionIdentifier, (String)"lastInteractionIdentifier");
        this.parentScope = parentScope;
        this.sdkCore = sdkCore;
        this.sessionEndedMetricDispatcher = sessionEndedMetricDispatcher;
        this.backgroundTrackingEnabled = backgroundTrackingEnabled;
        this.trackFrustrations = trackFrustrations;
        this.viewChangedListener = viewChangedListener;
        this.firstPartyHostHeaderTypeResolver = firstPartyHostHeaderTypeResolver;
        this.cpuVitalMonitor = cpuVitalMonitor;
        this.memoryVitalMonitor = memoryVitalMonitor;
        this.frameRateVitalMonitor = frameRateVitalMonitor;
        this.applicationDisplayed = applicationDisplayed;
        this.sampleRate = sampleRate;
        this.initialResourceIdentifier = initialResourceIdentifier;
        this.interactionToNextViewMetricResolver = new InteractionToNextViewMetricResolver(this.sdkCore.getInternalLogger(), null, lastInteractionIdentifier, 2, null);
        this.childrenScopes = new ArrayList();
    }

    @NotNull
    public final FirstPartyHostHeaderTypeResolver getFirstPartyHostHeaderTypeResolver$dd_sdk_android_rum_release() {
        return this.firstPartyHostHeaderTypeResolver;
    }

    public final boolean getApplicationDisplayed$dd_sdk_android_rum_release() {
        return this.applicationDisplayed;
    }

    public final void setApplicationDisplayed$dd_sdk_android_rum_release(boolean bl) {
        this.applicationDisplayed = bl;
    }

    public final float getSampleRate$dd_sdk_android_rum_release() {
        return this.sampleRate;
    }

    @NotNull
    public final InitialResourceIdentifier getInitialResourceIdentifier$dd_sdk_android_rum_release() {
        return this.initialResourceIdentifier;
    }

    @NotNull
    public final List<RumScope> getChildrenScopes$dd_sdk_android_rum_release() {
        return this.childrenScopes;
    }

    public final boolean getStopped$dd_sdk_android_rum_release() {
        return this.stopped;
    }

    public final void setStopped$dd_sdk_android_rum_release(boolean bl) {
        this.stopped = bl;
    }

    @Override
    @WorkerThread
    @Nullable
    public RumScope handleEvent(@NotNull RumRawEvent event, @NotNull DataWriter<Object> writer) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        if (event instanceof RumRawEvent.ApplicationStarted && !this.applicationDisplayed && !this.stopped) {
            this.startApplicationLaunchView((RumRawEvent.ApplicationStarted)event, writer);
            return this;
        }
        this.delegateToChildren(event, writer);
        if (event instanceof RumRawEvent.StartView && !this.stopped) {
            this.startForegroundView((RumRawEvent.StartView)event, writer);
            Time time = this.lastStoppedViewTime;
            if (time != null) {
                Time it = time;
                boolean bl = false;
                long gap = event.getEventTime().getNanoTime() - it.getNanoTime();
                boolean bl2 = 1L <= gap ? gap < THREE_SECONDS_GAP_NS : false;
                if (bl2) {
                    InternalLogger.DefaultImpls.logMetric$default((InternalLogger)this.sdkCore.getInternalLogger(), (Function0)((Function0)new Function0<String>(gap){
                        final /* synthetic */ long $gap;
                        {
                            this.$gap = $gap;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            String string = "[Mobile Metric] Gap between views";
                            Locale locale = Locale.US;
                            Object[] objectArray = new Object[]{this.$gap};
                            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                            return string2;
                        }
                    }), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)ATTR_GAP_BETWEEN_VIEWS, (Object)gap)), (float)MethodCallSamplingRate.MEDIUM.getRate(), null, (int)8, null);
                } else if (gap < 0L) {
                    InternalLogger.DefaultImpls.logMetric$default((InternalLogger)this.sdkCore.getInternalLogger(), (Function0)((Function0)new Function0<String>(gap){
                        final /* synthetic */ long $gap;
                        {
                            this.$gap = $gap;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            String string = "[Mobile Metric] Negative gap between views";
                            Locale locale = Locale.US;
                            Object[] objectArray = new Object[]{this.$gap};
                            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                            return string2;
                        }
                    }), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)ATTR_GAP_BETWEEN_VIEWS, (Object)gap)), (float)MethodCallSamplingRate.MEDIUM.getRate(), null, (int)8, null);
                }
            }
            this.lastStoppedViewTime = null;
        } else if (event instanceof RumRawEvent.StopSession) {
            this.stopped = true;
        } else {
            int n;
            Iterable $this$count$iv = this.childrenScopes;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    RumScope it = (RumScope)element$iv;
                    boolean bl = false;
                    if (!it.isActive() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (n == 0) {
                this.handleOrphanEvent(event, writer);
            }
        }
        return this.isViewManagerComplete() ? null : (RumScope)this;
    }

    @Override
    @NotNull
    public RumContext getRumContext() {
        return this.parentScope.getRumContext();
    }

    @Override
    public boolean isActive() {
        return !this.stopped;
    }

    private final boolean isViewManagerComplete() {
        return this.stopped && this.childrenScopes.isEmpty();
    }

    @WorkerThread
    private final void startApplicationLaunchView(RumRawEvent.ApplicationStarted event, DataWriter<Object> writer) {
        RumViewScope viewScope = this.createAppLaunchViewScope(event.getEventTime());
        this.applicationDisplayed = true;
        viewScope.handleEvent(event, writer);
        this.childrenScopes.add(viewScope);
    }

    @WorkerThread
    private final void delegateToChildren(RumRawEvent event, DataWriter<Object> writer) {
        Iterator<RumScope> iterator = this.childrenScopes.iterator();
        while (iterator.hasNext()) {
            RumScope result;
            Object object;
            RumScope childScope = iterator.next();
            if (event instanceof RumRawEvent.StopView && childScope.isActive() && Intrinsics.areEqual((Object)((object = childScope instanceof RumViewScope ? (RumViewScope)childScope : null) != null && (object = ((RumViewScope)object).getKey$dd_sdk_android_rum_release()) != null ? ((RumScopeKey)object).getId() : null), (Object)((RumRawEvent.StopView)event).getKey().getId())) {
                this.lastStoppedViewTime = event.getEventTime();
            }
            if ((result = childScope.handleEvent(event, writer)) != null) continue;
            iterator.remove();
        }
    }

    @WorkerThread
    private final void handleOrphanEvent(RumRawEvent event, DataWriter<Object> writer) {
        block6: {
            Unit unit;
            int importanceForeground;
            boolean isForegroundProcess;
            int processFlag = DdRumContentProvider.Companion.getProcessImportance$dd_sdk_android_rum_release();
            boolean bl = isForegroundProcess = processFlag == (importanceForeground = 100);
            if (event instanceof RumRawEvent.AddViewLoadingTime) {
                InternalLogger internalLogger = this.sdkCore.getInternalLogger();
                InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)handleOrphanEvent.1.INSTANCE, null, (boolean)false, null, (int)56, null);
                InternalLogger.DefaultImpls.logApiUsage$default((InternalLogger)internalLogger, (float)0.0f, (Function0)((Function0)new Function0<InternalTelemetryEvent.ApiUsage>(event){
                    final /* synthetic */ RumRawEvent $event;
                    {
                        this.$event = $event;
                        super(0);
                    }

                    @NotNull
                    public final InternalTelemetryEvent.ApiUsage invoke() {
                        return (InternalTelemetryEvent.ApiUsage)new InternalTelemetryEvent.ApiUsage.AddViewLoadingTime(((RumRawEvent.AddViewLoadingTime)this.$event).getOverwrite(), true, false, null, 8, null);
                    }
                }), (int)1, null);
                return;
            }
            if (this.applicationDisplayed || !isForegroundProcess) {
                this.handleBackgroundEvent(event, writer);
            } else {
                boolean isSilentOrphanEvent = ArraysKt.contains((Object[])silentOrphanEventTypes, event.getClass());
                if (!isSilentOrphanEvent) {
                    InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)handleOrphanEvent.3.INSTANCE, null, (boolean)false, null, (int)56, null);
                }
            }
            SessionEndedMetric.MissedEventType missedEventType = SessionEndedMetric.MissedEventType.Companion.fromRawEvent(event);
            if (missedEventType != null) {
                SessionEndedMetric.MissedEventType it = missedEventType;
                boolean bl2 = false;
                this.sessionEndedMetricDispatcher.onMissedEventTracked(this.parentScope.getRumContext().getSessionId(), it);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block6;
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)handleOrphanEvent.5.INSTANCE, null, (boolean)false, null, (int)56, null);
        }
    }

    @WorkerThread
    private final void startForegroundView(RumRawEvent.StartView event, DataWriter<Object> writer) {
        block0: {
            RumViewScope viewScope = RumViewScope.Companion.fromEvent$dd_sdk_android_rum_release(this, this.sessionEndedMetricDispatcher, this.sdkCore, event, this.viewChangedListener, this.firstPartyHostHeaderTypeResolver, this.cpuVitalMonitor, this.memoryVitalMonitor, this.frameRateVitalMonitor, this.trackFrustrations, this.sampleRate, this.interactionToNextViewMetricResolver, this.initialResourceIdentifier);
            this.applicationDisplayed = true;
            this.childrenScopes.add(viewScope);
            viewScope.handleEvent(new RumRawEvent.KeepAlive(null, 1, null), writer);
            RumViewChangedListener rumViewChangedListener = this.viewChangedListener;
            if (rumViewChangedListener == null) break block0;
            rumViewChangedListener.onViewChanged(new RumViewInfo(event.getKey(), event.getAttributes(), true));
        }
    }

    @WorkerThread
    private final void handleBackgroundEvent(RumRawEvent event, DataWriter<Object> writer) {
        if (event instanceof RumRawEvent.AddError && ((RumRawEvent.AddError)event).getThrowable() instanceof ANRException) {
            return;
        }
        boolean isValidBackgroundEvent = ArraysKt.contains((Object[])validBackgroundEventTypes, event.getClass());
        boolean isSilentOrphanEvent = ArraysKt.contains((Object[])silentOrphanEventTypes, event.getClass());
        if (isValidBackgroundEvent && this.backgroundTrackingEnabled) {
            RumViewScope viewScope = this.createBackgroundViewScope(event);
            viewScope.handleEvent(event, writer);
            this.childrenScopes.add(viewScope);
            this.lastStoppedViewTime = null;
        } else if (!isSilentOrphanEvent) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)handleBackgroundEvent.1.INSTANCE, null, (boolean)false, null, (int)56, null);
        }
    }

    private final RumViewScope createBackgroundViewScope(RumRawEvent event) {
        return new RumViewScope(this, this.sdkCore, this.sessionEndedMetricDispatcher, new RumScopeKey(RUM_BACKGROUND_VIEW_ID, RUM_BACKGROUND_VIEW_URL, RUM_BACKGROUND_VIEW_NAME), event.getEventTime(), MapsKt.emptyMap(), this.viewChangedListener, this.firstPartyHostHeaderTypeResolver, new NoOpVitalMonitor(), new NoOpVitalMonitor(), new NoOpVitalMonitor(), null, RumViewScope.RumViewType.BACKGROUND, this.trackFrustrations, this.sampleRate, this.interactionToNextViewMetricResolver, new NetworkSettledMetricResolver(this.initialResourceIdentifier, this.sdkCore.getInternalLogger()), 2048, null);
    }

    private final RumViewScope createAppLaunchViewScope(Time time) {
        return new RumViewScope(this, this.sdkCore, this.sessionEndedMetricDispatcher, new RumScopeKey(RUM_APP_LAUNCH_VIEW_ID, RUM_APP_LAUNCH_VIEW_URL, RUM_APP_LAUNCH_VIEW_NAME), time, MapsKt.emptyMap(), this.viewChangedListener, this.firstPartyHostHeaderTypeResolver, new NoOpVitalMonitor(), new NoOpVitalMonitor(), new NoOpVitalMonitor(), null, RumViewScope.RumViewType.APPLICATION_LAUNCH, this.trackFrustrations, this.sampleRate, this.interactionToNextViewMetricResolver, new NetworkSettledMetricResolver(this.initialResourceIdentifier, this.sdkCore.getInternalLogger()), 2048, null);
    }

    static {
        Class[] classArray = new Class[]{RumRawEvent.AddError.class, RumRawEvent.StartAction.class, RumRawEvent.StartResource.class};
        validBackgroundEventTypes = classArray;
        classArray = new Class[]{RumRawEvent.ApplicationStarted.class, RumRawEvent.KeepAlive.class, RumRawEvent.ResetSession.class, RumRawEvent.StopView.class, RumRawEvent.ActionDropped.class, RumRawEvent.ActionSent.class, RumRawEvent.ErrorDropped.class, RumRawEvent.ErrorSent.class, RumRawEvent.LongTaskDropped.class, RumRawEvent.LongTaskSent.class, RumRawEvent.ResourceDropped.class, RumRawEvent.ResourceSent.class, RumRawEvent.UpdatePerformanceMetric.class};
        silentOrphanEventTypes = classArray;
        THREE_SECONDS_GAP_NS = TimeUnit.SECONDS.toNanos(3L);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u001a\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumViewManagerScope$Companion;", "", "()V", "ATTR_GAP_BETWEEN_VIEWS", "", "MESSAGE_GAP_BETWEEN_VIEWS", "MESSAGE_MISSING_VIEW", "MESSAGE_NEG_GAP_BETWEEN_VIEWS", "MESSAGE_UNKNOWN_MISSED_TYPE", "RUM_APP_LAUNCH_VIEW_ID", "RUM_APP_LAUNCH_VIEW_NAME", "RUM_APP_LAUNCH_VIEW_URL", "RUM_BACKGROUND_VIEW_ID", "RUM_BACKGROUND_VIEW_NAME", "RUM_BACKGROUND_VIEW_URL", "THREE_SECONDS_GAP_NS", "", "getTHREE_SECONDS_GAP_NS$dd_sdk_android_rum_release", "()J", "silentOrphanEventTypes", "", "Ljava/lang/Class;", "getSilentOrphanEventTypes$dd_sdk_android_rum_release", "()[Ljava/lang/Class;", "[Ljava/lang/Class;", "validBackgroundEventTypes", "getValidBackgroundEventTypes$dd_sdk_android_rum_release", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Class<?>[] getValidBackgroundEventTypes$dd_sdk_android_rum_release() {
            return validBackgroundEventTypes;
        }

        @NotNull
        public final Class<?>[] getSilentOrphanEventTypes$dd_sdk_android_rum_release() {
            return silentOrphanEventTypes;
        }

        public final long getTHREE_SECONDS_GAP_NS$dd_sdk_android_rum_release() {
            return THREE_SECONDS_GAP_NS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

