/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import android.app.Activity;
import android.content.ComponentName;
import androidx.navigation.ActivityNavigator;
import androidx.navigation.fragment.DialogFragmentNavigator;
import androidx.navigation.fragment.FragmentNavigator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumScopeKey;", "", "id", "", "url", "name", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getName", "getUrl", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "dd-sdk-android-rum_release"})
public final class RumScopeKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String url;
    @NotNull
    private final String name;

    public RumScopeKey(@NotNull String id, @NotNull String url, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.id = id;
        this.url = url;
        this.name = name;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.url;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final RumScopeKey copy(@NotNull String id, @NotNull String url, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new RumScopeKey(id, url, name);
    }

    public static /* synthetic */ RumScopeKey copy$default(RumScopeKey rumScopeKey, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = rumScopeKey.id;
        }
        if ((n & 2) != 0) {
            string2 = rumScopeKey.url;
        }
        if ((n & 4) != 0) {
            string3 = rumScopeKey.name;
        }
        return rumScopeKey.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "RumScopeKey(id=" + this.id + ", url=" + this.url + ", name=" + this.name + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.url.hashCode();
        result = result * 31 + this.name.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RumScopeKey)) {
            return false;
        }
        RumScopeKey rumScopeKey = (RumScopeKey)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)rumScopeKey.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.url, (Object)rumScopeKey.url)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)rumScopeKey.name);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0001H\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001H\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumScopeKey$Companion;", "", "()V", "from", "Lcom/datadog/android/rum/internal/domain/scope/RumScopeKey;", "key", "name", "", "resolveComponent", "Landroid/content/ComponentName;", "resolveComponentUrl", "resolveId", "resolveName", "resolveUrl", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RumScopeKey from(@NotNull Object key, @Nullable String name) {
            RumScopeKey rumScopeKey;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            ComponentName componentName = this.resolveComponent(key);
            if (componentName == null) {
                String id = this.resolveId(key);
                String url = this.resolveUrl(key);
                String string = name;
                if (string == null) {
                    string = this.resolveName(key);
                }
                String resolvedName = string;
                rumScopeKey = new RumScopeKey(id, url, resolvedName);
            } else {
                String id = componentName.getClassName() + "@" + System.identityHashCode(key);
                String url = this.resolveComponentUrl(componentName);
                String string = name;
                if (string == null) {
                    String string2 = componentName.getClassName();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"componentName.className");
                }
                String resolvedName = string;
                rumScopeKey = new RumScopeKey(id, url, resolvedName);
            }
            return rumScopeKey;
        }

        public static /* synthetic */ RumScopeKey from$default(Companion companion, Object object, String string, int n, Object object2) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.from(object, string);
        }

        private final String resolveId(Object key) {
            Object object = key;
            return object instanceof String ? (String)key : (object instanceof Number ? key.toString() : (object instanceof Enum ? key.getClass().getName() + "@" + ((Enum)key).name() : (object instanceof DialogFragmentNavigator.Destination ? ((DialogFragmentNavigator.Destination)key).getClassName() + "#" + ((DialogFragmentNavigator.Destination)key).getId() : (object instanceof FragmentNavigator.Destination ? ((FragmentNavigator.Destination)key).getClassName() + "#" + ((FragmentNavigator.Destination)key).getId() : key.toString()))));
        }

        private final String resolveUrl(Object key) {
            Object object;
            Object object2 = key;
            if (object2 instanceof String) {
                object = (String)key;
            } else if (object2 instanceof Number) {
                object = key.toString();
            } else if (object2 instanceof Enum) {
                object = key.getClass().getName() + "." + ((Enum)key).name();
            } else if (object2 instanceof DialogFragmentNavigator.Destination) {
                String string = ((DialogFragmentNavigator.Destination)key).getClassName();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.className");
            } else if (object2 instanceof FragmentNavigator.Destination) {
                String string = ((FragmentNavigator.Destination)key).getClassName();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.className");
            } else {
                String string = key.getClass().getCanonicalName();
                if (string == null) {
                    string = key.getClass().getSimpleName();
                }
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.javaClass.canonicalN\u2026 key.javaClass.simpleName");
            }
            return object;
        }

        private final String resolveName(Object key) {
            String string;
            Object object = key;
            if (object instanceof String) {
                string = (String)key;
            } else if (object instanceof Number) {
                string = key.toString();
            } else if (object instanceof Enum) {
                string = ((Enum)key).name();
            } else if (object instanceof DialogFragmentNavigator.Destination) {
                String string2 = ((DialogFragmentNavigator.Destination)key).getClassName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"key.className");
            } else if (object instanceof FragmentNavigator.Destination) {
                String string3 = ((FragmentNavigator.Destination)key).getClassName();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"key.className");
            } else {
                String string4 = key.getClass().getName();
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"key.javaClass.name");
            }
            return string;
        }

        private final String resolveComponentUrl(ComponentName key) {
            Object object;
            String string = key.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.packageName");
            if (((CharSequence)string).length() == 0) {
                String string2 = key.getClassName();
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"key.className");
            } else {
                String string3 = key.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"key.className");
                if (StringsKt.startsWith$default((String)string3, (String)(key.getPackageName() + "."), (boolean)false, (int)2, null)) {
                    String string4 = key.getClassName();
                    object = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"key.className");
                } else {
                    String string5 = key.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"key.className");
                    if (StringsKt.contains$default((CharSequence)string5, (char)'.', (boolean)false, (int)2, null)) {
                        String string6 = key.getClassName();
                        object = string6;
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"key.className");
                    } else {
                        object = key.getPackageName() + "." + key.getClassName();
                    }
                }
            }
            return object;
        }

        private final ComponentName resolveComponent(Object key) {
            Object object = key;
            return object instanceof Activity ? ((Activity)key).getComponentName() : (object instanceof ActivityNavigator.Destination ? ((ActivityNavigator.Destination)key).getComponent() : null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

