/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.event;

import com.datadog.android.api.InternalLogger;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0001\u000b\u00a8\u0006\f"}, d2={"Lcom/datadog/android/rum/internal/domain/event/RumEventMeta;", "", "()V", "type", "", "getType", "()Ljava/lang/String;", "toJson", "Lcom/google/gson/JsonObject;", "Companion", "View", "Lcom/datadog/android/rum/internal/domain/event/RumEventMeta$View;", "dd-sdk-android-rum_release"})
public abstract class RumEventMeta {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String UNKNOWN_RUM_EVENT_META_TYPE_ERROR = "Unknown RUM event meta type value [%s]";
    @NotNull
    private static final String UNABLE_TO_PARSE_JSON_INTO_META = "Unable to parse json into RUM event meta";
    @NotNull
    public static final String TYPE_KEY = "type";
    @NotNull
    public static final String VIEW_TYPE_VALUE = "view";
    @NotNull
    public static final String VIEW_ID_KEY = "viewId";
    @NotNull
    public static final String DOCUMENT_VERSION_KEY = "documentVersion";

    private RumEventMeta() {
    }

    @NotNull
    public abstract String getType();

    @NotNull
    public JsonObject toJson() {
        JsonObject model = new JsonObject();
        model.addProperty(TYPE_KEY, this.getType());
        return model;
    }

    public /* synthetic */ RumEventMeta(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/rum/internal/domain/event/RumEventMeta$Companion;", "", "()V", "DOCUMENT_VERSION_KEY", "", "TYPE_KEY", "UNABLE_TO_PARSE_JSON_INTO_META", "UNKNOWN_RUM_EVENT_META_TYPE_ERROR", "VIEW_ID_KEY", "VIEW_TYPE_VALUE", "fromJson", "Lcom/datadog/android/rum/internal/domain/event/RumEventMeta;", "jsonString", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final RumEventMeta fromJson(@NotNull String jsonString, @NotNull InternalLogger internalLogger) throws JsonParseException {
            RumEventMeta rumEventMeta;
            Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
            Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
            try {
                View view;
                JsonObject model = JsonParser.parseString((String)jsonString).getAsJsonObject();
                String type = model.get(RumEventMeta.TYPE_KEY).getAsString();
                if (Intrinsics.areEqual((Object)type, (Object)RumEventMeta.VIEW_TYPE_VALUE)) {
                    String viewId = model.get(RumEventMeta.VIEW_ID_KEY).getAsString();
                    long docVersion = model.get(RumEventMeta.DOCUMENT_VERSION_KEY).getAsLong();
                    Intrinsics.checkNotNullExpressionValue((Object)viewId, (String)RumEventMeta.VIEW_ID_KEY);
                    view = new View(viewId, docVersion);
                } else {
                    InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(type){
                        final /* synthetic */ String $type;
                        {
                            this.$type = $type;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            String string = "Unknown RUM event meta type value [%s]";
                            Locale locale = Locale.US;
                            Object[] objectArray = new Object[]{this.$type};
                            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                            return string2;
                        }
                    }), null, (boolean)false, null, (int)56, null);
                    view = null;
                }
                rumEventMeta = view;
            }
            catch (NullPointerException e) {
                throw new JsonParseException(RumEventMeta.UNABLE_TO_PARSE_JSON_INTO_META, (Throwable)e);
            }
            catch (ClassCastException e) {
                throw new JsonParseException(RumEventMeta.UNABLE_TO_PARSE_JSON_INTO_META, (Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new JsonParseException(RumEventMeta.UNABLE_TO_PARSE_JSON_INTO_META, (Throwable)e);
            }
            catch (NumberFormatException e) {
                throw new JsonParseException(RumEventMeta.UNABLE_TO_PARSE_JSON_INTO_META, (Throwable)e);
            }
            return rumEventMeta;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/rum/internal/domain/event/RumEventMeta$View;", "Lcom/datadog/android/rum/internal/domain/event/RumEventMeta;", "viewId", "", "documentVersion", "", "(Ljava/lang/String;J)V", "getDocumentVersion", "()J", "type", "getType", "()Ljava/lang/String;", "getViewId", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toJson", "Lcom/google/gson/JsonObject;", "toString", "dd-sdk-android-rum_release"})
    public static final class View
    extends RumEventMeta {
        @NotNull
        private final String viewId;
        private final long documentVersion;
        @NotNull
        private final String type;

        public View(@NotNull String viewId, long documentVersion) {
            Intrinsics.checkNotNullParameter((Object)viewId, (String)RumEventMeta.VIEW_ID_KEY);
            super(null);
            this.viewId = viewId;
            this.documentVersion = documentVersion;
            this.type = RumEventMeta.VIEW_TYPE_VALUE;
        }

        @NotNull
        public final String getViewId() {
            return this.viewId;
        }

        public final long getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        @NotNull
        public String getType() {
            return this.type;
        }

        @Override
        @NotNull
        public JsonObject toJson() {
            JsonObject model = super.toJson();
            model.addProperty(RumEventMeta.VIEW_ID_KEY, this.viewId);
            model.addProperty(RumEventMeta.DOCUMENT_VERSION_KEY, (Number)this.documentVersion);
            return model;
        }

        @NotNull
        public final String component1() {
            return this.viewId;
        }

        public final long component2() {
            return this.documentVersion;
        }

        @NotNull
        public final View copy(@NotNull String viewId, long documentVersion) {
            Intrinsics.checkNotNullParameter((Object)viewId, (String)RumEventMeta.VIEW_ID_KEY);
            return new View(viewId, documentVersion);
        }

        public static /* synthetic */ View copy$default(View view, String string, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = view.viewId;
            }
            if ((n & 2) != 0) {
                l = view.documentVersion;
            }
            return view.copy(string, l);
        }

        @NotNull
        public String toString() {
            return "View(viewId=" + this.viewId + ", documentVersion=" + this.documentVersion + ")";
        }

        public int hashCode() {
            int result = this.viewId.hashCode();
            result = result * 31 + Long.hashCode(this.documentVersion);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof View)) {
                return false;
            }
            View view = (View)other;
            if (!Intrinsics.areEqual((Object)this.viewId, (Object)view.viewId)) {
                return false;
            }
            return this.documentVersion == view.documentVersion;
        }
    }
}

