/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.anr;

import android.os.Handler;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.core.feature.event.ThreadDump;
import com.datadog.android.core.internal.utils.ThreadExtKt;
import com.datadog.android.internal.utils.ThrowableExtKt;
import com.datadog.android.rum.GlobalRumMonitor;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.internal.anr.ANRDetectorRunnable;
import com.datadog.android.rum.internal.anr.ANRException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000fH\u0002J\u0006\u0010\u0013\u001a\u00020\rR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/rum/internal/anr/ANRDetectorRunnable;", "Ljava/lang/Runnable;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "handler", "Landroid/os/Handler;", "anrThresholdMs", "", "anrTestDelayMs", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Landroid/os/Handler;JJ)V", "shouldStop", "", "run", "", "safeGetAllStacktraces", "", "Ljava/lang/Thread;", "", "Ljava/lang/StackTraceElement;", "stop", "CallbackRunnable", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nANRDetectorRunnable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ANRDetectorRunnable.kt\ncom/datadog/android/rum/internal/anr/ANRDetectorRunnable\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,138:1\n478#2,7:139\n494#2,7:146\n125#3:153\n152#3,3:154\n*S KotlinDebug\n*F\n+ 1 ANRDetectorRunnable.kt\ncom/datadog/android/rum/internal/anr/ANRDetectorRunnable\n*L\n62#1:139,7\n63#1:146,7\n64#1:153\n64#1:154,3\n*E\n"})
public final class ANRDetectorRunnable
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final Handler handler;
    private final long anrThresholdMs;
    private final long anrTestDelayMs;
    private boolean shouldStop;
    private static final long ANR_THRESHOLD_MS = 5000L;
    private static final long ANR_TEST_DELAY_MS = 500L;
    @NotNull
    public static final String ANR_MESSAGE = "Application Not Responding";

    public ANRDetectorRunnable(@NotNull FeatureSdkCore sdkCore, @NotNull Handler handler, long anrThresholdMs, long anrTestDelayMs) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.sdkCore = sdkCore;
        this.handler = handler;
        this.anrThresholdMs = anrThresholdMs;
        this.anrTestDelayMs = anrTestDelayMs;
    }

    public /* synthetic */ ANRDetectorRunnable(FeatureSdkCore featureSdkCore, Handler handler, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = 5000L;
        }
        if ((n & 8) != 0) {
            l2 = 500L;
        }
        this(featureSdkCore, handler, l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        while (!Thread.interrupted()) {
            if (this.shouldStop) {
                return;
            }
            try {
                CallbackRunnable callback;
                CallbackRunnable callbackRunnable = callback = new CallbackRunnable();
                synchronized (callbackRunnable) {
                    boolean bl = false;
                    if (!this.handler.post((Runnable)callback)) {
                        return;
                    }
                    callback.wait(this.anrThresholdMs);
                    if (!callback.wasCalled()) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Map $this$filterValues$iv;
                        StackTraceElement[] it;
                        Map $this$filterKeys$iv;
                        Thread anrThread;
                        Intrinsics.checkNotNullExpressionValue((Object)this.handler.getLooper().getThread(), (String)"handler.looper.thread");
                        ANRException anrException = new ANRException(anrThread);
                        Object object = new ThreadDump[1];
                        String string = anrThread.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"anrThread.name");
                        Thread.State state = anrThread.getState();
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)state), (String)"anrThread.state");
                        object[0] = new ThreadDump(string, ThreadExtKt.asString((Thread.State)state), ThrowableExtKt.loggableStackTrace((Throwable)anrException), false);
                        Collection collection = CollectionsKt.mutableListOf((Object[])object);
                        object = this.safeGetAllStacktraces();
                        Collection collection2 = collection;
                        boolean $i$f$filterKeys = false;
                        LinkedHashMap result$iv = new LinkedHashMap();
                        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                            it = (StackTraceElement[])entry$iv.getKey();
                            boolean bl2 = false;
                            if (!(!Intrinsics.areEqual((Object)it, (Object)anrThread))) continue;
                            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                        }
                        $this$filterKeys$iv = result$iv;
                        boolean $i$f$filterValues = false;
                        result$iv = new LinkedHashMap();
                        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                            it = (StackTraceElement[])entry$iv.getValue();
                            boolean bl3 = false;
                            boolean bl4 = !(it.length == 0);
                            if (!bl4) continue;
                            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                        }
                        $this$filterValues$iv = result$iv;
                        boolean $i$f$map = false;
                        result$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                        boolean $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void it2;
                            Map.Entry item$iv$iv;
                            Map.Entry entry = item$iv$iv = iterator.next();
                            Collection collection3 = destination$iv$iv;
                            boolean bl5 = false;
                            Thread thread = (Thread)it2.getKey();
                            String string2 = thread.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"thread.name");
                            Thread.State state2 = thread.getState();
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)state2), (String)"thread.state");
                            String string3 = ThreadExtKt.asString((Thread.State)state2);
                            StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
                            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"thread.stackTrace");
                            collection3.add(new ThreadDump(string2, string3, ThreadExtKt.loggableStackTrace((StackTraceElement[])stackTraceElementArray), false));
                        }
                        List allThreads = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
                        GlobalRumMonitor.get((SdkCore)this.sdkCore).addError(ANR_MESSAGE, RumErrorSource.SOURCE, anrException, MapsKt.mapOf((Pair)TuplesKt.to((Object)"_dd.error.threads", (Object)allThreads)));
                        callback.wait();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                if (this.anrTestDelayMs <= 0L) continue;
                Thread.sleep(this.anrTestDelayMs);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public final void stop() {
        this.shouldStop = true;
    }

    private final Map<Thread, StackTraceElement[]> safeGetAllStacktraces() {
        Map map;
        try {
            Map map2 = Thread.getAllStackTraces();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"{\n            Thread.getAllStackTraces()\n        }");
            map = map2;
        }
        catch (SecurityException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)safeGetAllStacktraces.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/datadog/android/rum/internal/anr/ANRDetectorRunnable$CallbackRunnable;", "Ljava/lang/Object;", "Ljava/lang/Runnable;", "()V", "called", "", "run", "", "wasCalled", "dd-sdk-android-rum_release"})
    public static final class CallbackRunnable
    implements Runnable {
        private boolean called;

        @Override
        public synchronized void run() {
            this.called = true;
            this.notifyAll();
        }

        public final boolean wasCalled() {
            return this.called;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/rum/internal/anr/ANRDetectorRunnable$Companion;", "", "()V", "ANR_MESSAGE", "", "ANR_TEST_DELAY_MS", "", "ANR_THRESHOLD_MS", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

