/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum;

import android.content.Intent;
import android.os.Bundle;
import com.datadog.android.event.EventMapper;
import com.datadog.android.lint.InternalApi;
import com.datadog.android.rum.RumConfiguration;
import com.datadog.android.rum.RumPerformanceMetric;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.telemetry.model.TelemetryConfigurationEvent;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\fJ\u0015\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0016\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/datadog/android/rum/_RumInternalProxy;", "", "rumMonitor", "Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;", "(Lcom/datadog/android/rum/internal/monitor/AdvancedRumMonitor;)V", "handledSyntheticsAttribute", "", "addLongTask", "", "durationNs", "", "target", "", "setSyntheticsAttribute", "testId", "resultId", "setSyntheticsAttributeFromIntent", "intent", "Landroid/content/Intent;", "setSyntheticsAttributeFromIntent$dd_sdk_android_rum_release", "updatePerformanceMetric", "metric", "Lcom/datadog/android/rum/RumPerformanceMetric;", "value", "", "Companion", "dd-sdk-android-rum_release"})
@InternalApi
public final class _RumInternalProxy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AdvancedRumMonitor rumMonitor;
    private volatile boolean handledSyntheticsAttribute;

    public _RumInternalProxy(@NotNull AdvancedRumMonitor rumMonitor2) {
        Intrinsics.checkNotNullParameter((Object)rumMonitor2, (String)"rumMonitor");
        this.rumMonitor = rumMonitor2;
    }

    public final void addLongTask(long durationNs, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.rumMonitor.addLongTask(durationNs, target);
    }

    public final void updatePerformanceMetric(@NotNull RumPerformanceMetric metric, double value) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        this.rumMonitor.updatePerformanceMetric(metric, value);
    }

    public final void setSyntheticsAttribute(@Nullable String testId, @Nullable String resultId) {
        if (this.handledSyntheticsAttribute) {
            return;
        }
        this.handledSyntheticsAttribute = true;
        CharSequence charSequence = testId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)resultId) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        this.rumMonitor.setSyntheticsAttribute(testId, resultId);
    }

    public final void setSyntheticsAttributeFromIntent$dd_sdk_android_rum_release(@NotNull Intent intent) {
        Bundle extras;
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            bundle = intent.getExtras();
        }
        catch (Exception exception) {
            bundle = null;
        }
        Bundle bundle2 = extras = bundle;
        String testId = bundle2 != null ? bundle2.getString("_dd.synthetics.test_id") : null;
        Bundle bundle3 = extras;
        String resultId = bundle3 != null ? bundle3.getString("_dd.synthetics.result_id") : null;
        this.setSyntheticsAttribute(testId, resultId);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007J\u001c\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\r"}, d2={"Lcom/datadog/android/rum/_RumInternalProxy$Companion;", "", "()V", "setAdditionalConfiguration", "Lcom/datadog/android/rum/RumConfiguration$Builder;", "builder", "additionalConfig", "", "", "setTelemetryConfigurationEventMapper", "eventMapper", "Lcom/datadog/android/event/EventMapper;", "Lcom/datadog/android/telemetry/model/TelemetryConfigurationEvent;", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RumConfiguration.Builder setTelemetryConfigurationEventMapper(@NotNull RumConfiguration.Builder builder, @NotNull EventMapper<TelemetryConfigurationEvent> eventMapper) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter(eventMapper, (String)"eventMapper");
            return builder.setTelemetryConfigurationEventMapper$dd_sdk_android_rum_release(eventMapper);
        }

        @NotNull
        public final RumConfiguration.Builder setAdditionalConfiguration(@NotNull RumConfiguration.Builder builder, @NotNull Map<String, ? extends Object> additionalConfig) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter(additionalConfig, (String)"additionalConfig");
            return builder.setAdditionalConfiguration$dd_sdk_android_rum_release(additionalConfig);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

