/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.morpheus.db;

import com.d3x.morpheus.array.Array;
import com.d3x.morpheus.array.ArrayBuilder;
import com.d3x.morpheus.array.ArrayType;
import com.d3x.morpheus.db.DbSourceOptions;
import com.d3x.morpheus.frame.DataFrame;
import com.d3x.morpheus.frame.DataFrameException;
import com.d3x.morpheus.index.Index;
import com.d3x.morpheus.util.sql.SQL;
import com.d3x.morpheus.util.sql.SQLExtractor;
import com.d3x.morpheus.util.sql.SQLPlatform;
import com.d3x.morpheus.util.sql.SQLType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class DbSource {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> DataFrame<R, String> read(Consumer<DbSourceOptions<R>> configurator) throws DataFrameException {
        DbSourceOptions options = new DbSourceOptions();
        configurator.accept(options);
        try (Connection conn = options.getConnection();){
            conn.setAutoCommit(options.isAutoCommit());
            conn.setReadOnly(options.isReadOnly());
            int fetchSize = options.getFetchSize().orElse(1000);
            SQL sql = SQL.of((String)options.getSql(), (Object[])options.getParameters().orElse(new Object[0]));
            DataFrame dataFrame = (DataFrame)sql.executeQuery(conn, fetchSize, rs -> this.read((ResultSet)rs, options));
            return dataFrame;
        }
        catch (Exception ex) {
            throw new DataFrameException("Failed to create DataFrame from database request: " + options, (Throwable)ex);
        }
    }

    private <R> DataFrame<R, String> read(ResultSet resultSet, DbSourceOptions<R> request) throws DataFrameException {
        try {
            int rowCapacity = request.getRowCapacity();
            SQLPlatform platform = this.getPlatform(resultSet);
            ResultSetMetaData metaData = resultSet.getMetaData();
            List<ColumnInfo> columnList = this.getColumnInfo(metaData, platform, request);
            Function<ResultSet, R> rowKeyFunction = request.getRowKeyFunction();
            if (!resultSet.next()) {
                Index rowKeys = Index.empty();
                DataFrame<R, String> dataFrame = this.createFrame((Iterable<R>)rowKeys, columnList);
                return dataFrame;
            }
            R rowKey = rowKeyFunction.apply(resultSet);
            Class<?> rowKeyType = rowKey.getClass();
            ArrayBuilder rowKeyBuilder = ArrayBuilder.of((int)rowCapacity, rowKeyType);
            do {
                rowKey = rowKeyFunction.apply(resultSet);
                rowKeyBuilder.add(rowKey);
                for (ColumnInfo colInfo : columnList) {
                    colInfo.apply(resultSet);
                }
            } while (resultSet.next());
            Array rowKeys = rowKeyBuilder.toArray();
            DataFrame<R, String> dataFrame = this.createFrame((Iterable<R>)rowKeys, columnList);
            return dataFrame;
        }
        catch (DataFrameException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new DataFrameException("Failed to initialize DataFrame from ResultSet: " + t.getMessage(), t);
        }
        finally {
            this.close(resultSet);
        }
    }

    private SQLPlatform getPlatform(ResultSet resultSet) {
        try {
            DatabaseMetaData metaData = resultSet.getStatement().getConnection().getMetaData();
            String driverClassName = metaData.getDriverName();
            return SQLPlatform.getPlatform((String)driverClassName);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to detect database platform type, please use withPlatform() on request", ex);
        }
    }

    private <R> DataFrame<R, String> createFrame(Iterable<R> rowKeys, List<ColumnInfo> columnList) {
        return DataFrame.of(rowKeys, String.class, columns -> {
            for (ColumnInfo colInfo : columnList) {
                String colName = colInfo.name;
                Array values = colInfo.array.toArray();
                columns.add((Object)colName, (Iterable)values);
            }
        });
    }

    private <R> List<ColumnInfo> getColumnInfo(ResultSetMetaData metaData, SQLPlatform platform, DbSourceOptions<R> request) throws SQLException {
        int rowCapacity = request.getRowCapacity();
        int columnCount = metaData.getColumnCount();
        ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>(columnCount);
        SQLType.TypeResolver typeResolver = SQLType.getTypeResolver((SQLPlatform)platform);
        for (int i = 0; i < columnCount; ++i) {
            int colIndex = i + 1;
            String colName = metaData.getColumnName(colIndex);
            if (request.getExcludeColumnSet().contains(colName)) continue;
            int typeCode = metaData.getColumnType(colIndex);
            String typeName = metaData.getColumnTypeName(colIndex);
            SQLType sqlType = typeResolver.getType(typeCode, typeName);
            SQLExtractor extractor = request.getExtractors().getOrDefault(colName, SQLExtractor.with((Class)sqlType.typeClass(), (SQLPlatform)platform));
            columnInfoList.add(new ColumnInfo(i, colIndex, colName, rowCapacity, extractor));
        }
        return columnInfoList;
    }

    private void close(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class ColumnInfo {
        int index;
        int ordinal;
        String name;
        Class<?> type;
        ArrayType typeCode;
        SQLExtractor extractor;
        ArrayBuilder<Object> array;

        ColumnInfo(int ordinal, int index, String name, int capacity, SQLExtractor extractor) {
            this.index = index;
            this.ordinal = ordinal;
            this.name = name;
            this.type = extractor.getDataType();
            this.typeCode = ArrayType.of(this.type);
            this.array = ArrayBuilder.of((int)capacity, this.type);
            this.extractor = extractor;
        }

        final void apply(ResultSet rs) {
            try {
                switch (this.typeCode) {
                    case BOOLEAN: {
                        this.array.addBoolean(this.extractor.getBoolean(rs, this.index));
                        break;
                    }
                    case INTEGER: {
                        this.array.addInt(this.extractor.getInt(rs, this.index));
                        break;
                    }
                    case LONG: {
                        this.array.addLong(this.extractor.getLong(rs, this.index));
                        break;
                    }
                    case DOUBLE: {
                        this.array.addDouble(this.extractor.getDouble(rs, this.index));
                        break;
                    }
                    default: {
                        this.array.add(this.extractor.getValue(rs, this.index));
                        break;
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to extract data for column " + this.name, ex);
            }
        }
    }
}

