/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.morpheus.db;

import com.d3x.morpheus.frame.DataFrameException;
import com.d3x.morpheus.frame.DataFrameValue;
import com.d3x.morpheus.util.Asserts;
import com.d3x.morpheus.util.functions.Function1;
import com.d3x.morpheus.util.sql.SQLPlatform;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.sql.DataSource;

public class DbSinkOptions<R, C> {
    private int batchSize = 1000;
    private String tableName;
    private Connection connection;
    private SQLPlatform platform;
    private ColumnMappings columnMappings;
    private String autoIncrementColumnName;
    private Function<C, String> columnNames = Object::toString;
    private String rowKeyColumn;
    private Class<?> rowKeySqlClass;
    private Function1<R, ?> rowKeyMapper;

    public DbSinkOptions() {
        this.columnMappings = new ColumnMappings();
    }

    int getBatchSize() {
        return this.batchSize;
    }

    String getTableName() {
        return this.tableName;
    }

    Optional<SQLPlatform> getPlatform() {
        return Optional.ofNullable(this.platform);
    }

    Connection getConnection() {
        return this.connection;
    }

    Optional<String> getRowKeyColumn() {
        return Optional.ofNullable(this.rowKeyColumn);
    }

    Optional<Class<?>> getRowKeySqlClass() {
        return Optional.ofNullable(this.rowKeySqlClass);
    }

    Optional<Function1<R, ?>> getRowKeyMapper() {
        return Optional.ofNullable(this.rowKeyMapper);
    }

    Optional<String> getAutoIncrementColumnName() {
        return Optional.ofNullable(this.autoIncrementColumnName);
    }

    public ColumnMappings getColumnMappings() {
        return this.columnMappings;
    }

    Function<C, String> getColumnNames() {
        return this.columnNames;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setConnection(Connection connection) {
        Objects.requireNonNull(connection, "The SQL connection cannot be null");
        this.connection = connection;
    }

    public void setConnection(DataSource dataSource) {
        Objects.requireNonNull(dataSource, "The SQL data source cannot be null");
        try {
            this.connection = dataSource.getConnection();
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to access a DB connection from DataSource", ex);
        }
    }

    public void setConnection(String url, String username, String password) {
        try {
            Objects.requireNonNull(url, "The JDBC URL cannnot be null");
            this.connection = DriverManager.getConnection(url, username, password);
        }
        catch (SQLException ex) {
            throw new DataFrameException("Failed to create connection for URL:" + url, (Throwable)ex);
        }
    }

    public <T> void setRowKeyMapping(String colName, Class<T> sqlType, Function1<R, T> mapper) {
        this.rowKeyColumn = (String)Asserts.notNull((Object)colName, (String)"The row key column name cannot be null");
        this.rowKeySqlClass = (Class)Asserts.notNull(sqlType, (String)"The row key SQL type cannot be null");
        this.rowKeyMapper = (Function1)Asserts.notNull(mapper, (String)"The row key mapper cannot be null");
    }

    public void setAutoIncrementColumnName(String autoIncrementColumnName) {
        this.autoIncrementColumnName = autoIncrementColumnName;
    }

    public void setPlatform(SQLPlatform platform) {
        this.platform = platform;
    }

    public void setColumnNames(Function<C, String> columnNames) {
        this.columnNames = columnNames;
    }

    public void setColumnMappings(Consumer<ColumnMappings> configurator) {
        configurator.accept(this.columnMappings);
    }

    public class ColumnMappings {
        private Map<Class<?>, Class<?>> sqlTypeMap = new HashMap();
        private Map<Class<?>, Function1<DataFrameValue<R, C>, ?>> mapperMap = new HashMap();

        ColumnMappings() {
            this.add(Boolean.class, Boolean.class, Function1.toBoolean(DataFrameValue::getBoolean));
            this.add(Integer.class, Integer.class, Function1.toInt(DataFrameValue::getInt));
            this.add(Long.class, Long.class, Function1.toLong(DataFrameValue::getLong));
            this.add(Double.class, Double.class, Function1.toDouble(DataFrameValue::getDouble));
            this.add(String.class, String.class, Function1.toValue(DataFrameValue::getValue));
            this.add(Date.class, Date.class, Function1.toValue(DataFrameValue::getValue));
            this.add(Time.class, Time.class, Function1.toValue(DataFrameValue::getValue));
            this.add(Timestamp.class, Timestamp.class, Function1.toValue(DataFrameValue::getValue));
            this.add(java.util.Date.class, Date.class, Function1.toValue(v -> new Date(((java.util.Date)v.getValue()).getTime())));
            this.add(LocalTime.class, Time.class, Function1.toValue(v -> Time.valueOf((LocalTime)v.getValue())));
            this.add(LocalDate.class, Date.class, Function1.toValue(v -> Date.valueOf((LocalDate)v.getValue())));
            this.add(LocalDateTime.class, Timestamp.class, Function1.toValue(v -> Timestamp.valueOf((LocalDateTime)v.getValue())));
            this.add(ZonedDateTime.class, Timestamp.class, Function1.toValue(v -> Timestamp.valueOf(((ZonedDateTime)v.getValue()).toLocalDateTime())));
        }

        Class<?> getSqlType(Class<?> dataType) throws DataFrameException {
            Class<?> sqlType = this.sqlTypeMap.get(dataType);
            if (sqlType != null) {
                return sqlType;
            }
            if (dataType.isEnum()) {
                return String.class;
            }
            throw new DataFrameException("No SQL type mapped for data type: " + dataType.getSimpleName());
        }

        Function1<DataFrameValue<R, C>, ?> getMapper(Class<?> dataType) {
            Function1 mapper = this.mapperMap.get(dataType);
            if (mapper != null) {
                return mapper;
            }
            if (dataType.isEnum()) {
                return Function1.toValue(v -> ((Enum)v).name());
            }
            throw new DataFrameException("No SQL mapper function for data type: " + dataType.getSimpleName());
        }

        public <A, B> void add(Class<A> dataClass, Class<B> sqlClass, Function1<DataFrameValue<R, C>, B> mapper) {
            Asserts.notNull(dataClass, (String)"The data type cannot be null");
            Asserts.notNull(sqlClass, (String)"The sql type cannot be null");
            Asserts.notNull(mapper, (String)"The sql mapper function cannot be nul");
            this.sqlTypeMap.put(dataClass, sqlClass);
            this.mapperMap.put(dataClass, mapper);
        }
    }
}

