/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.jsonskiff;

import com.couchbase.jsonskiff.Buffer;
import com.couchbase.jsonskiff.StreamWindow;
import java.nio.charset.StandardCharsets;

class CopyingStreamWindow
implements StreamWindow {
    private final Buffer window = new Buffer();
    private long streamOffset;

    CopyingStreamWindow() {
    }

    @Override
    public void add(byte[] bytes, int offset, int len) {
        this.window.writeBytes(bytes, offset, len);
        this.streamOffset += (long)len;
    }

    @Override
    public void releaseBefore(long releaseStreamOffset) {
        if (releaseStreamOffset <= 0L) {
            return;
        }
        int localOffset = this.toLocalOffset(releaseStreamOffset);
        this.window.skipBytes(localOffset);
        this.window.discardSomeReadBytes();
    }

    @Override
    public byte[] getBytes(long startStreamOffset, long endStreamOffset) {
        int localStartOffset = this.toLocalOffset(startStreamOffset);
        int localEndOffset = this.toLocalOffset(endStreamOffset);
        byte[] result = new byte[localEndOffset - localStartOffset];
        this.window.getBytes(this.window.readerIndex() + localStartOffset, result);
        return result;
    }

    private int toLocalOffset(long streamOffset) {
        return (int)(streamOffset - this.streamOffset + (long)this.window.readableBytes());
    }

    public String toString() {
        return "CopyingStreamWindow{window=" + this.window + ", streamOffset=" + this.streamOffset + ", windowContents='" + this.window.toString(StandardCharsets.UTF_8) + "'" + '}';
    }
}

