// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The properties of the benefit recommendation when scope is 'Shared'. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "scope")
@JsonTypeName("Shared")
@Fluent
public final class SharedScopeBenefitRecommendationProperties extends BenefitRecommendationProperties {
    /** Creates an instance of SharedScopeBenefitRecommendationProperties class. */
    public SharedScopeBenefitRecommendationProperties() {
    }

    /** {@inheritDoc} */
    @Override
    public SharedScopeBenefitRecommendationProperties withLookBackPeriod(LookBackPeriod lookBackPeriod) {
        super.withLookBackPeriod(lookBackPeriod);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public SharedScopeBenefitRecommendationProperties withUsage(RecommendationUsageDetails usage) {
        super.withUsage(usage);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public SharedScopeBenefitRecommendationProperties withTerm(Term term) {
        super.withTerm(term);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public SharedScopeBenefitRecommendationProperties withCommitmentGranularity(Grain commitmentGranularity) {
        super.withCommitmentGranularity(commitmentGranularity);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public SharedScopeBenefitRecommendationProperties withRecommendationDetails(
        AllSavingsBenefitDetails recommendationDetails) {
        super.withRecommendationDetails(recommendationDetails);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
