// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.List;

/**
 * On-demand charges between firstConsumptionDate and lastConsumptionDate that were used for computing benefit
 * recommendations.
 */
@Fluent
public final class RecommendationUsageDetails {
    /*
     * The grain of the usage. Supported values: 'Hourly'
     */
    @JsonProperty(value = "usageGrain")
    private Grain usageGrain;

    /*
     * On-demand charges for each hour between firstConsumptionDate and lastConsumptionDate that were used for
     * computing benefit recommendations.
     */
    @JsonProperty(value = "charges", access = JsonProperty.Access.WRITE_ONLY)
    private List<BigDecimal> charges;

    /** Creates an instance of RecommendationUsageDetails class. */
    public RecommendationUsageDetails() {
    }

    /**
     * Get the usageGrain property: The grain of the usage. Supported values: 'Hourly'.
     *
     * @return the usageGrain value.
     */
    public Grain usageGrain() {
        return this.usageGrain;
    }

    /**
     * Set the usageGrain property: The grain of the usage. Supported values: 'Hourly'.
     *
     * @param usageGrain the usageGrain value to set.
     * @return the RecommendationUsageDetails object itself.
     */
    public RecommendationUsageDetails withUsageGrain(Grain usageGrain) {
        this.usageGrain = usageGrain;
        return this;
    }

    /**
     * Get the charges property: On-demand charges for each hour between firstConsumptionDate and lastConsumptionDate
     * that were used for computing benefit recommendations.
     *
     * @return the charges value.
     */
    public List<BigDecimal> charges() {
        return this.charges;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
