// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Each pivot must contain a 'type' and 'name'. */
@Fluent
public final class PivotProperties {
    /*
     * Data type to show in view.
     */
    @JsonProperty(value = "type")
    private PivotType type;

    /*
     * Data field to show in view.
     */
    @JsonProperty(value = "name")
    private String name;

    /** Creates an instance of PivotProperties class. */
    public PivotProperties() {
    }

    /**
     * Get the type property: Data type to show in view.
     *
     * @return the type value.
     */
    public PivotType type() {
        return this.type;
    }

    /**
     * Set the type property: Data type to show in view.
     *
     * @param type the type value to set.
     * @return the PivotProperties object itself.
     */
    public PivotProperties withType(PivotType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the name property: Data field to show in view.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Data field to show in view.
     *
     * @param name the name value to set.
     * @return the PivotProperties object itself.
     */
    public PivotProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
