// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.util.Context;

/** Resource collection API of GenerateReservationDetailsReports. */
public interface GenerateReservationDetailsReports {
    /**
     * Generates the reservations details report for provided date range asynchronously based on enrollment id. The
     * Reservation usage details can be viewed only by certain enterprise roles. For more details on the roles see,
     * https://docs.microsoft.com/azure/cost-management-billing/manage/understand-ea-roles#usage-and-costs-access-by-role.
     *
     * @param billingAccountId Enrollment ID (Legacy BillingAccount ID).
     * @param startDate Start Date.
     * @param endDate End Date.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the long running operation.
     */
    OperationStatus byBillingAccountId(String billingAccountId, String startDate, String endDate);

    /**
     * Generates the reservations details report for provided date range asynchronously based on enrollment id. The
     * Reservation usage details can be viewed only by certain enterprise roles. For more details on the roles see,
     * https://docs.microsoft.com/azure/cost-management-billing/manage/understand-ea-roles#usage-and-costs-access-by-role.
     *
     * @param billingAccountId Enrollment ID (Legacy BillingAccount ID).
     * @param startDate Start Date.
     * @param endDate End Date.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the long running operation.
     */
    OperationStatus byBillingAccountId(String billingAccountId, String startDate, String endDate, Context context);

    /**
     * Generates the reservations details report for provided date range asynchronously by billing profile. The
     * Reservation usage details can be viewed by only certain enterprise roles by default. For more details on the
     * roles see,
     * https://docs.microsoft.com/azure/cost-management-billing/reservations/reservation-utilization#view-utilization-in-the-azure-portal-with-azure-rbac-access.
     *
     * @param billingAccountId Billing account ID.
     * @param billingProfileId Billing profile ID.
     * @param startDate Start Date.
     * @param endDate End Date.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the long running operation.
     */
    OperationStatus byBillingProfileId(
        String billingAccountId, String billingProfileId, String startDate, String endDate);

    /**
     * Generates the reservations details report for provided date range asynchronously by billing profile. The
     * Reservation usage details can be viewed by only certain enterprise roles by default. For more details on the
     * roles see,
     * https://docs.microsoft.com/azure/cost-management-billing/reservations/reservation-utilization#view-utilization-in-the-azure-portal-with-azure-rbac-access.
     *
     * @param billingAccountId Billing account ID.
     * @param billingProfileId Billing profile ID.
     * @param startDate Start Date.
     * @param endDate End Date.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the status of the long running operation.
     */
    OperationStatus byBillingProfileId(
        String billingAccountId, String billingProfileId, String startDate, String endDate, Context context);
}
