// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The filter expression to be used in the export. */
@Fluent
public final class ForecastFilter {
    /*
     * The logical "AND" expression. Must have at least 2 items.
     */
    @JsonProperty(value = "and")
    private List<ForecastFilter> and;

    /*
     * The logical "OR" expression. Must have at least 2 items.
     */
    @JsonProperty(value = "or")
    private List<ForecastFilter> or;

    /*
     * Has comparison expression for a dimension
     */
    @JsonProperty(value = "dimensions")
    private ForecastComparisonExpression dimensions;

    /*
     * Has comparison expression for a tag
     */
    @JsonProperty(value = "tags")
    private ForecastComparisonExpression tags;

    /** Creates an instance of ForecastFilter class. */
    public ForecastFilter() {
    }

    /**
     * Get the and property: The logical "AND" expression. Must have at least 2 items.
     *
     * @return the and value.
     */
    public List<ForecastFilter> and() {
        return this.and;
    }

    /**
     * Set the and property: The logical "AND" expression. Must have at least 2 items.
     *
     * @param and the and value to set.
     * @return the ForecastFilter object itself.
     */
    public ForecastFilter withAnd(List<ForecastFilter> and) {
        this.and = and;
        return this;
    }

    /**
     * Get the or property: The logical "OR" expression. Must have at least 2 items.
     *
     * @return the or value.
     */
    public List<ForecastFilter> or() {
        return this.or;
    }

    /**
     * Set the or property: The logical "OR" expression. Must have at least 2 items.
     *
     * @param or the or value to set.
     * @return the ForecastFilter object itself.
     */
    public ForecastFilter withOr(List<ForecastFilter> or) {
        this.or = or;
        return this;
    }

    /**
     * Get the dimensions property: Has comparison expression for a dimension.
     *
     * @return the dimensions value.
     */
    public ForecastComparisonExpression dimensions() {
        return this.dimensions;
    }

    /**
     * Set the dimensions property: Has comparison expression for a dimension.
     *
     * @param dimensions the dimensions value to set.
     * @return the ForecastFilter object itself.
     */
    public ForecastFilter withDimensions(ForecastComparisonExpression dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    /**
     * Get the tags property: Has comparison expression for a tag.
     *
     * @return the tags value.
     */
    public ForecastComparisonExpression tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Has comparison expression for a tag.
     *
     * @param tags the tags value to set.
     * @return the ForecastFilter object itself.
     */
    public ForecastFilter withTags(ForecastComparisonExpression tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (and() != null) {
            and().forEach(e -> e.validate());
        }
        if (or() != null) {
            or().forEach(e -> e.validate());
        }
        if (dimensions() != null) {
            dimensions().validate();
        }
        if (tags() != null) {
            tags().validate();
        }
    }
}
