// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** The definition of data present in the forecast. */
@Fluent
public final class ForecastDataset {
    /*
     * The granularity of rows in the forecast.
     */
    @JsonProperty(value = "granularity")
    private GranularityType granularity;

    /*
     * Has configuration information for the data in the export. The configuration will be ignored if aggregation and
     * grouping are provided.
     */
    @JsonProperty(value = "configuration")
    private ForecastDatasetConfiguration configuration;

    /*
     * Dictionary of aggregation expression to use in the forecast. The key of each item in the dictionary is the alias
     * for the aggregated column. forecast can have up to 2 aggregation clauses.
     */
    @JsonProperty(value = "aggregation", required = true)
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, ForecastAggregation> aggregation;

    /*
     * Has filter expression to use in the forecast.
     */
    @JsonProperty(value = "filter")
    private ForecastFilter filter;

    /** Creates an instance of ForecastDataset class. */
    public ForecastDataset() {
    }

    /**
     * Get the granularity property: The granularity of rows in the forecast.
     *
     * @return the granularity value.
     */
    public GranularityType granularity() {
        return this.granularity;
    }

    /**
     * Set the granularity property: The granularity of rows in the forecast.
     *
     * @param granularity the granularity value to set.
     * @return the ForecastDataset object itself.
     */
    public ForecastDataset withGranularity(GranularityType granularity) {
        this.granularity = granularity;
        return this;
    }

    /**
     * Get the configuration property: Has configuration information for the data in the export. The configuration will
     * be ignored if aggregation and grouping are provided.
     *
     * @return the configuration value.
     */
    public ForecastDatasetConfiguration configuration() {
        return this.configuration;
    }

    /**
     * Set the configuration property: Has configuration information for the data in the export. The configuration will
     * be ignored if aggregation and grouping are provided.
     *
     * @param configuration the configuration value to set.
     * @return the ForecastDataset object itself.
     */
    public ForecastDataset withConfiguration(ForecastDatasetConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    /**
     * Get the aggregation property: Dictionary of aggregation expression to use in the forecast. The key of each item
     * in the dictionary is the alias for the aggregated column. forecast can have up to 2 aggregation clauses.
     *
     * @return the aggregation value.
     */
    public Map<String, ForecastAggregation> aggregation() {
        return this.aggregation;
    }

    /**
     * Set the aggregation property: Dictionary of aggregation expression to use in the forecast. The key of each item
     * in the dictionary is the alias for the aggregated column. forecast can have up to 2 aggregation clauses.
     *
     * @param aggregation the aggregation value to set.
     * @return the ForecastDataset object itself.
     */
    public ForecastDataset withAggregation(Map<String, ForecastAggregation> aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    /**
     * Get the filter property: Has filter expression to use in the forecast.
     *
     * @return the filter value.
     */
    public ForecastFilter filter() {
        return this.filter;
    }

    /**
     * Set the filter property: Has filter expression to use in the forecast.
     *
     * @param filter the filter value to set.
     * @return the ForecastDataset object itself.
     */
    public ForecastDataset withFilter(ForecastFilter filter) {
        this.filter = filter;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (configuration() != null) {
            configuration().validate();
        }
        if (aggregation() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property aggregation in model ForecastDataset"));
        } else {
            aggregation()
                .values()
                .forEach(
                    e -> {
                        if (e != null) {
                            e.validate();
                        }
                    });
        }
        if (filter() != null) {
            filter().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ForecastDataset.class);
}
