// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Forecast column properties. */
@Fluent
public final class ForecastColumn {
    /*
     * The name of column.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The type of column.
     */
    @JsonProperty(value = "type")
    private String type;

    /** Creates an instance of ForecastColumn class. */
    public ForecastColumn() {
    }

    /**
     * Get the name property: The name of column.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of column.
     *
     * @param name the name value to set.
     * @return the ForecastColumn object itself.
     */
    public ForecastColumn withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The type of column.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type of column.
     *
     * @param type the type value to set.
     * @return the ForecastColumn object itself.
     */
    public ForecastColumn withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
