// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The schedule associated with the export. */
@Fluent
public final class ExportSchedule {
    /*
     * The status of the export's schedule. If 'Inactive', the export's schedule is paused.
     */
    @JsonProperty(value = "status")
    private StatusType status;

    /*
     * The schedule recurrence.
     */
    @JsonProperty(value = "recurrence")
    private RecurrenceType recurrence;

    /*
     * Has start and end date of the recurrence. The start date must be in future. If present, the end date must be
     * greater than start date.
     */
    @JsonProperty(value = "recurrencePeriod")
    private ExportRecurrencePeriod recurrencePeriod;

    /** Creates an instance of ExportSchedule class. */
    public ExportSchedule() {
    }

    /**
     * Get the status property: The status of the export's schedule. If 'Inactive', the export's schedule is paused.
     *
     * @return the status value.
     */
    public StatusType status() {
        return this.status;
    }

    /**
     * Set the status property: The status of the export's schedule. If 'Inactive', the export's schedule is paused.
     *
     * @param status the status value to set.
     * @return the ExportSchedule object itself.
     */
    public ExportSchedule withStatus(StatusType status) {
        this.status = status;
        return this;
    }

    /**
     * Get the recurrence property: The schedule recurrence.
     *
     * @return the recurrence value.
     */
    public RecurrenceType recurrence() {
        return this.recurrence;
    }

    /**
     * Set the recurrence property: The schedule recurrence.
     *
     * @param recurrence the recurrence value to set.
     * @return the ExportSchedule object itself.
     */
    public ExportSchedule withRecurrence(RecurrenceType recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    /**
     * Get the recurrencePeriod property: Has start and end date of the recurrence. The start date must be in future. If
     * present, the end date must be greater than start date.
     *
     * @return the recurrencePeriod value.
     */
    public ExportRecurrencePeriod recurrencePeriod() {
        return this.recurrencePeriod;
    }

    /**
     * Set the recurrencePeriod property: Has start and end date of the recurrence. The start date must be in future. If
     * present, the end date must be greater than start date.
     *
     * @param recurrencePeriod the recurrencePeriod value to set.
     * @return the ExportSchedule object itself.
     */
    public ExportSchedule withRecurrencePeriod(ExportRecurrencePeriod recurrencePeriod) {
        this.recurrencePeriod = recurrencePeriod;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (recurrencePeriod() != null) {
            recurrencePeriod().validate();
        }
    }
}
