// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.costmanagement.fluent.models.ExportExecutionListResultInner;
import com.azure.resourcemanager.costmanagement.fluent.models.ExportInner;
import java.time.OffsetDateTime;

/** An immutable client-side representation of Export. */
public interface Export {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     *
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     *
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     *
     * @return the type value.
     */
    String type();

    /**
     * Gets the etag property: eTag of the resource. To handle concurrent update scenario, this field will be used to
     * determine whether the user is updating the latest version or not.
     *
     * @return the etag value.
     */
    String etag();

    /**
     * Gets the schedule property: Has schedule information for the export.
     *
     * @return the schedule value.
     */
    ExportSchedule schedule();

    /**
     * Gets the format property: The format of the export being delivered. Currently only 'Csv' is supported.
     *
     * @return the format value.
     */
    FormatType format();

    /**
     * Gets the deliveryInfo property: Has delivery information for the export.
     *
     * @return the deliveryInfo value.
     */
    ExportDeliveryInfo deliveryInfo();

    /**
     * Gets the definition property: Has the definition for the export.
     *
     * @return the definition value.
     */
    ExportDefinition definition();

    /**
     * Gets the runHistory property: If requested, has the most recent run history for the export.
     *
     * @return the runHistory value.
     */
    ExportExecutionListResult runHistory();

    /**
     * Gets the partitionData property: If set to true, exported data will be partitioned by size and placed in a blob
     * directory together with a manifest file. Note: this option is currently available only for Microsoft Customer
     * Agreement commerce scopes.
     *
     * @return the partitionData value.
     */
    Boolean partitionData();

    /**
     * Gets the nextRunTimeEstimate property: If the export has an active schedule, provides an estimate of the next run
     * time.
     *
     * @return the nextRunTimeEstimate value.
     */
    OffsetDateTime nextRunTimeEstimate();

    /**
     * Gets the inner com.azure.resourcemanager.costmanagement.fluent.models.ExportInner object.
     *
     * @return the inner object.
     */
    ExportInner innerModel();

    /** The entirety of the Export definition. */
    interface Definition extends DefinitionStages.Blank, DefinitionStages.WithScope, DefinitionStages.WithCreate {
    }
    /** The Export definition stages. */
    interface DefinitionStages {
        /** The first stage of the Export definition. */
        interface Blank extends WithScope {
        }
        /** The stage of the Export definition allowing to specify parent resource. */
        interface WithScope {
            /**
             * Specifies scope.
             *
             * @param scope The scope associated with export operations. This includes
             *     '/subscriptions/{subscriptionId}/' for subscription scope,
             *     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope,
             *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope and
             *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for
             *     Department scope,
             *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}'
             *     for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId}
             *     for Management Group scope,
             *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}'
             *     for billingProfile scope,
             *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}'
             *     for invoiceSection scope, and
             *     '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' specific for
             *     partners.
             * @return the next definition stage.
             */
            WithCreate withExistingScope(String scope);
        }
        /**
         * The stage of the Export definition which contains all the minimum required properties for the resource to be
         * created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate
            extends DefinitionStages.WithEtag,
                DefinitionStages.WithSchedule,
                DefinitionStages.WithFormat,
                DefinitionStages.WithDeliveryInfo,
                DefinitionStages.WithDefinition,
                DefinitionStages.WithRunHistory,
                DefinitionStages.WithPartitionData {
            /**
             * Executes the create request.
             *
             * @return the created resource.
             */
            Export create();

            /**
             * Executes the create request.
             *
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            Export create(Context context);
        }
        /** The stage of the Export definition allowing to specify etag. */
        interface WithEtag {
            /**
             * Specifies the etag property: eTag of the resource. To handle concurrent update scenario, this field will
             * be used to determine whether the user is updating the latest version or not..
             *
             * @param etag eTag of the resource. To handle concurrent update scenario, this field will be used to
             *     determine whether the user is updating the latest version or not.
             * @return the next definition stage.
             */
            WithCreate withEtag(String etag);
        }
        /** The stage of the Export definition allowing to specify schedule. */
        interface WithSchedule {
            /**
             * Specifies the schedule property: Has schedule information for the export..
             *
             * @param schedule Has schedule information for the export.
             * @return the next definition stage.
             */
            WithCreate withSchedule(ExportSchedule schedule);
        }
        /** The stage of the Export definition allowing to specify format. */
        interface WithFormat {
            /**
             * Specifies the format property: The format of the export being delivered. Currently only 'Csv' is
             * supported..
             *
             * @param format The format of the export being delivered. Currently only 'Csv' is supported.
             * @return the next definition stage.
             */
            WithCreate withFormat(FormatType format);
        }
        /** The stage of the Export definition allowing to specify deliveryInfo. */
        interface WithDeliveryInfo {
            /**
             * Specifies the deliveryInfo property: Has delivery information for the export..
             *
             * @param deliveryInfo Has delivery information for the export.
             * @return the next definition stage.
             */
            WithCreate withDeliveryInfo(ExportDeliveryInfo deliveryInfo);
        }
        /** The stage of the Export definition allowing to specify definition. */
        interface WithDefinition {
            /**
             * Specifies the definition property: Has the definition for the export..
             *
             * @param definition Has the definition for the export.
             * @return the next definition stage.
             */
            WithCreate withDefinition(ExportDefinition definition);
        }
        /** The stage of the Export definition allowing to specify runHistory. */
        interface WithRunHistory {
            /**
             * Specifies the runHistory property: If requested, has the most recent run history for the export..
             *
             * @param runHistory If requested, has the most recent run history for the export.
             * @return the next definition stage.
             */
            WithCreate withRunHistory(ExportExecutionListResultInner runHistory);
        }
        /** The stage of the Export definition allowing to specify partitionData. */
        interface WithPartitionData {
            /**
             * Specifies the partitionData property: If set to true, exported data will be partitioned by size and
             * placed in a blob directory together with a manifest file. Note: this option is currently available only
             * for Microsoft Customer Agreement commerce scopes..
             *
             * @param partitionData If set to true, exported data will be partitioned by size and placed in a blob
             *     directory together with a manifest file. Note: this option is currently available only for Microsoft
             *     Customer Agreement commerce scopes.
             * @return the next definition stage.
             */
            WithCreate withPartitionData(Boolean partitionData);
        }
    }
    /**
     * Begins update for the Export resource.
     *
     * @return the stage of resource update.
     */
    Export.Update update();

    /** The template for Export update. */
    interface Update
        extends UpdateStages.WithEtag,
            UpdateStages.WithSchedule,
            UpdateStages.WithFormat,
            UpdateStages.WithDeliveryInfo,
            UpdateStages.WithDefinition,
            UpdateStages.WithRunHistory,
            UpdateStages.WithPartitionData {
        /**
         * Executes the update request.
         *
         * @return the updated resource.
         */
        Export apply();

        /**
         * Executes the update request.
         *
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        Export apply(Context context);
    }
    /** The Export update stages. */
    interface UpdateStages {
        /** The stage of the Export update allowing to specify etag. */
        interface WithEtag {
            /**
             * Specifies the etag property: eTag of the resource. To handle concurrent update scenario, this field will
             * be used to determine whether the user is updating the latest version or not..
             *
             * @param etag eTag of the resource. To handle concurrent update scenario, this field will be used to
             *     determine whether the user is updating the latest version or not.
             * @return the next definition stage.
             */
            Update withEtag(String etag);
        }
        /** The stage of the Export update allowing to specify schedule. */
        interface WithSchedule {
            /**
             * Specifies the schedule property: Has schedule information for the export..
             *
             * @param schedule Has schedule information for the export.
             * @return the next definition stage.
             */
            Update withSchedule(ExportSchedule schedule);
        }
        /** The stage of the Export update allowing to specify format. */
        interface WithFormat {
            /**
             * Specifies the format property: The format of the export being delivered. Currently only 'Csv' is
             * supported..
             *
             * @param format The format of the export being delivered. Currently only 'Csv' is supported.
             * @return the next definition stage.
             */
            Update withFormat(FormatType format);
        }
        /** The stage of the Export update allowing to specify deliveryInfo. */
        interface WithDeliveryInfo {
            /**
             * Specifies the deliveryInfo property: Has delivery information for the export..
             *
             * @param deliveryInfo Has delivery information for the export.
             * @return the next definition stage.
             */
            Update withDeliveryInfo(ExportDeliveryInfo deliveryInfo);
        }
        /** The stage of the Export update allowing to specify definition. */
        interface WithDefinition {
            /**
             * Specifies the definition property: Has the definition for the export..
             *
             * @param definition Has the definition for the export.
             * @return the next definition stage.
             */
            Update withDefinition(ExportDefinition definition);
        }
        /** The stage of the Export update allowing to specify runHistory. */
        interface WithRunHistory {
            /**
             * Specifies the runHistory property: If requested, has the most recent run history for the export..
             *
             * @param runHistory If requested, has the most recent run history for the export.
             * @return the next definition stage.
             */
            Update withRunHistory(ExportExecutionListResultInner runHistory);
        }
        /** The stage of the Export update allowing to specify partitionData. */
        interface WithPartitionData {
            /**
             * Specifies the partitionData property: If set to true, exported data will be partitioned by size and
             * placed in a blob directory together with a manifest file. Note: this option is currently available only
             * for Microsoft Customer Agreement commerce scopes..
             *
             * @param partitionData If set to true, exported data will be partitioned by size and placed in a blob
             *     directory together with a manifest file. Note: this option is currently available only for Microsoft
             *     Customer Agreement commerce scopes.
             * @return the next definition stage.
             */
            Update withPartitionData(Boolean partitionData);
        }
    }
    /**
     * Refreshes the resource to sync with Azure.
     *
     * @return the refreshed resource.
     */
    Export refresh();

    /**
     * Refreshes the resource to sync with Azure.
     *
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    Export refresh(Context context);

    /**
     * The operation to run an export.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    Response<Void> executeWithResponse(Context context);

    /**
     * The operation to run an export.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void execute();
}
