// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.resourcemanager.costmanagement.fluent.models.CostDetailsOperationResultsInner;
import java.time.OffsetDateTime;
import java.util.List;

/** An immutable client-side representation of CostDetailsOperationResults. */
public interface CostDetailsOperationResults {
    /**
     * Gets the id property: The id of the long running operation.
     *
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the long running operation.
     *
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the long running operation.
     *
     * @return the type value.
     */
    String type();

    /**
     * Gets the status property: The status of the cost details operation.
     *
     * @return the status value.
     */
    CostDetailsStatusType status();

    /**
     * Gets the validTill property: The time at which report URL becomes invalid/expires in UTC e.g.
     * 2020-12-08T05:55:59.4394737Z.
     *
     * @return the validTill value.
     */
    OffsetDateTime validTill();

    /**
     * Gets the error property: The details of the error.
     *
     * @return the error value.
     */
    ManagementError error();

    /**
     * Gets the manifestVersion property: The Manifest version.
     *
     * @return the manifestVersion value.
     */
    String manifestVersion();

    /**
     * Gets the dataFormat property: The data format of the report.
     *
     * @return the dataFormat value.
     */
    CostDetailsDataFormat dataFormat();

    /**
     * Gets the byteCount property: The total number of bytes in all blobs.
     *
     * @return the byteCount value.
     */
    Long byteCount();

    /**
     * Gets the blobCount property: The total number of blobs.
     *
     * @return the blobCount value.
     */
    Integer blobCount();

    /**
     * Gets the compressData property: Is the data in compressed format.
     *
     * @return the compressData value.
     */
    Boolean compressData();

    /**
     * Gets the blobs property: List of blob information generated by this operation.
     *
     * @return the blobs value.
     */
    List<BlobInfo> blobs();

    /**
     * Gets the requestScope property: The request scope of the request.
     *
     * @return the requestScope value.
     */
    String requestScope();

    /**
     * Gets the requestBody property: The request payload body provided in Cost Details call.
     *
     * @return the requestBody value.
     */
    GenerateCostDetailsReportRequestDefinition requestBody();

    /**
     * Gets the inner com.azure.resourcemanager.costmanagement.fluent.models.CostDetailsOperationResultsInner object.
     *
     * @return the inner object.
     */
    CostDetailsOperationResultsInner innerModel();
}
