// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The blob information generated by this operation. */
@Fluent
public final class BlobInfo {
    /*
     * Link to the blob to download file.
     */
    @JsonProperty(value = "blobLink")
    private String blobLink;

    /*
     * Bytes in the blob.
     */
    @JsonProperty(value = "byteCount")
    private Long byteCount;

    /** Creates an instance of BlobInfo class. */
    public BlobInfo() {
    }

    /**
     * Get the blobLink property: Link to the blob to download file.
     *
     * @return the blobLink value.
     */
    public String blobLink() {
        return this.blobLink;
    }

    /**
     * Set the blobLink property: Link to the blob to download file.
     *
     * @param blobLink the blobLink value to set.
     * @return the BlobInfo object itself.
     */
    public BlobInfo withBlobLink(String blobLink) {
        this.blobLink = blobLink;
        return this;
    }

    /**
     * Get the byteCount property: Bytes in the blob.
     *
     * @return the byteCount value.
     */
    public Long byteCount() {
        return this.byteCount;
    }

    /**
     * Set the byteCount property: Bytes in the blob.
     *
     * @param byteCount the byteCount value to set.
     * @return the BlobInfo object itself.
     */
    public BlobInfo withByteCount(Long byteCount) {
        this.byteCount = byteCount;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
