// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** defines the type of alert. */
@Fluent
public final class AlertPropertiesDefinition {
    /*
     * type of alert
     */
    @JsonProperty(value = "type")
    private AlertType type;

    /*
     * Alert category
     */
    @JsonProperty(value = "category")
    private AlertCategory category;

    /*
     * Criteria that triggered alert
     */
    @JsonProperty(value = "criteria")
    private AlertCriteria criteria;

    /** Creates an instance of AlertPropertiesDefinition class. */
    public AlertPropertiesDefinition() {
    }

    /**
     * Get the type property: type of alert.
     *
     * @return the type value.
     */
    public AlertType type() {
        return this.type;
    }

    /**
     * Set the type property: type of alert.
     *
     * @param type the type value to set.
     * @return the AlertPropertiesDefinition object itself.
     */
    public AlertPropertiesDefinition withType(AlertType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the category property: Alert category.
     *
     * @return the category value.
     */
    public AlertCategory category() {
        return this.category;
    }

    /**
     * Set the category property: Alert category.
     *
     * @param category the category value to set.
     * @return the AlertPropertiesDefinition object itself.
     */
    public AlertPropertiesDefinition withCategory(AlertCategory category) {
        this.category = category;
        return this;
    }

    /**
     * Get the criteria property: Criteria that triggered alert.
     *
     * @return the criteria value.
     */
    public AlertCriteria criteria() {
        return this.criteria;
    }

    /**
     * Set the criteria property: Criteria that triggered alert.
     *
     * @param criteria the criteria value to set.
     * @return the AlertPropertiesDefinition object itself.
     */
    public AlertPropertiesDefinition withCriteria(AlertCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
