// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.fluent.ScheduledActionsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.CheckNameAvailabilityResponseInner;
import com.azure.resourcemanager.costmanagement.fluent.models.ScheduledActionInner;
import com.azure.resourcemanager.costmanagement.models.CheckNameAvailabilityRequest;
import com.azure.resourcemanager.costmanagement.models.CheckNameAvailabilityResponse;
import com.azure.resourcemanager.costmanagement.models.ScheduledAction;
import com.azure.resourcemanager.costmanagement.models.ScheduledActions;

public final class ScheduledActionsImpl implements ScheduledActions {
    private static final ClientLogger LOGGER = new ClientLogger(ScheduledActionsImpl.class);

    private final ScheduledActionsClient innerClient;

    private final com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager;

    public ScheduledActionsImpl(
        ScheduledActionsClient innerClient,
        com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ScheduledAction> list() {
        PagedIterable<ScheduledActionInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new ScheduledActionImpl(inner1, this.manager()));
    }

    public PagedIterable<ScheduledAction> list(String filter, Context context) {
        PagedIterable<ScheduledActionInner> inner = this.serviceClient().list(filter, context);
        return Utils.mapPage(inner, inner1 -> new ScheduledActionImpl(inner1, this.manager()));
    }

    public PagedIterable<ScheduledAction> listByScope(String scope) {
        PagedIterable<ScheduledActionInner> inner = this.serviceClient().listByScope(scope);
        return Utils.mapPage(inner, inner1 -> new ScheduledActionImpl(inner1, this.manager()));
    }

    public PagedIterable<ScheduledAction> listByScope(String scope, String filter, Context context) {
        PagedIterable<ScheduledActionInner> inner = this.serviceClient().listByScope(scope, filter, context);
        return Utils.mapPage(inner, inner1 -> new ScheduledActionImpl(inner1, this.manager()));
    }

    public Response<ScheduledAction> createOrUpdateWithResponse(
        String name, ScheduledActionInner scheduledAction, String ifMatch, Context context) {
        Response<ScheduledActionInner> inner =
            this.serviceClient().createOrUpdateWithResponse(name, scheduledAction, ifMatch, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new ScheduledActionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ScheduledAction createOrUpdate(String name, ScheduledActionInner scheduledAction) {
        ScheduledActionInner inner = this.serviceClient().createOrUpdate(name, scheduledAction);
        if (inner != null) {
            return new ScheduledActionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ScheduledAction> getWithResponse(String name, Context context) {
        Response<ScheduledActionInner> inner = this.serviceClient().getWithResponse(name, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new ScheduledActionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ScheduledAction get(String name) {
        ScheduledActionInner inner = this.serviceClient().get(name);
        if (inner != null) {
            return new ScheduledActionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String name, Context context) {
        return this.serviceClient().deleteWithResponse(name, context);
    }

    public void delete(String name) {
        this.serviceClient().delete(name);
    }

    public Response<ScheduledAction> getByScopeWithResponse(String scope, String name, Context context) {
        Response<ScheduledActionInner> inner = this.serviceClient().getByScopeWithResponse(scope, name, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new ScheduledActionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ScheduledAction getByScope(String scope, String name) {
        ScheduledActionInner inner = this.serviceClient().getByScope(scope, name);
        if (inner != null) {
            return new ScheduledActionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteByScopeWithResponse(String scope, String name, Context context) {
        return this.serviceClient().deleteByScopeWithResponse(scope, name, context);
    }

    public void deleteByScope(String scope, String name) {
        this.serviceClient().deleteByScope(scope, name);
    }

    public Response<Void> runWithResponse(String name, Context context) {
        return this.serviceClient().runWithResponse(name, context);
    }

    public void run(String name) {
        this.serviceClient().run(name);
    }

    public Response<Void> runByScopeWithResponse(String scope, String name, Context context) {
        return this.serviceClient().runByScopeWithResponse(scope, name, context);
    }

    public void runByScope(String scope, String name) {
        this.serviceClient().runByScope(scope, name);
    }

    public Response<CheckNameAvailabilityResponse> checkNameAvailabilityWithResponse(
        CheckNameAvailabilityRequest checkNameAvailabilityRequest, Context context) {
        Response<CheckNameAvailabilityResponseInner> inner =
            this.serviceClient().checkNameAvailabilityWithResponse(checkNameAvailabilityRequest, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new CheckNameAvailabilityResponseImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public CheckNameAvailabilityResponse checkNameAvailability(
        CheckNameAvailabilityRequest checkNameAvailabilityRequest) {
        CheckNameAvailabilityResponseInner inner =
            this.serviceClient().checkNameAvailability(checkNameAvailabilityRequest);
        if (inner != null) {
            return new CheckNameAvailabilityResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<CheckNameAvailabilityResponse> checkNameAvailabilityByScopeWithResponse(
        String scope, CheckNameAvailabilityRequest checkNameAvailabilityRequest, Context context) {
        Response<CheckNameAvailabilityResponseInner> inner =
            this.serviceClient().checkNameAvailabilityByScopeWithResponse(scope, checkNameAvailabilityRequest, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new CheckNameAvailabilityResponseImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public CheckNameAvailabilityResponse checkNameAvailabilityByScope(
        String scope, CheckNameAvailabilityRequest checkNameAvailabilityRequest) {
        CheckNameAvailabilityResponseInner inner =
            this.serviceClient().checkNameAvailabilityByScope(scope, checkNameAvailabilityRequest);
        if (inner != null) {
            return new CheckNameAvailabilityResponseImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ScheduledAction getById(String id) {
        String scope =
            Utils
                .getValueFromIdByParameterName(
                    id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "scope");
        if (scope == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String name =
            Utils
                .getValueFromIdByParameterName(
                    id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "name");
        if (name == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String
                            .format(
                                "The resource ID '%s' is not valid. Missing path segment 'scheduledActions'.", id)));
        }
        return this.getByScopeWithResponse(scope, name, Context.NONE).getValue();
    }

    public Response<ScheduledAction> getByIdWithResponse(String id, Context context) {
        String scope =
            Utils
                .getValueFromIdByParameterName(
                    id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "scope");
        if (scope == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String name =
            Utils
                .getValueFromIdByParameterName(
                    id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "name");
        if (name == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String
                            .format(
                                "The resource ID '%s' is not valid. Missing path segment 'scheduledActions'.", id)));
        }
        return this.getByScopeWithResponse(scope, name, context);
    }

    public void deleteById(String id) {
        String scope =
            Utils
                .getValueFromIdByParameterName(
                    id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "scope");
        if (scope == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String name =
            Utils
                .getValueFromIdByParameterName(
                    id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "name");
        if (name == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String
                            .format(
                                "The resource ID '%s' is not valid. Missing path segment 'scheduledActions'.", id)));
        }
        this.deleteByScopeWithResponse(scope, name, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String scope =
            Utils
                .getValueFromIdByParameterName(
                    id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "scope");
        if (scope == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String name =
            Utils
                .getValueFromIdByParameterName(
                    id, "/{scope}/providers/Microsoft.CostManagement/scheduledActions/{name}", "name");
        if (name == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        String
                            .format(
                                "The resource ID '%s' is not valid. Missing path segment 'scheduledActions'.", id)));
        }
        return this.deleteByScopeWithResponse(scope, name, context);
    }

    private ScheduledActionsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.costmanagement.CostManagementManager manager() {
        return this.serviceManager;
    }

    public ScheduledActionImpl define(String name) {
        return new ScheduledActionImpl(name, this.manager());
    }
}
