// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.fluent.PriceSheetsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.DownloadUrlInner;
import com.azure.resourcemanager.costmanagement.models.DownloadUrl;
import com.azure.resourcemanager.costmanagement.models.PriceSheets;

public final class PriceSheetsImpl implements PriceSheets {
    private static final ClientLogger LOGGER = new ClientLogger(PriceSheetsImpl.class);

    private final PriceSheetsClient innerClient;

    private final com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager;

    public PriceSheetsImpl(
        PriceSheetsClient innerClient, com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public DownloadUrl download(String billingAccountName, String billingProfileName, String invoiceName) {
        DownloadUrlInner inner = this.serviceClient().download(billingAccountName, billingProfileName, invoiceName);
        if (inner != null) {
            return new DownloadUrlImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public DownloadUrl download(
        String billingAccountName, String billingProfileName, String invoiceName, Context context) {
        DownloadUrlInner inner =
            this.serviceClient().download(billingAccountName, billingProfileName, invoiceName, context);
        if (inner != null) {
            return new DownloadUrlImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public DownloadUrl downloadByBillingProfile(String billingAccountName, String billingProfileName) {
        DownloadUrlInner inner = this.serviceClient().downloadByBillingProfile(billingAccountName, billingProfileName);
        if (inner != null) {
            return new DownloadUrlImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public DownloadUrl downloadByBillingProfile(String billingAccountName, String billingProfileName, Context context) {
        DownloadUrlInner inner =
            this.serviceClient().downloadByBillingProfile(billingAccountName, billingProfileName, context);
        if (inner != null) {
            return new DownloadUrlImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private PriceSheetsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.costmanagement.CostManagementManager manager() {
        return this.serviceManager;
    }
}
