// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.fluent.OperationsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.CostManagementOperationInner;
import com.azure.resourcemanager.costmanagement.models.CostManagementOperation;
import com.azure.resourcemanager.costmanagement.models.Operations;

public final class OperationsImpl implements Operations {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsImpl.class);

    private final OperationsClient innerClient;

    private final com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager;

    public OperationsImpl(
        OperationsClient innerClient, com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<CostManagementOperation> list() {
        PagedIterable<CostManagementOperationInner> inner = this.serviceClient().list();
        return Utils.mapPage(inner, inner1 -> new CostManagementOperationImpl(inner1, this.manager()));
    }

    public PagedIterable<CostManagementOperation> list(Context context) {
        PagedIterable<CostManagementOperationInner> inner = this.serviceClient().list(context);
        return Utils.mapPage(inner, inner1 -> new CostManagementOperationImpl(inner1, this.manager()));
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.costmanagement.CostManagementManager manager() {
        return this.serviceManager;
    }
}
