// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.resourcemanager.costmanagement.fluent.models.CommonExportPropertiesInner;
import com.azure.resourcemanager.costmanagement.fluent.models.ExportExecutionListResultInner;
import com.azure.resourcemanager.costmanagement.models.CommonExportProperties;
import com.azure.resourcemanager.costmanagement.models.ExportDefinition;
import com.azure.resourcemanager.costmanagement.models.ExportDeliveryInfo;
import com.azure.resourcemanager.costmanagement.models.ExportExecutionListResult;
import com.azure.resourcemanager.costmanagement.models.FormatType;
import java.time.OffsetDateTime;

public final class CommonExportPropertiesImpl implements CommonExportProperties {
    private CommonExportPropertiesInner innerObject;

    private final com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager;

    CommonExportPropertiesImpl(
        CommonExportPropertiesInner innerObject,
        com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public FormatType format() {
        return this.innerModel().format();
    }

    public ExportDeliveryInfo deliveryInfo() {
        return this.innerModel().deliveryInfo();
    }

    public ExportDefinition definition() {
        return this.innerModel().definition();
    }

    public ExportExecutionListResult runHistory() {
        ExportExecutionListResultInner inner = this.innerModel().runHistory();
        if (inner != null) {
            return new ExportExecutionListResultImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Boolean partitionData() {
        return this.innerModel().partitionData();
    }

    public OffsetDateTime nextRunTimeEstimate() {
        return this.innerModel().nextRunTimeEstimate();
    }

    public CommonExportPropertiesInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.costmanagement.CostManagementManager manager() {
        return this.serviceManager;
    }
}
