// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.costmanagement.fluent.AlertsClient;
import com.azure.resourcemanager.costmanagement.fluent.models.AlertInner;
import com.azure.resourcemanager.costmanagement.fluent.models.AlertsResultInner;
import com.azure.resourcemanager.costmanagement.models.Alert;
import com.azure.resourcemanager.costmanagement.models.Alerts;
import com.azure.resourcemanager.costmanagement.models.AlertsResult;
import com.azure.resourcemanager.costmanagement.models.DismissAlertPayload;
import com.azure.resourcemanager.costmanagement.models.ExternalCloudProviderType;

public final class AlertsImpl implements Alerts {
    private static final ClientLogger LOGGER = new ClientLogger(AlertsImpl.class);

    private final AlertsClient innerClient;

    private final com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager;

    public AlertsImpl(
        AlertsClient innerClient, com.azure.resourcemanager.costmanagement.CostManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<AlertsResult> listWithResponse(String scope, Context context) {
        Response<AlertsResultInner> inner = this.serviceClient().listWithResponse(scope, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new AlertsResultImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public AlertsResult list(String scope) {
        AlertsResultInner inner = this.serviceClient().list(scope);
        if (inner != null) {
            return new AlertsResultImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Alert> getWithResponse(String scope, String alertId, Context context) {
        Response<AlertInner> inner = this.serviceClient().getWithResponse(scope, alertId, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new AlertImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Alert get(String scope, String alertId) {
        AlertInner inner = this.serviceClient().get(scope, alertId);
        if (inner != null) {
            return new AlertImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Alert> dismissWithResponse(
        String scope, String alertId, DismissAlertPayload parameters, Context context) {
        Response<AlertInner> inner = this.serviceClient().dismissWithResponse(scope, alertId, parameters, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new AlertImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public Alert dismiss(String scope, String alertId, DismissAlertPayload parameters) {
        AlertInner inner = this.serviceClient().dismiss(scope, alertId, parameters);
        if (inner != null) {
            return new AlertImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<AlertsResult> listExternalWithResponse(
        ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId, Context context) {
        Response<AlertsResultInner> inner =
            this.serviceClient().listExternalWithResponse(externalCloudProviderType, externalCloudProviderId, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new AlertsResultImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public AlertsResult listExternal(
        ExternalCloudProviderType externalCloudProviderType, String externalCloudProviderId) {
        AlertsResultInner inner = this.serviceClient().listExternal(externalCloudProviderType, externalCloudProviderId);
        if (inner != null) {
            return new AlertsResultImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private AlertsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.costmanagement.CostManagementManager manager() {
        return this.serviceManager;
    }
}
