// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.costmanagement.models.GenerateCostDetailsReportRequestDefinition;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The context of the Cost Details request. */
@Fluent
public final class RequestContext {
    /*
     * The request scope of the request.
     */
    @JsonProperty(value = "requestScope")
    private String requestScope;

    /*
     * The request payload body provided in Cost Details call
     */
    @JsonProperty(value = "requestBody")
    private GenerateCostDetailsReportRequestDefinition requestBody;

    /** Creates an instance of RequestContext class. */
    public RequestContext() {
    }

    /**
     * Get the requestScope property: The request scope of the request.
     *
     * @return the requestScope value.
     */
    public String requestScope() {
        return this.requestScope;
    }

    /**
     * Set the requestScope property: The request scope of the request.
     *
     * @param requestScope the requestScope value to set.
     * @return the RequestContext object itself.
     */
    public RequestContext withRequestScope(String requestScope) {
        this.requestScope = requestScope;
        return this;
    }

    /**
     * Get the requestBody property: The request payload body provided in Cost Details call.
     *
     * @return the requestBody value.
     */
    public GenerateCostDetailsReportRequestDefinition requestBody() {
        return this.requestBody;
    }

    /**
     * Set the requestBody property: The request payload body provided in Cost Details call.
     *
     * @param requestBody the requestBody value to set.
     * @return the RequestContext object itself.
     */
    public RequestContext withRequestBody(GenerateCostDetailsReportRequestDefinition requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (requestBody() != null) {
            requestBody().validate();
        }
    }
}
