// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.costmanagement.models.CostManagementResource;
import com.azure.resourcemanager.costmanagement.models.QueryColumn;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** Result of query. It contains all columns listed under groupings and aggregation. */
@Fluent
public final class QueryResultInner extends CostManagementResource {
    /*
     * Query properties
     */
    @JsonProperty(value = "properties")
    private QueryProperties innerProperties;

    /** Creates an instance of QueryResultInner class. */
    public QueryResultInner() {
    }

    /**
     * Get the innerProperties property: Query properties.
     *
     * @return the innerProperties value.
     */
    private QueryProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public QueryResultInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public QueryResultInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the nextLink property: The link (url) to the next page of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.innerProperties() == null ? null : this.innerProperties().nextLink();
    }

    /**
     * Set the nextLink property: The link (url) to the next page of results.
     *
     * @param nextLink the nextLink value to set.
     * @return the QueryResultInner object itself.
     */
    public QueryResultInner withNextLink(String nextLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new QueryProperties();
        }
        this.innerProperties().withNextLink(nextLink);
        return this;
    }

    /**
     * Get the columns property: Array of columns.
     *
     * @return the columns value.
     */
    public List<QueryColumn> columns() {
        return this.innerProperties() == null ? null : this.innerProperties().columns();
    }

    /**
     * Set the columns property: Array of columns.
     *
     * @param columns the columns value to set.
     * @return the QueryResultInner object itself.
     */
    public QueryResultInner withColumns(List<QueryColumn> columns) {
        if (this.innerProperties() == null) {
            this.innerProperties = new QueryProperties();
        }
        this.innerProperties().withColumns(columns);
        return this;
    }

    /**
     * Get the rows property: Array of rows.
     *
     * @return the rows value.
     */
    public List<List<Object>> rows() {
        return this.innerProperties() == null ? null : this.innerProperties().rows();
    }

    /**
     * Set the rows property: Array of rows.
     *
     * @param rows the rows value to set.
     * @return the QueryResultInner object itself.
     */
    public QueryResultInner withRows(List<List<Object>> rows) {
        if (this.innerProperties() == null) {
            this.innerProperties = new QueryProperties();
        }
        this.innerProperties().withRows(rows);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
