// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.costmanagement.models.BenefitKind;
import com.azure.resourcemanager.costmanagement.models.BenefitRecommendationProperties;
import com.azure.resourcemanager.costmanagement.models.BenefitResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** benefit plan recommendation details. */
@Fluent
public final class BenefitRecommendationModelInner extends BenefitResource {
    /*
     * The properties of the benefit recommendations.
     */
    @JsonProperty(value = "properties")
    private BenefitRecommendationProperties properties;

    /** Creates an instance of BenefitRecommendationModelInner class. */
    public BenefitRecommendationModelInner() {
    }

    /**
     * Get the properties property: The properties of the benefit recommendations.
     *
     * @return the properties value.
     */
    public BenefitRecommendationProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The properties of the benefit recommendations.
     *
     * @param properties the properties value to set.
     * @return the BenefitRecommendationModelInner object itself.
     */
    public BenefitRecommendationModelInner withProperties(BenefitRecommendationProperties properties) {
        this.properties = properties;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public BenefitRecommendationModelInner withKind(BenefitKind kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (properties() != null) {
            properties().validate();
        }
    }
}
