// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Result of alerts. */
@Immutable
public final class AlertsResultInner {
    /*
     * List of alerts.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<AlertInner> value;

    /*
     * URL to get the next set of alerts results if there are any.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /** Creates an instance of AlertsResultInner class. */
    public AlertsResultInner() {
    }

    /**
     * Get the value property: List of alerts.
     *
     * @return the value value.
     */
    public List<AlertInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: URL to get the next set of alerts results if there are any.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
