// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.costmanagement.models.AlertPropertiesDefinition;
import com.azure.resourcemanager.costmanagement.models.AlertPropertiesDetails;
import com.azure.resourcemanager.costmanagement.models.AlertSource;
import com.azure.resourcemanager.costmanagement.models.AlertStatus;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Alert properties. */
@Fluent
public final class AlertProperties {
    /*
     * defines the type of alert
     */
    @JsonProperty(value = "definition")
    private AlertPropertiesDefinition definition;

    /*
     * Alert description
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * Source of alert
     */
    @JsonProperty(value = "source")
    private AlertSource source;

    /*
     * Alert details
     */
    @JsonProperty(value = "details")
    private AlertPropertiesDetails details;

    /*
     * related budget
     */
    @JsonProperty(value = "costEntityId")
    private String costEntityId;

    /*
     * alert status
     */
    @JsonProperty(value = "status")
    private AlertStatus status;

    /*
     * dateTime in which alert was created
     */
    @JsonProperty(value = "creationTime")
    private String creationTime;

    /*
     * dateTime in which alert was closed
     */
    @JsonProperty(value = "closeTime")
    private String closeTime;

    /*
     * dateTime in which alert was last modified
     */
    @JsonProperty(value = "modificationTime")
    private String modificationTime;

    /*
     * User who last modified the alert
     */
    @JsonProperty(value = "statusModificationUserName")
    private String statusModificationUsername;

    /*
     * dateTime in which the alert status was last modified
     */
    @JsonProperty(value = "statusModificationTime")
    private String statusModificationTime;

    /** Creates an instance of AlertProperties class. */
    public AlertProperties() {
    }

    /**
     * Get the definition property: defines the type of alert.
     *
     * @return the definition value.
     */
    public AlertPropertiesDefinition definition() {
        return this.definition;
    }

    /**
     * Set the definition property: defines the type of alert.
     *
     * @param definition the definition value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withDefinition(AlertPropertiesDefinition definition) {
        this.definition = definition;
        return this;
    }

    /**
     * Get the description property: Alert description.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Alert description.
     *
     * @param description the description value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the source property: Source of alert.
     *
     * @return the source value.
     */
    public AlertSource source() {
        return this.source;
    }

    /**
     * Set the source property: Source of alert.
     *
     * @param source the source value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withSource(AlertSource source) {
        this.source = source;
        return this;
    }

    /**
     * Get the details property: Alert details.
     *
     * @return the details value.
     */
    public AlertPropertiesDetails details() {
        return this.details;
    }

    /**
     * Set the details property: Alert details.
     *
     * @param details the details value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withDetails(AlertPropertiesDetails details) {
        this.details = details;
        return this;
    }

    /**
     * Get the costEntityId property: related budget.
     *
     * @return the costEntityId value.
     */
    public String costEntityId() {
        return this.costEntityId;
    }

    /**
     * Set the costEntityId property: related budget.
     *
     * @param costEntityId the costEntityId value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withCostEntityId(String costEntityId) {
        this.costEntityId = costEntityId;
        return this;
    }

    /**
     * Get the status property: alert status.
     *
     * @return the status value.
     */
    public AlertStatus status() {
        return this.status;
    }

    /**
     * Set the status property: alert status.
     *
     * @param status the status value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withStatus(AlertStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the creationTime property: dateTime in which alert was created.
     *
     * @return the creationTime value.
     */
    public String creationTime() {
        return this.creationTime;
    }

    /**
     * Set the creationTime property: dateTime in which alert was created.
     *
     * @param creationTime the creationTime value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withCreationTime(String creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    /**
     * Get the closeTime property: dateTime in which alert was closed.
     *
     * @return the closeTime value.
     */
    public String closeTime() {
        return this.closeTime;
    }

    /**
     * Set the closeTime property: dateTime in which alert was closed.
     *
     * @param closeTime the closeTime value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withCloseTime(String closeTime) {
        this.closeTime = closeTime;
        return this;
    }

    /**
     * Get the modificationTime property: dateTime in which alert was last modified.
     *
     * @return the modificationTime value.
     */
    public String modificationTime() {
        return this.modificationTime;
    }

    /**
     * Set the modificationTime property: dateTime in which alert was last modified.
     *
     * @param modificationTime the modificationTime value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withModificationTime(String modificationTime) {
        this.modificationTime = modificationTime;
        return this;
    }

    /**
     * Get the statusModificationUsername property: User who last modified the alert.
     *
     * @return the statusModificationUsername value.
     */
    public String statusModificationUsername() {
        return this.statusModificationUsername;
    }

    /**
     * Set the statusModificationUsername property: User who last modified the alert.
     *
     * @param statusModificationUsername the statusModificationUsername value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withStatusModificationUsername(String statusModificationUsername) {
        this.statusModificationUsername = statusModificationUsername;
        return this;
    }

    /**
     * Get the statusModificationTime property: dateTime in which the alert status was last modified.
     *
     * @return the statusModificationTime value.
     */
    public String statusModificationTime() {
        return this.statusModificationTime;
    }

    /**
     * Set the statusModificationTime property: dateTime in which the alert status was last modified.
     *
     * @param statusModificationTime the statusModificationTime value to set.
     * @return the AlertProperties object itself.
     */
    public AlertProperties withStatusModificationTime(String statusModificationTime) {
        this.statusModificationTime = statusModificationTime;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (definition() != null) {
            definition().validate();
        }
        if (details() != null) {
            details().validate();
        }
    }
}
