// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent;

import com.azure.core.http.HttpPipeline;
import java.time.Duration;

/** The interface for CostManagementClient class. */
public interface CostManagementClient {
    /**
     * Gets server parameter.
     *
     * @return the endpoint value.
     */
    String getEndpoint();

    /**
     * Gets Api Version.
     *
     * @return the apiVersion value.
     */
    String getApiVersion();

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    HttpPipeline getHttpPipeline();

    /**
     * Gets The default poll interval for long-running operation.
     *
     * @return the defaultPollInterval value.
     */
    Duration getDefaultPollInterval();

    /**
     * Gets the OperationsClient object to access its operations.
     *
     * @return the OperationsClient object.
     */
    OperationsClient getOperations();

    /**
     * Gets the ViewsClient object to access its operations.
     *
     * @return the ViewsClient object.
     */
    ViewsClient getViews();

    /**
     * Gets the AlertsClient object to access its operations.
     *
     * @return the AlertsClient object.
     */
    AlertsClient getAlerts();

    /**
     * Gets the ForecastsClient object to access its operations.
     *
     * @return the ForecastsClient object.
     */
    ForecastsClient getForecasts();

    /**
     * Gets the DimensionsClient object to access its operations.
     *
     * @return the DimensionsClient object.
     */
    DimensionsClient getDimensions();

    /**
     * Gets the QueriesClient object to access its operations.
     *
     * @return the QueriesClient object.
     */
    QueriesClient getQueries();

    /**
     * Gets the GenerateReservationDetailsReportsClient object to access its operations.
     *
     * @return the GenerateReservationDetailsReportsClient object.
     */
    GenerateReservationDetailsReportsClient getGenerateReservationDetailsReports();

    /**
     * Gets the ExportsClient object to access its operations.
     *
     * @return the ExportsClient object.
     */
    ExportsClient getExports();

    /**
     * Gets the GenerateCostDetailsReportsClient object to access its operations.
     *
     * @return the GenerateCostDetailsReportsClient object.
     */
    GenerateCostDetailsReportsClient getGenerateCostDetailsReports();

    /**
     * Gets the GenerateDetailedCostReportsClient object to access its operations.
     *
     * @return the GenerateDetailedCostReportsClient object.
     */
    GenerateDetailedCostReportsClient getGenerateDetailedCostReports();

    /**
     * Gets the GenerateDetailedCostReportOperationResultsClient object to access its operations.
     *
     * @return the GenerateDetailedCostReportOperationResultsClient object.
     */
    GenerateDetailedCostReportOperationResultsClient getGenerateDetailedCostReportOperationResults();

    /**
     * Gets the GenerateDetailedCostReportOperationStatusClient object to access its operations.
     *
     * @return the GenerateDetailedCostReportOperationStatusClient object.
     */
    GenerateDetailedCostReportOperationStatusClient getGenerateDetailedCostReportOperationStatus();

    /**
     * Gets the PriceSheetsClient object to access its operations.
     *
     * @return the PriceSheetsClient object.
     */
    PriceSheetsClient getPriceSheets();

    /**
     * Gets the ScheduledActionsClient object to access its operations.
     *
     * @return the ScheduledActionsClient object.
     */
    ScheduledActionsClient getScheduledActions();

    /**
     * Gets the BenefitRecommendationsClient object to access its operations.
     *
     * @return the BenefitRecommendationsClient object.
     */
    BenefitRecommendationsClient getBenefitRecommendations();

    /**
     * Gets the BenefitUtilizationSummariesClient object to access its operations.
     *
     * @return the BenefitUtilizationSummariesClient object.
     */
    BenefitUtilizationSummariesClient getBenefitUtilizationSummaries();
}
