// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.costmanagement.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.resourcemanager.costmanagement.fluent.models.BenefitUtilizationSummaryInner;
import com.azure.resourcemanager.costmanagement.models.GrainParameter;

/** An instance of this class provides access to all the operations defined in BenefitUtilizationSummariesClient. */
public interface BenefitUtilizationSummariesClient {
    /**
     * Lists savings plan utilization summaries for the enterprise agreement scope. Supported at grain values: 'Daily'
     * and 'Monthly'.
     *
     * @param billingAccountId Billing account ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BenefitUtilizationSummaryInner> listByBillingAccountId(String billingAccountId);

    /**
     * Lists savings plan utilization summaries for the enterprise agreement scope. Supported at grain values: 'Daily'
     * and 'Monthly'.
     *
     * @param billingAccountId Billing account ID.
     * @param grainParameter Grain.
     * @param filter Supports filtering by properties/benefitId, properties/benefitOrderId and properties/usageDate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BenefitUtilizationSummaryInner> listByBillingAccountId(
        String billingAccountId, GrainParameter grainParameter, String filter, Context context);

    /**
     * Lists savings plan utilization summaries for billing profile. Supported at grain values: 'Daily' and 'Monthly'.
     *
     * @param billingAccountId Billing account ID.
     * @param billingProfileId Billing profile ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BenefitUtilizationSummaryInner> listByBillingProfileId(
        String billingAccountId, String billingProfileId);

    /**
     * Lists savings plan utilization summaries for billing profile. Supported at grain values: 'Daily' and 'Monthly'.
     *
     * @param billingAccountId Billing account ID.
     * @param billingProfileId Billing profile ID.
     * @param grainParameter Grain.
     * @param filter Supports filtering by properties/benefitId, properties/benefitOrderId and properties/usageDate.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BenefitUtilizationSummaryInner> listByBillingProfileId(
        String billingAccountId,
        String billingProfileId,
        GrainParameter grainParameter,
        String filter,
        Context context);

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     *
     * @param savingsPlanOrderId Savings plan order ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BenefitUtilizationSummaryInner> listBySavingsPlanOrder(String savingsPlanOrderId);

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     *
     * @param savingsPlanOrderId Savings plan order ID.
     * @param filter Supports filtering by properties/usageDate.
     * @param grainParameter Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BenefitUtilizationSummaryInner> listBySavingsPlanOrder(
        String savingsPlanOrderId, String filter, GrainParameter grainParameter, Context context);

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     *
     * @param savingsPlanOrderId Savings plan order ID.
     * @param savingsPlanId Savings plan ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BenefitUtilizationSummaryInner> listBySavingsPlanId(String savingsPlanOrderId, String savingsPlanId);

    /**
     * Lists the savings plan utilization summaries for daily or monthly grain.
     *
     * @param savingsPlanOrderId Savings plan order ID.
     * @param savingsPlanId Savings plan ID.
     * @param filter Supports filtering by properties/usageDate.
     * @param grainParameter Grain.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of benefit utilization summaries as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BenefitUtilizationSummaryInner> listBySavingsPlanId(
        String savingsPlanOrderId, String savingsPlanId, String filter, GrainParameter grainParameter, Context context);
}
