// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** The protocol associated with the port. */
public final class ContainerNetworkProtocol extends ExpandableStringEnum<ContainerNetworkProtocol> {
    /** Static value TCP for ContainerNetworkProtocol. */
    public static final ContainerNetworkProtocol TCP = fromString("TCP");

    /** Static value UDP for ContainerNetworkProtocol. */
    public static final ContainerNetworkProtocol UDP = fromString("UDP");

    /**
     * Creates a new instance of ContainerNetworkProtocol value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ContainerNetworkProtocol() {
    }

    /**
     * Creates or finds a ContainerNetworkProtocol from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ContainerNetworkProtocol.
     */
    @JsonCreator
    public static ContainerNetworkProtocol fromString(String name) {
        return fromString(name, ContainerNetworkProtocol.class);
    }

    /**
     * Gets known ContainerNetworkProtocol values.
     *
     * @return known ContainerNetworkProtocol values.
     */
    public static Collection<ContainerNetworkProtocol> values() {
        return values(ContainerNetworkProtocol.class);
    }
}
