// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Extension specific properties. */
@Fluent
public final class DeploymentExtensionSpecProperties {
    /*
     * Type of extension to be added.
     */
    @JsonProperty(value = "extensionType", required = true)
    private String extensionType;

    /*
     * Version of the extension being used.
     */
    @JsonProperty(value = "version", required = true)
    private String version;

    /*
     * Settings for the extension.
     */
    @JsonProperty(value = "settings")
    private Object settings;

    /*
     * Protected settings for the extension.
     */
    @JsonProperty(value = "protectedSettings")
    private Object protectedSettings;

    /** Creates an instance of DeploymentExtensionSpecProperties class. */
    public DeploymentExtensionSpecProperties() {
    }

    /**
     * Get the extensionType property: Type of extension to be added.
     *
     * @return the extensionType value.
     */
    public String extensionType() {
        return this.extensionType;
    }

    /**
     * Set the extensionType property: Type of extension to be added.
     *
     * @param extensionType the extensionType value to set.
     * @return the DeploymentExtensionSpecProperties object itself.
     */
    public DeploymentExtensionSpecProperties withExtensionType(String extensionType) {
        this.extensionType = extensionType;
        return this;
    }

    /**
     * Get the version property: Version of the extension being used.
     *
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: Version of the extension being used.
     *
     * @param version the version value to set.
     * @return the DeploymentExtensionSpecProperties object itself.
     */
    public DeploymentExtensionSpecProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the settings property: Settings for the extension.
     *
     * @return the settings value.
     */
    public Object settings() {
        return this.settings;
    }

    /**
     * Set the settings property: Settings for the extension.
     *
     * @param settings the settings value to set.
     * @return the DeploymentExtensionSpecProperties object itself.
     */
    public DeploymentExtensionSpecProperties withSettings(Object settings) {
        this.settings = settings;
        return this;
    }

    /**
     * Get the protectedSettings property: Protected settings for the extension.
     *
     * @return the protectedSettings value.
     */
    public Object protectedSettings() {
        return this.protectedSettings;
    }

    /**
     * Set the protectedSettings property: Protected settings for the extension.
     *
     * @param protectedSettings the protectedSettings value to set.
     * @return the DeploymentExtensionSpecProperties object itself.
     */
    public DeploymentExtensionSpecProperties withProtectedSettings(Object protectedSettings) {
        this.protectedSettings = protectedSettings;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (extensionType() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property extensionType in model DeploymentExtensionSpecProperties"));
        }
        if (version() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property version in model DeploymentExtensionSpecProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DeploymentExtensionSpecProperties.class);
}
