// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerinstance.models.ConfidentialComputeProperties;
import com.azure.resourcemanager.containerinstance.models.Container;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupDiagnostics;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupIdentity;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupPriority;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupPropertiesInstanceView;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupRestartPolicy;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupSku;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupSubnetId;
import com.azure.resourcemanager.containerinstance.models.DeploymentExtensionSpec;
import com.azure.resourcemanager.containerinstance.models.DnsConfiguration;
import com.azure.resourcemanager.containerinstance.models.EncryptionProperties;
import com.azure.resourcemanager.containerinstance.models.ImageRegistryCredential;
import com.azure.resourcemanager.containerinstance.models.InitContainerDefinition;
import com.azure.resourcemanager.containerinstance.models.IpAddress;
import com.azure.resourcemanager.containerinstance.models.OperatingSystemTypes;
import com.azure.resourcemanager.containerinstance.models.Volume;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** A container group. */
@Fluent
public final class ContainerGroupInner extends Resource {
    /*
     * The zones for the container group.
     */
    @JsonProperty(value = "zones")
    private List<String> zones;

    /*
     * The identity of the container group, if configured.
     */
    @JsonProperty(value = "identity")
    private ContainerGroupIdentity identity;

    /*
     * The container group properties
     */
    @JsonProperty(value = "properties", required = true)
    private ContainerGroupProperties innerProperties = new ContainerGroupProperties();

    /** Creates an instance of ContainerGroupInner class. */
    public ContainerGroupInner() {
    }

    /**
     * Get the zones property: The zones for the container group.
     *
     * @return the zones value.
     */
    public List<String> zones() {
        return this.zones;
    }

    /**
     * Set the zones property: The zones for the container group.
     *
     * @param zones the zones value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    /**
     * Get the identity property: The identity of the container group, if configured.
     *
     * @return the identity value.
     */
    public ContainerGroupIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The identity of the container group, if configured.
     *
     * @param identity the identity value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withIdentity(ContainerGroupIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the innerProperties property: The container group properties.
     *
     * @return the innerProperties value.
     */
    private ContainerGroupProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public ContainerGroupInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ContainerGroupInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the container group. This only appears in the
     * response.
     *
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the containers property: The containers within the container group.
     *
     * @return the containers value.
     */
    public List<Container> containers() {
        return this.innerProperties() == null ? null : this.innerProperties().containers();
    }

    /**
     * Set the containers property: The containers within the container group.
     *
     * @param containers the containers value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withContainers(List<Container> containers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withContainers(containers);
        return this;
    }

    /**
     * Get the imageRegistryCredentials property: The image registry credentials by which the container group is created
     * from.
     *
     * @return the imageRegistryCredentials value.
     */
    public List<ImageRegistryCredential> imageRegistryCredentials() {
        return this.innerProperties() == null ? null : this.innerProperties().imageRegistryCredentials();
    }

    /**
     * Set the imageRegistryCredentials property: The image registry credentials by which the container group is created
     * from.
     *
     * @param imageRegistryCredentials the imageRegistryCredentials value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withImageRegistryCredentials(List<ImageRegistryCredential> imageRegistryCredentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withImageRegistryCredentials(imageRegistryCredentials);
        return this;
    }

    /**
     * Get the restartPolicy property: Restart policy for all containers within the container group. - `Always` Always
     * restart - `OnFailure` Restart on failure - `Never` Never restart.
     *
     * @return the restartPolicy value.
     */
    public ContainerGroupRestartPolicy restartPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().restartPolicy();
    }

    /**
     * Set the restartPolicy property: Restart policy for all containers within the container group. - `Always` Always
     * restart - `OnFailure` Restart on failure - `Never` Never restart.
     *
     * @param restartPolicy the restartPolicy value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withRestartPolicy(ContainerGroupRestartPolicy restartPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withRestartPolicy(restartPolicy);
        return this;
    }

    /**
     * Get the ipAddress property: The IP address type of the container group.
     *
     * @return the ipAddress value.
     */
    public IpAddress ipAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAddress();
    }

    /**
     * Set the ipAddress property: The IP address type of the container group.
     *
     * @param ipAddress the ipAddress value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withIpAddress(IpAddress ipAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withIpAddress(ipAddress);
        return this;
    }

    /**
     * Get the osType property: The operating system type required by the containers in the container group.
     *
     * @return the osType value.
     */
    public OperatingSystemTypes osType() {
        return this.innerProperties() == null ? null : this.innerProperties().osType();
    }

    /**
     * Set the osType property: The operating system type required by the containers in the container group.
     *
     * @param osType the osType value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withOsType(OperatingSystemTypes osType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withOsType(osType);
        return this;
    }

    /**
     * Get the volumes property: The list of volumes that can be mounted by containers in this container group.
     *
     * @return the volumes value.
     */
    public List<Volume> volumes() {
        return this.innerProperties() == null ? null : this.innerProperties().volumes();
    }

    /**
     * Set the volumes property: The list of volumes that can be mounted by containers in this container group.
     *
     * @param volumes the volumes value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withVolumes(List<Volume> volumes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withVolumes(volumes);
        return this;
    }

    /**
     * Get the instanceView property: The instance view of the container group. Only valid in response.
     *
     * @return the instanceView value.
     */
    public ContainerGroupPropertiesInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    /**
     * Get the diagnostics property: The diagnostic information for a container group.
     *
     * @return the diagnostics value.
     */
    public ContainerGroupDiagnostics diagnostics() {
        return this.innerProperties() == null ? null : this.innerProperties().diagnostics();
    }

    /**
     * Set the diagnostics property: The diagnostic information for a container group.
     *
     * @param diagnostics the diagnostics value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withDiagnostics(ContainerGroupDiagnostics diagnostics) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withDiagnostics(diagnostics);
        return this;
    }

    /**
     * Get the subnetIds property: The subnet resource IDs for a container group.
     *
     * @return the subnetIds value.
     */
    public List<ContainerGroupSubnetId> subnetIds() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetIds();
    }

    /**
     * Set the subnetIds property: The subnet resource IDs for a container group.
     *
     * @param subnetIds the subnetIds value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withSubnetIds(List<ContainerGroupSubnetId> subnetIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withSubnetIds(subnetIds);
        return this;
    }

    /**
     * Get the dnsConfig property: The DNS config information for a container group.
     *
     * @return the dnsConfig value.
     */
    public DnsConfiguration dnsConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsConfig();
    }

    /**
     * Set the dnsConfig property: The DNS config information for a container group.
     *
     * @param dnsConfig the dnsConfig value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withDnsConfig(DnsConfiguration dnsConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withDnsConfig(dnsConfig);
        return this;
    }

    /**
     * Get the sku property: The SKU for a container group.
     *
     * @return the sku value.
     */
    public ContainerGroupSku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    /**
     * Set the sku property: The SKU for a container group.
     *
     * @param sku the sku value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withSku(ContainerGroupSku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    /**
     * Get the encryptionProperties property: The encryption properties for a container group.
     *
     * @return the encryptionProperties value.
     */
    public EncryptionProperties encryptionProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionProperties();
    }

    /**
     * Set the encryptionProperties property: The encryption properties for a container group.
     *
     * @param encryptionProperties the encryptionProperties value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withEncryptionProperties(EncryptionProperties encryptionProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withEncryptionProperties(encryptionProperties);
        return this;
    }

    /**
     * Get the initContainers property: The init containers for a container group.
     *
     * @return the initContainers value.
     */
    public List<InitContainerDefinition> initContainers() {
        return this.innerProperties() == null ? null : this.innerProperties().initContainers();
    }

    /**
     * Set the initContainers property: The init containers for a container group.
     *
     * @param initContainers the initContainers value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withInitContainers(List<InitContainerDefinition> initContainers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withInitContainers(initContainers);
        return this;
    }

    /**
     * Get the extensions property: extensions used by virtual kubelet.
     *
     * @return the extensions value.
     */
    public List<DeploymentExtensionSpec> extensions() {
        return this.innerProperties() == null ? null : this.innerProperties().extensions();
    }

    /**
     * Set the extensions property: extensions used by virtual kubelet.
     *
     * @param extensions the extensions value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withExtensions(List<DeploymentExtensionSpec> extensions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withExtensions(extensions);
        return this;
    }

    /**
     * Get the confidentialComputeProperties property: The properties for confidential container group.
     *
     * @return the confidentialComputeProperties value.
     */
    public ConfidentialComputeProperties confidentialComputeProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().confidentialComputeProperties();
    }

    /**
     * Set the confidentialComputeProperties property: The properties for confidential container group.
     *
     * @param confidentialComputeProperties the confidentialComputeProperties value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withConfidentialComputeProperties(
        ConfidentialComputeProperties confidentialComputeProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withConfidentialComputeProperties(confidentialComputeProperties);
        return this;
    }

    /**
     * Get the priority property: The priority of the container group.
     *
     * @return the priority value.
     */
    public ContainerGroupPriority priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    /**
     * Set the priority property: The priority of the container group.
     *
     * @param priority the priority value to set.
     * @return the ContainerGroupInner object itself.
     */
    public ContainerGroupInner withPriority(ContainerGroupPriority priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (innerProperties() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property innerProperties in model ContainerGroupInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ContainerGroupInner.class);
}
