/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.spring.security.auth0;

import com.auth0.spring.security.auth0.Auth0JWTToken;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.filter.GenericFilterBean;

public class Auth0AuthenticationFilter
extends GenericFilterBean {
    @Autowired
    private AuthenticationManager authenticationManager;
    private AuthenticationEntryPoint entryPoint;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (request.getMethod().equals("OPTIONS")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String jwt = this.getToken(request);
        if (jwt != null) {
            try {
                Auth0JWTToken token = new Auth0JWTToken(jwt);
                Authentication authResult = this.authenticationManager.authenticate((Authentication)token);
                SecurityContextHolder.getContext().setAuthentication(authResult);
            }
            catch (AuthenticationException failed) {
                SecurityContextHolder.clearContext();
                this.entryPoint.commence(request, response, failed);
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected String getToken(HttpServletRequest httpRequest) {
        String authorizationHeader = httpRequest.getHeader("authorization");
        if (authorizationHeader == null) {
            return null;
        }
        String[] parts = authorizationHeader.split(" ");
        if (parts.length != 2) {
            return null;
        }
        String scheme = parts[0];
        String credentials = parts[1];
        Pattern pattern = Pattern.compile("^Bearer$", 2);
        return pattern.matcher(scheme).matches() ? credentials : null;
    }

    public AuthenticationEntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(AuthenticationEntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }
}

