/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader.util;

import com.apptasticsoftware.rssreader.DateTime;
import com.apptasticsoftware.rssreader.Item;
import java.time.Instant;
import java.util.Comparator;

public final class ItemComparator {
    private ItemComparator() {
    }

    public static <I extends Item> Comparator<I> oldestItemFirst() {
        return Comparator.comparing(i -> i.getPubDate().map(DateTime::toInstant).orElse(Instant.EPOCH));
    }

    public static <I extends Item> Comparator<I> newestItemFirst() {
        return Comparator.comparing(i -> i.getPubDate().map(DateTime::toInstant).orElse(Instant.EPOCH)).reversed();
    }

    public static <I extends Item> Comparator<I> channelTitle() {
        return Comparator.comparing(i -> i.getChannel().getTitle());
    }
}

