/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader;

import com.apptasticsoftware.rssreader.Channel;
import com.apptasticsoftware.rssreader.DateTime;
import com.apptasticsoftware.rssreader.Enclosure;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

public class Item
implements Comparable<Item> {
    private String title;
    private String description;
    private String link;
    private String author;
    private String category;
    private String guid;
    private Boolean isPermaLink;
    private String pubDate;
    private Channel channel;
    private Enclosure enclosure;

    public Optional<Enclosure> getEnclosure() {
        return Optional.ofNullable(this.enclosure);
    }

    public void setEclosure(Enclosure enclosure) {
        this.enclosure = enclosure;
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Optional<String> getLink() {
        return Optional.ofNullable(this.link);
    }

    public void setLink(String link) {
        this.link = link;
    }

    public Optional<String> getAuthor() {
        return Optional.ofNullable(this.author);
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Optional<String> getCategory() {
        return Optional.ofNullable(this.category);
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Optional<String> getGuid() {
        return Optional.ofNullable(this.guid);
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public Optional<Boolean> getIsPermaLink() {
        return Optional.ofNullable(this.isPermaLink);
    }

    public void setIsPermaLink(boolean isPermaLink) {
        this.isPermaLink = isPermaLink;
    }

    public Optional<String> getPubDate() {
        return Optional.ofNullable(this.pubDate);
    }

    public void setPubDate(String pubDate) {
        this.pubDate = pubDate;
    }

    public Optional<ZonedDateTime> getPubDateZonedDateTime() {
        return this.getPubDate().map(DateTime::toZonedDateTime);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Item)) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.getTitle(), item.getTitle()) && Objects.equals(this.getDescription(), item.getDescription()) && Objects.equals(this.getLink(), item.getLink()) && Objects.equals(this.getAuthor(), item.getAuthor()) && Objects.equals(this.getCategory(), item.getCategory()) && Objects.equals(this.getGuid(), item.getGuid()) && Objects.equals(this.getIsPermaLink(), item.getIsPermaLink()) && Objects.equals(this.getPubDate(), item.getPubDate()) && Objects.equals(this.getChannel(), item.getChannel()) && Objects.equals(this.getEnclosure(), item.getEnclosure());
    }

    public int hashCode() {
        return Objects.hash(this.getTitle(), this.getDescription(), this.getLink(), this.getAuthor(), this.getCategory(), this.getGuid(), this.getIsPermaLink(), this.getPubDate(), this.getChannel(), this.getEnclosure());
    }

    @Override
    public int compareTo(Item o) {
        return DateTime.pubDateComparator().compare(this, o);
    }
}

