/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader;

import com.apptasticsoftware.rssreader.Item;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;

public class DateTime {
    private static ZoneId defaultZone = ZoneId.of("UTC");

    private DateTime() {
    }

    public static void setDefaultZone(ZoneId defaultZone) {
        DateTime.defaultZone = defaultZone;
    }

    public static LocalDateTime toLocalDateTime(String dateTime) {
        if (dateTime == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTime.getDateTimeFormatter(dateTime);
        if (formatter == null) {
            throw new IllegalArgumentException("Unknown date time format " + dateTime);
        }
        return LocalDateTime.parse(dateTime, formatter);
    }

    public static ZonedDateTime toZonedDateTime(String dateTime) {
        if (dateTime == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTime.getDateTimeFormatter(dateTime);
        if (dateTime.length() == 19) {
            LocalDateTime localDateTime = LocalDateTime.parse(dateTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            return ZonedDateTime.of(localDateTime, defaultZone);
        }
        if (formatter == null) {
            throw new IllegalArgumentException("Unknown date time format " + dateTime);
        }
        return ZonedDateTime.parse(dateTime, formatter);
    }

    private static DateTimeFormatter getDateTimeFormatter(String dateTime) {
        if (dateTime.length() >= 29 && dateTime.length() <= 31) {
            return DateTimeFormatter.RFC_1123_DATE_TIME;
        }
        if (dateTime.length() == 20 || dateTime.length() == 25) {
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        }
        if (dateTime.length() == 19) {
            return DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        }
        return null;
    }

    public static Long toEpochMilli(String dateTime) {
        ZonedDateTime zonedDateTime = DateTime.toZonedDateTime(dateTime);
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public static Comparator<Item> pubDateComparator() {
        return Comparator.comparing(i -> i.getPubDate().map(DateTime::toEpochMilli).orElse(0L));
    }
}

