/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.logging.ClientEvent;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.utils.ArgumentGuard;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Objects;

public class FileLogger
extends LogHandler {
    private final String filename;
    private final boolean append;
    private BufferedWriter fileWriter;

    public FileLogger(String filename, boolean append, boolean isVerbose) {
        super(isVerbose ? TraceLevel.Debug : TraceLevel.Notice);
        ArgumentGuard.notNullOrEmpty(filename, "filename");
        this.filename = filename;
        this.append = append;
        this.fileWriter = null;
    }

    public FileLogger(String filename, boolean append, TraceLevel level) {
        super(level);
        ArgumentGuard.notNullOrEmpty(filename, "filename");
        this.filename = filename;
        this.append = append;
        this.fileWriter = null;
    }

    public FileLogger(boolean isVerbose) {
        this(isVerbose ? TraceLevel.Debug : TraceLevel.Notice);
    }

    public FileLogger(TraceLevel level) {
        this("eyes.log", true, level);
    }

    @Override
    public void open() {
        if (this.fileWriter != null) {
            return;
        }
        try {
            File file = new File(this.filename);
            File path = file.getParentFile();
            if (path != null && !path.exists()) {
                System.out.println("No Folder");
                boolean success = path.mkdirs();
                if (success) {
                    System.out.println("Folder created");
                } else {
                    System.out.printf("Failed creating folder %s%n", path.getAbsolutePath());
                }
            }
            this.fileWriter = new BufferedWriter(new FileWriter(file, this.append));
        }
        catch (IOException e) {
            throw new EyesException("Failed to create log file!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessageInner(ClientEvent clientEvent) {
        if (this.fileWriter != null) {
            try {
                BufferedWriter bufferedWriter = this.fileWriter;
                synchronized (bufferedWriter) {
                    this.fileWriter.write(new ObjectMapper().writeValueAsString((Object)clientEvent));
                    this.fileWriter.newLine();
                    this.fileWriter.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void close() {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fileWriter = null;
    }

    @Override
    public boolean isOpen() {
        return this.fileWriter != null;
    }

    public boolean equals(Object other) {
        if (other instanceof FileLogger) {
            return ((FileLogger)other).filename.equals(this.filename);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.filename);
    }
}

