/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacecatalog;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.marketplacecatalog.AWSMarketplaceCatalog;
import com.amazonaws.services.marketplacecatalog.AWSMarketplaceCatalogClientBuilder;
import com.amazonaws.services.marketplacecatalog.model.AWSMarketplaceCatalogException;
import com.amazonaws.services.marketplacecatalog.model.BatchDescribeEntitiesRequest;
import com.amazonaws.services.marketplacecatalog.model.BatchDescribeEntitiesResult;
import com.amazonaws.services.marketplacecatalog.model.CancelChangeSetRequest;
import com.amazonaws.services.marketplacecatalog.model.CancelChangeSetResult;
import com.amazonaws.services.marketplacecatalog.model.DeleteResourcePolicyRequest;
import com.amazonaws.services.marketplacecatalog.model.DeleteResourcePolicyResult;
import com.amazonaws.services.marketplacecatalog.model.DescribeChangeSetRequest;
import com.amazonaws.services.marketplacecatalog.model.DescribeChangeSetResult;
import com.amazonaws.services.marketplacecatalog.model.DescribeEntityRequest;
import com.amazonaws.services.marketplacecatalog.model.DescribeEntityResult;
import com.amazonaws.services.marketplacecatalog.model.GetResourcePolicyRequest;
import com.amazonaws.services.marketplacecatalog.model.GetResourcePolicyResult;
import com.amazonaws.services.marketplacecatalog.model.ListChangeSetsRequest;
import com.amazonaws.services.marketplacecatalog.model.ListChangeSetsResult;
import com.amazonaws.services.marketplacecatalog.model.ListEntitiesRequest;
import com.amazonaws.services.marketplacecatalog.model.ListEntitiesResult;
import com.amazonaws.services.marketplacecatalog.model.ListTagsForResourceRequest;
import com.amazonaws.services.marketplacecatalog.model.ListTagsForResourceResult;
import com.amazonaws.services.marketplacecatalog.model.PutResourcePolicyRequest;
import com.amazonaws.services.marketplacecatalog.model.PutResourcePolicyResult;
import com.amazonaws.services.marketplacecatalog.model.StartChangeSetRequest;
import com.amazonaws.services.marketplacecatalog.model.StartChangeSetResult;
import com.amazonaws.services.marketplacecatalog.model.TagResourceRequest;
import com.amazonaws.services.marketplacecatalog.model.TagResourceResult;
import com.amazonaws.services.marketplacecatalog.model.UntagResourceRequest;
import com.amazonaws.services.marketplacecatalog.model.UntagResourceResult;
import com.amazonaws.services.marketplacecatalog.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.BatchDescribeEntitiesRequestProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.BatchDescribeEntitiesResultJsonUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.CancelChangeSetRequestProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.CancelChangeSetResultJsonUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.DeleteResourcePolicyRequestProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.DeleteResourcePolicyResultJsonUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.DescribeChangeSetRequestProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.DescribeChangeSetResultJsonUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.DescribeEntityRequestProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.DescribeEntityResultJsonUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.GetResourcePolicyRequestProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.GetResourcePolicyResultJsonUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.InternalServiceExceptionUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.ListChangeSetsRequestProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.ListChangeSetsResultJsonUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.ListEntitiesRequestProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.ListEntitiesResultJsonUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.PutResourcePolicyRequestProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.PutResourcePolicyResultJsonUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.ResourceNotSupportedExceptionUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.StartChangeSetRequestProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.StartChangeSetResultJsonUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.marketplacecatalog.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMarketplaceCatalogClient
extends AmazonWebServiceClient
implements AWSMarketplaceCatalog {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMarketplaceCatalog.class);
    private static final String DEFAULT_SIGNING_NAME = "aws-marketplace";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceInUseExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotSupportedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotSupportedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServiceException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServiceExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSMarketplaceCatalogException.class));

    public static AWSMarketplaceCatalogClientBuilder builder() {
        return AWSMarketplaceCatalogClientBuilder.standard();
    }

    AWSMarketplaceCatalogClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSMarketplaceCatalogClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("catalog.marketplace");
        this.setEndpoint("catalog.marketplace.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/marketplacecatalog/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/marketplacecatalog/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchDescribeEntitiesResult batchDescribeEntities(BatchDescribeEntitiesRequest request) {
        request = (BatchDescribeEntitiesRequest)this.beforeClientExecution(request);
        return this.executeBatchDescribeEntities(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDescribeEntitiesResult executeBatchDescribeEntities(BatchDescribeEntitiesRequest batchDescribeEntitiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDescribeEntitiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDescribeEntitiesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDescribeEntitiesRequestProtocolMarshaller(protocolFactory).marshall((BatchDescribeEntitiesRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDescribeEntitiesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Catalog");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchDescribeEntities");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDescribeEntitiesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDescribeEntitiesResult batchDescribeEntitiesResult = (BatchDescribeEntitiesResult)response.getAwsResponse();
            return batchDescribeEntitiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CancelChangeSetResult cancelChangeSet(CancelChangeSetRequest request) {
        request = (CancelChangeSetRequest)this.beforeClientExecution(request);
        return this.executeCancelChangeSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelChangeSetResult executeCancelChangeSet(CancelChangeSetRequest cancelChangeSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelChangeSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelChangeSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelChangeSetRequestProtocolMarshaller(protocolFactory).marshall((CancelChangeSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelChangeSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Catalog");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelChangeSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelChangeSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelChangeSetResult cancelChangeSetResult = (CancelChangeSetResult)response.getAwsResponse();
            return cancelChangeSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteResourcePolicyResult deleteResourcePolicy(DeleteResourcePolicyRequest request) {
        request = (DeleteResourcePolicyRequest)this.beforeClientExecution(request);
        return this.executeDeleteResourcePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteResourcePolicyResult executeDeleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteResourcePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteResourcePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteResourcePolicyRequestProtocolMarshaller(protocolFactory).marshall((DeleteResourcePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteResourcePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Catalog");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteResourcePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteResourcePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteResourcePolicyResult deleteResourcePolicyResult = (DeleteResourcePolicyResult)response.getAwsResponse();
            return deleteResourcePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeChangeSetResult describeChangeSet(DescribeChangeSetRequest request) {
        request = (DescribeChangeSetRequest)this.beforeClientExecution(request);
        return this.executeDescribeChangeSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeChangeSetResult executeDescribeChangeSet(DescribeChangeSetRequest describeChangeSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeChangeSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeChangeSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeChangeSetRequestProtocolMarshaller(protocolFactory).marshall((DescribeChangeSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeChangeSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Catalog");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeChangeSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeChangeSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeChangeSetResult describeChangeSetResult = (DescribeChangeSetResult)response.getAwsResponse();
            return describeChangeSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEntityResult describeEntity(DescribeEntityRequest request) {
        request = (DescribeEntityRequest)this.beforeClientExecution(request);
        return this.executeDescribeEntity(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEntityResult executeDescribeEntity(DescribeEntityRequest describeEntityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEntityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEntityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEntityRequestProtocolMarshaller(protocolFactory).marshall((DescribeEntityRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEntityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Catalog");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEntity");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEntityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEntityResult describeEntityResult = (DescribeEntityResult)response.getAwsResponse();
            return describeEntityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResourcePolicyResult getResourcePolicy(GetResourcePolicyRequest request) {
        request = (GetResourcePolicyRequest)this.beforeClientExecution(request);
        return this.executeGetResourcePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResourcePolicyResult executeGetResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResourcePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResourcePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResourcePolicyRequestProtocolMarshaller(protocolFactory).marshall((GetResourcePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getResourcePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Catalog");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetResourcePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetResourcePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResourcePolicyResult getResourcePolicyResult = (GetResourcePolicyResult)response.getAwsResponse();
            return getResourcePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListChangeSetsResult listChangeSets(ListChangeSetsRequest request) {
        request = (ListChangeSetsRequest)this.beforeClientExecution(request);
        return this.executeListChangeSets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListChangeSetsResult executeListChangeSets(ListChangeSetsRequest listChangeSetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listChangeSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListChangeSetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListChangeSetsRequestProtocolMarshaller(protocolFactory).marshall((ListChangeSetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listChangeSetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Catalog");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListChangeSets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListChangeSetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListChangeSetsResult listChangeSetsResult = (ListChangeSetsResult)response.getAwsResponse();
            return listChangeSetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEntitiesResult listEntities(ListEntitiesRequest request) {
        request = (ListEntitiesRequest)this.beforeClientExecution(request);
        return this.executeListEntities(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEntitiesResult executeListEntities(ListEntitiesRequest listEntitiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEntitiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEntitiesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEntitiesRequestProtocolMarshaller(protocolFactory).marshall((ListEntitiesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEntitiesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Catalog");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEntities");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEntitiesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEntitiesResult listEntitiesResult = (ListEntitiesResult)response.getAwsResponse();
            return listEntitiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Catalog");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutResourcePolicyResult putResourcePolicy(PutResourcePolicyRequest request) {
        request = (PutResourcePolicyRequest)this.beforeClientExecution(request);
        return this.executePutResourcePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutResourcePolicyResult executePutResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putResourcePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutResourcePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutResourcePolicyRequestProtocolMarshaller(protocolFactory).marshall((PutResourcePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putResourcePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Catalog");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutResourcePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutResourcePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutResourcePolicyResult putResourcePolicyResult = (PutResourcePolicyResult)response.getAwsResponse();
            return putResourcePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartChangeSetResult startChangeSet(StartChangeSetRequest request) {
        request = (StartChangeSetRequest)this.beforeClientExecution(request);
        return this.executeStartChangeSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartChangeSetResult executeStartChangeSet(StartChangeSetRequest startChangeSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startChangeSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartChangeSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartChangeSetRequestProtocolMarshaller(protocolFactory).marshall((StartChangeSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)startChangeSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Catalog");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartChangeSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartChangeSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartChangeSetResult startChangeSetResult = (StartChangeSetResult)response.getAwsResponse();
            return startChangeSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Catalog");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Marketplace Catalog");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

